<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class CourseCategory extends Model
{
    private static $courseCategory;
    use HasFactory;
    public static function addOrUpdate($request){
//        dd($request->status);
        if(CourseCategory::find($request->id)){
            self::$courseCategory = CourseCategory::find($request->id);
        }

        else{
            self::$courseCategory = new CourseCategory();
        }
        
        $slug = Str::slug($request->name); // Convert sentence to slug with hyphens
        $randomNumber = rand(1000, 9999);
        // self::$courseCategory->slug = $slug.'-'.$randomNumber;
        self::$courseCategory->slug = $slug;
            
        self::$courseCategory->name          = $request->name;
        self::$courseCategory->status     = $request->status;
        if ($request->file('image')) {
            if (self::$courseCategory->image) {
                if (file_exists(self::$courseCategory->image)) {
                    unlink(self::$courseCategory->image);
                }
                self::$courseCategory->image = self::saveImageUrl($request);
            } else {
                self::$courseCategory->image = self::saveImageUrl($request);
            }
        }

        self::$courseCategory->save();
    }

    public static function remove($id){
        self::$courseCategory = CourseCategory::find($id);
        if(self::$courseCategory->image){
            unlink(self::$courseCategory->image);
        }
        self::$courseCategory->delete();
    }

    private static function saveImageUrl($request){
        $image = $request->file('image');
        $imageName = $request->name. uniqid(). '.' . $image->extension();
        $directory = 'uploads/course-categories/';
        $imageUrl = $directory.$imageName;
        $image->move($directory, $imageName);

        return $imageUrl;
    }
    public function courses()
    {
        return $this->hasMany(Course::class, 'category_id')->where('course_status_id', 1);
    }
}


