<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CourseBenefit extends Model
{
    use HasFactory;

    private static $benefit;

    public static function add($request, $course_id){
        for($i=0; $i<count($request->benefit); $i++){
            self::$benefit = new CourseBenefit();
            self::$benefit->course_id = $course_id;
            self::$benefit->benefit = $request->benefit[$i];
            self::$benefit->description = $request->description[$i];

            self::$benefit->thumbnail = self::saveImageUrl($request->thumbnail[$i]);

            self::$benefit->save();
        }
    }

    public static function change($request)
    {
//        dd($request);
        for($i=0; $i<count($request->benefits); $i++){
            self::$benefit = CourseBenefit::find($request->benefits[$i]);
            self::$benefit->benefit = $request->existing_benefit[$i];
            self::$benefit->description = $request->existing_description[$i];
            $file = 'existing_thumbnail_'. $request->benefits[$i];
            if ($request->file($file)) {
                // dd('ok');
                if (self::$benefit->thumbnail) {
                    if (file_exists(self::$benefit->thumbnail)) {
                        unlink(self::$benefit->thumbnail);
                    }
                    self::$benefit->thumbnail = self::saveImageUrl($request->$file);
                } else {
                    self::$benefit->thumbnail = self::saveImageUrl($request->$file);
                }
            }

//            self::$benefit->thumbnail = self::saveImageUrl($request->existing_thumbnail[$i]);

            self::$benefit->save();
        }


    }

    private static function saveImageUrl($request){
//        dd($request);
        $image = $request;
        $imageName = 'benefit'.date('ymdhis').rand(000, 999999). '.' . $image->extension();
        $directory = 'uploads/courses/benefits/';
        $imageUrl = $directory.$imageName;
        $image->move($directory, $imageName);

        return $imageUrl;
    }

    public static function remove($id)
    {
        self::$benefit = CourseBenefit::where('course_id', $id)->get();
        foreach (self::$benefit as $benefit) {
            if($benefit->thumbnail){
                if (file_exists($benefit->thumbnail)) {
                    unlink($benefit->thumbnail);
                }
            }
            $benefit->delete();
        }
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }
}
