<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CourseBatch extends Model
{
    use HasFactory;

    private static $batch;

    public static function addOrUpdate($request)
    {
        $array = [];
        if(CourseBatch::find($request->id)){
            self::$batch = CourseBatch::find($request->id);
        }
        else{
            self::$batch = new CourseBatch();
            $lastBatch = CourseBatch::orderBy('id', 'desc')->first();
            if($lastBatch){
                $id = (integer)$lastBatch->batch_code;
            }
            else{
                $id = 0;
            }
            self::$batch->batch_code = str_repeat('0', max(0, 2 - strlen($id+1))).$id+1; ;
        }
        self::$batch->course_id = $request->course_id;
        self::$batch->branch_id = $request->branch_id;
        self::$batch->session_id = $request->session_id;
        self::$batch->teacher_id = $request->teacher_id;
        self::$batch->batch_name = $request->batch_name;
        self::$batch->max_student = $request->max_student;
        self::$batch->time = $request->time;
        self::$batch->batch_type = $request->batch_type;
        self::$batch->status = $request->status;

        foreach ($request->days as $day) {
//            dd($day);
            array_push($array, $day);
        }
        self::$batch->days = json_encode($array);
        self::$batch->save();
    }

    public static function addBatchFromCourse($request, $course_id)
    {
        for ($i=0; $i<count($request->branch_id); $i++) {
            $array = [];
            $day = 'days'.$i+1;

            self::$batch = new CourseBatch();
            self::$batch->course_id   = $course_id;
            self::$batch->branch_id   = $request->branch_id[$i];
            self::$batch->session_id  = $request->session_id[$i];
            self::$batch->teacher_id  = $request->teacher_id[$i];
            self::$batch->batch_name  = $request->batch_name[$i];
            self::$batch->max_student = $request->max_student[$i];
            self::$batch->time        = $request->time[$i];
            self::$batch->batch_type = $request->batch_type[$i];

            $lastBatch = CourseBatch::orderBy('id', 'desc')->first();
//            dd($lastBatch);
            if($lastBatch){
                $id = (integer)$lastBatch->batch_code;
//                dd($id);
            }
            else{
                $id = 0;
            }
            self::$batch->batch_code = str_repeat('0', max(0, 2 - strlen($id+1))).$id+1; ;
            foreach ($request->$day as $day) {

                array_push($array, $day);
            }
            self::$batch->days = json_encode($array);
            self::$batch->save();
        }
    }

    public static function updateBatchFromCourse($request)
    {
        // dd($request);
        for ($i=0; $i<count($request->branch_id); $i++) {
            $array = [];
            $day = 'days' . $i + 1;

            if(isset($request->batch_ids[$i])){
                self::$batch = CourseBatch::where('id', $request->batch_ids[$i])->first();
            }
            else{
                self::$batch = new CourseBatch();
            }

            self::$batch->course_id = $request->id;
            self::$batch->branch_id = $request->branch_id[$i];
            self::$batch->session_id = $request->session_id[$i];
            self::$batch->teacher_id = $request->teacher_id[$i];
            self::$batch->batch_name = $request->batch_name[$i];
            self::$batch->max_student = $request->max_student[$i];
            self::$batch->time = $request->time[$i];
            self::$batch->batch_type = $request->batch_type[$i];

            $lastBatch = CourseBatch::orderBy('id', 'desc')->first();

            foreach ($request->$day as $day) {
                array_push($array, $day);
            }
            self::$batch->days = json_encode($array);
            self::$batch->save();
        }
    }

    public static function remove($id)
    {
        self::$batch = CourseBatch::find($id);
        self::$batch->delete();
    }
    public function teacher()
    {
        return $this->belongsTo(Teacher::class, 'teacher_id');
    }
    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    public function session()
    {
        return $this->belongsTo(Session::class, 'session_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id');
    }

}
