<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Course extends Model
{
    use HasFactory;
    private static $course;

    public static function addOrUpdate($request){
        if(Course::find($request->id)){
            self::$course = Course::find($request->id);
        }

        else{
            self::$course = new Course();
            
            $courseCode = (int) getLastCourseCode();
            $courseCode = $courseCode+1;
            if($courseCode<10){
                $courseCode = '0'.$courseCode;
            }
            
            self::$course->course_code          = $courseCode ;
        }
        
        $slug = Str::slug($request->course_name); // Convert sentence to slug with hyphens
        $randomNumber = rand(1000, 9999);
        // self::$course->slug = $slug.$randomNumber;
        self::$course->slug = $slug;
        
        if($request->is_show_project && $request->is_show_project == 1){
            $is_show_project = 1;
        }else{
            $is_show_project = 0;
        }
        
        if($request->is_show_more && $request->is_show_more == 1){
            $is_show_more = 1;
        }else{
            $is_show_more = 0;
        }
        
        self::$course->category_id          = $request->category_id;
        self::$course->course_name          = $request->course_name;
        self::$course->crt_course_name      = $request->crt_course_name;
        self::$course->course_duration      = $request->course_duration;
        self::$course->course_link          = $request->course_link;
        self::$course->course_medium_id     = $request->course_medium_id;
        self::$course->course_type          = $request->course_type ;
        self::$course->course_fee           = $request->course_fee;
        self::$course->discount             = $request->discount;
        self::$course->total_lectures       = $request->total_lectures;
        self::$course->project              = $request->project;
        self::$course->is_show_project      = $is_show_project;
        self::$course->course_description   = $request->course_description;
        self::$course->more_about           = $request->more_about;
        self::$course->is_show_more         = $is_show_more;
        self::$course->start_date           = $request->start_date;
        self::$course->course_status_id     = $request->course_status_id ;
        self::$course->is_trending          = $request->is_trending ;
        self::$course->is_trending          = $request->is_trending ;
        self::$course->intro_video          = $request->intro_video ;
        if ($request->file('image')) {
            // dd('ok');
            if (self::$course->image) {
                if (file_exists(self::$course->image)) {
                    unlink(self::$course->image);
                }
                self::$course->image = self::saveImageUrl($request);
            } else {
                self::$course->image = self::saveImageUrl($request);
            }
        }

        self::$course->save();
        return self::$course;
    }

    public static function remove($id){
        self::$course = Course::find($id);
        if(self::$course){
            if(file_exists(self::$course->image)){
                unlink(self::$course->image);
            }
            self::$course->delete();
        }
    }

    public static function deleteCategoryCourses($id)
    {
        self::$course = Course::where('category_id', $id)->get();
        foreach (self::$course as $item)
        {
            $item->delete();
        }
    }

    public function courseModule()
    {
        return $this->hasMany(CourseModule::class);
    }

    public function enrollment(){
        return $this->hasMany(CourseEnrollment::class, 'id', 'course_id');
    }

    private static function saveImageUrl($request){
        $image = $request->file('image');
        $imageName = 'Course'.rand(000, 99999). '.' . $image->extension();
        $directory = 'uploads/courses/';
        $imageUrl = $directory.$imageName;
        $image->move($directory, $imageName);

        return $imageUrl;
    }

    public function category(){
        return $this->belongsTo(CourseCategory::class, 'category_id');
    }

    public function batch()
    {
        return $this->hasMany(CourseBatch::class, 'id','course_id');
    }
}
