<?php

namespace App\Http\Controllers;

use App\Models\Webinar;
use App\Models\WebinarBooking;
use Illuminate\Http\Request;

class WebinarBookingController extends Controller
{
    public function submit(Request $request)
    {
        $request->validate([
            'name' => ['required'],
            'email' => ['required'],
            'phone' => ['required'],
            'address' => ['required'],
            'webinar_id' => ['required'],
        ]);

        $existing_webinar = WebinarBooking::where('phone', $request->phone)->where('email', $request->email)->where('webinar_id', $request->webinar_id)->first();
        if($existing_webinar){
            return back()->with('error', 'Already Enrolled For the Webinar');
        }

        WebinarBooking::add($request);
        return back()->with('success', 'Enrollment for Webinar Completed Successfully!');
    }

    public function list()
    {
        $booking = WebinarBooking::latest();
        if(isset($_GET['webinar_id']) && $_GET['webinar_id'] > 0){
            $booking = $booking->where('webinar_id', $_GET['webinar_id']);
        }
        if(isset($_GET['course_id']) && $_GET['course_id'] > 0){
            $booking = $booking->where('course_id', $_GET['course_id']);
            $data['webinars'] = Webinar::where('course_id', $_GET['course_id'])->get();
        }

        $data['items'] = $booking->get();
        return view('admin.webinar.booking.list', $data);
    }
}
