<?php

namespace App\Http\Controllers;

use App\Models\Teacher;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    public function edit()
    {
        if(Auth::user()->role == 1){
            $data['item'] = User::where('id', Auth::user()->id)->first()->first();
        }
        else if(Auth::user()->role == 4){
            $data['item'] = Teacher::where('user_id', Auth::user()->id)->first();
        }
        else{
            return redirect()->route('notFound');
        }

        return view('admin.profile.form', $data);
    }

    public function update(Request $request)
    {
//        return $request;
        $request->validate([
            'name' => 'required',
            'email' => 'required | email',

        ]);

        if(Auth::user()->role == 4){
            $request->validate([
                'phone' => 'required | min: 11 | max:16',
                'address' => 'required',
            ]);
        }

        if($request->email != Auth::user()->email){
            $request->validate([
                'email' => 'unique:users',
            ]);
        }

        if(Auth::user()->role == 4){
            Teacher::profileUpdate($request);
            User::updateProfile($request);
        }
        else{
            User::updateProfile($request);
        }
        return back()->with('message', 'Profile Updated Successfully');


    }

    public function passwordEdit()
    {
        return view('admin.password_update.form');
    }

    public function passwordUpdate(Request $request){
        $request->validate([
            'old_password'          => 'required| min:8',
            'password'              => 'required| min:8|confirmed',
            'password_confirmation' => 'required| min:8',
        ]);

        if(password_verify($request->old_password, Auth::user()->password)){
            User::updatePassword($request);
            return back()->with('message', 'Password Updated Successfully');
        }
        else{
            return back()->with('message', 'Password Does not Match');
        }
    }
}
