<?php

namespace App\Http\Controllers;

use App\Models\BranchStudent;
use App\Models\ClassSchedule;
use App\Models\Course;
use App\Models\CourseEnrollment;
use App\Models\CourseResource;
use App\Models\Notice;
use App\Models\Student;
use App\Models\Testimonial;
use App\Utility\SmsUtility;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Session;
use Mail;

class StudentController extends Controller
{
    private $user;

    public function studentSignIn(){
        // return 'ok';
        return view('auth.student.sign-in');
    }
    public function studentSignInSubmit(Request $request){
        // return $request;
        $credentials = $request->validate([
            'email' => ['required'],
            'password' => ['required'],
        ]);
        if (Auth::attempt($credentials) || Auth::attempt(['phone' => $request->email, 'password'=> $request->password])) {
            $user = User::where('email', $request->email)->orWhere('phone', $request->email)->first();
            if($user != null && ($user->role == 1 || $user->role == 4)){
                Auth::logout();
                return back()->with('error','Can Not Login in Student Panel');
            }

            else{
                $request->session()->regenerate();
                $route = Session::get('currentCourseRoute');
                $course = Session::get('currentCourseId');
                // dd( $route, $course);
                if($route == null){
                    return redirect()->route('student.dashboard')->with('success','Successfully Logged In');
                }
                else{

                    return redirect()->route($route, $course);
                }

            }

        }
        else{
            Auth::logout();
        }

        // return back()->withErrors([
        //     'err_msg' => ['The credentials does not match our records.']
        // ]);
        return back()->with('error','The credentials does not match our records');
        // ]);
    }
    public function studentSignUp(){
        return view('auth.student.sign-up');
    }

    public function studentSignUpSubmit(Request $request){
        // return $request;
        $request->validate([
            'student_name' => ['required'],
            'student_email' => ['required', 'unique:students', ],
            'student_phone' => ['required', 'min:11', 'max: 17', 'unique:students'],
//            'student_image' => ['required', 'mimes:jpeg,jpg', 'max:2048'],
            'password' => ['required', 'min:8', 'confirmed'],
        ]);
        $verifycode = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
        Session::put('verification_code', $verifycode);

        Session::put('request', [
            'student_name' => $request->student_name,
            'student_email' => $request->student_email,
            'student_phone' => $request->student_phone,
//            'student_image' => $filePath,
            'password' => $request->password,
        ]);
//        dd(Session::get('request')['student_image']);
        if(getSettings('email_verification') == 1){
            $data['email'] = $request->student_email;
            $data['title'] = 'Verification Code';
            Mail::send('auth.student.verification_code', ['code'=> $verifycode ], function ($message) use ($data) {
                $message->to($data['email'])
                    ->subject($data["title"]);
            });
            $text = 'Please Verify Your Email Address';
        }
        else{
            $to = $request->student_phone;
            $message = "Your verification code is ". $verifycode.'.';
            SmsUtility::sendSMS($to, $message);
            $text = "Please Verify Your Phone Number";
        }
        return redirect()->route('student.email.verification')->with('info', $text);

    }

    public function dashboard(){

        $student = Student::where('user_id', Auth::user()->id)->first();
        $data['enrolled_courses'] = getEnrolledCourses()->paginate(10);
        $courseIds = CourseEnrollment::where('student_id', $student->id)->where('status', 1)->pluck('course_id')->toArray();
        $batchIds = CourseEnrollment::where('student_id', $student->id)->where('status', 1)->pluck('batch_id')
        ->toArray();

        // Get notices for the enrolled courses

        $data['notice'] = Notice::whereIn('branch_id', $courseIds)->where('notice_status_id', 1)->latest()->first();
        $data['todays_classes'] = ClassSchedule::where('date', date('Y-m-d'))->whereIn('batch_id', $batchIds)->get();

        return view('frontend.student.dashboard', $data);
    }

    public function courses(){
        $data['enrolled_courses'] = getEnrolledCourses()->paginate(10);

        return view('frontend.student.courses', $data);
    }
     public function curriculum($slug){
        $data['item'] = Course::where('slug', $slug)->first();
        $id = $data['item']->id;
        $student = Student::where('user_id', Auth::user()->id)->first();
        $enrolled_batch = CourseEnrollment::where('course_id', $id)->where('student_id', $student->id)->first();
        $data['resources'] = CourseResource::where('course_id', $id)->orderBy('type', 'desc')->get();
        $data['completed_classes'] = ClassSchedule::where('course_id', $id)->where('status', 2)->where('batch_id', $enrolled_batch->batch_id)->orderBy('date', 'desc')->get();
//        dd($data['completed_classes'], $enrolled_batch);
        return view('frontend.student.curriculum',$data);
     }
    public function edit(){
        $data['item'] = Student::where('user_id', Auth::user()->id)->first();
        return view('frontend.student.profile', $data);
    }

    public function profileUpdate(Request $request){
        // return $request;
        $request->validate([
            'student_name'  => ['required'],
            'student_phone' => ['required', 'min:11', 'max: 17'],
            'student_email' => ['required'],
            // 'student_image' => ['required', 'mimes:jpeg,jpg', 'max:2048'],

        ]);

        $this->user = User::addOrUpdate($request);
        // dd('ok');
        $student = Student::addOrUpdate($request, $this->user->id);
        return back();
    }

    public function getPassword(){
        $student = Student::where('user_id', $_GET['id'])->first();
        return response()->json($student->password);
    }

    public function passwordUpdate(Request $request){
//         return $request;
        $request->validate([
            'password'=> ['required', 'confirmed']
        ]);
        if(Auth::check()){
            $student = Student::where('user_id', Auth::user()->id)->first();
        }
        elseif(Session::get('request') != null){
            $student = Student::where('student_email', Session::get('request')['student_email'])->orWhere('student_phone', Session::get('request')['student_email'])->first();
        }
        else{
            return back()->with('Error', 'Error Occurred');
        }

        $student->password = $request->password;
        $student->save();

        $user = User::find($student->user_id);
        $user->password = bcrypt($request->password);
        $user->save();
        Auth::logout();

        return redirect()->route('home')->with('success', 'Password Changed Successfully');
    }

    public function notice(){

        $student = Student::where('user_id', Auth::user()->id)->first();
        $courseIds = CourseEnrollment::where('student_id', $student->id)->where('status', 1)->pluck('course_id')->toArray();
        $batchIds = CourseEnrollment::where('student_id', $student->id)->where('status', 1)->pluck('batch_id')
        ->toArray();
//        dd($courseIds);

        // Get notices for the enrolled courses

        $data['notices'] = Notice::whereIn('branch_id', $courseIds)->where('notice_status_id', 1)->where(function ($query) use($batchIds){
            return $query->whereIn('batch_id', $batchIds)->orWhere('batch_id', 0);
        })->latest()->get();
        return view('frontend.student.notice', $data);
    }

    public function reviewCourse($slug)
    {
        $student = Student::where('user_id', Auth::user()->id)->first();
        $course = Course::where('slug', $slug)->first();
        $testimonial = Testimonial::where('student_id', $student->id)->where('course_id', $course->id)->first();

        if( $testimonial!= null){
//            return Testimonial::where('student_id', $student->id)->where('course_id', $id)->get();
            return back()->with('message', 'Already Reviewed');
        }
        else{
            $data['course_id'] = $course->id;
            return view('frontend.student.review', $data);
        }

    }

    public function emailVerify()
    {
        return view('auth.student.email-verify');
    }

    public function verificationSubmit(Request $request)
    {
    //    return $request;
        $code = Session::get('verification_code');
        if($code != null){
            if($request->code == $code){

                $student_request = Session::get('request');

                $request->student_name = $student_request['student_name'];
                $request->student_phone = $student_request['student_phone'];
                $request->student_email = $student_request['student_email'];
                $request->password = $student_request['password'];
                $request->student_status_id = 1;
//                return $request;
//                $request->student_image = $student_request['student_image'];
                Session::forget('request');
                Session::forget('verification_code');
                $this->user = User::addOrUpdate($request);
                $student = Student::addOrUpdate($request, $this->user->id);
                BranchStudent::addOrUpdate($request, $student->id);

                Auth::login($this->user);
                return redirect()->route('student.dashboard')->with('success', 'Your Request Has Been Submitted Successfully!!');

            }
            else{
                return back()->with('error', 'Invalid Code');
            }
        }
        else{
            return redirect()->route('student.sign-up')->with('error', 'Session Expired !!');
        }

    }

    public function resendCode()
    {
        $request = Session::get('request');
        if($request != null){
            $data['email'] = $request['student_email'];
            $verifycode = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
            Session::put('verification_code', $verifycode);
            if (getSettings('email_verification') == 1){
                $data['title'] = 'Verification Code';
                Mail::send('auth.student.verification_code', ['code'=> $verifycode ], function ($message) use ($data) {
                    $message->to($data['email'])
                        ->subject($data["title"]);
                });
                $text = "Email";
            }
            else{
                $to = $request['student_email'];
                $message = "Your verification code is ". $verifycode.'.';
                SmsUtility::sendSMS($to, $message);
                $text = "Phone Number";
            }

            return back()->with('success', 'Code Sent To Your Provided '. $text.'.');
        }
        else{
            return back()->with('error', 'Session Expired Please Sign Up Again');
        }
    }

    public function forgetPassword()
    {
        return view('auth.student.forget-password.forget-password');
    }

    public function forgetPasswordSubmit(Request $request)
    {
//        return $request;
        $request->validate([
            'student_email' => ['required']
        ]);
        $user = User::where('email', $request->student_email)->orWhere('phone', $request->student_email)->first();
        if($user != null){
            $verifycode = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
            Session::put('verification_code', $verifycode);
            Session::put('request', [
                'student_email' => $request->student_email
            ]);

            if (getSettings('email_verification') == 1){
                $data['email'] = $request->student_email;
                $data['title'] = 'Verification Code';
                Mail::send('auth.student.verification_code', ['code'=> $verifycode ], function ($message) use ($data) {
                    $message->to($data['email'])
                        ->subject($data["title"]);
                });
                $text="Email";
            }
            else{
                $to = $request->student_email;
                $message = "Your verification code is ". $verifycode.'.';
                SmsUtility::sendSMS($to, $message);
                $text = "Phone Number";
            }


            return redirect()->route('student.forget-password.verify')->with('success', 'Verification Code Sent To Your '. $text.'.');
        }
        else{
            return back()->with('error', 'Invalid Email');
        }
    }

    public function forgetPasswordVerify()
    {
        return view('auth.student.forget-password.verify');
    }

    public function forgetPasswordVerification(Request $request)
    {
        $request->validate([
            'code' => ['required']
        ]);
        $code = Session::get('verification_code');
//        dd($code);
        if($code != null){
            if($code == $request->code){
                Session::forget('verification_code');
                return redirect()->route('student.password.change');
            }
            else{
                return back()->with('error', 'Invalid Code');
            }
        }
        else{
            return back()->with('error', 'Session Expired Please Try Again');
        }
    }

    public function passwordChange()
    {
        return view('auth.student.forget-password.password-update');
    }

}
