<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\CourseBatch;
use App\Models\Teacher;
use Illuminate\Http\Request;
use App\Models\Notice;
use Illuminate\Support\Facades\Auth;
use App\Models\Student;
use App\Models\Course;

class NoticeController extends Controller
{
    public function add()
    {
        if(Auth::user()->role == 4){
            $teacher = Teacher::where('user_id', Auth::user()->id)->first();
            $courses = CourseBatch::select('course_id')->where('teacher_id', $teacher->id)->distinct()->pluck('course_id')->toArray();
            $data['assgined_courses'] = Course::whereIn('id', $courses)->where('course_status_id', 1)->orderBy('course_name', 'asc')->get();
        }
        else{
            $data['assgined_courses'] = Course::where('course_status_id', 1)->latest()->get();
        }
        return view('admin.notice.form', $data);
    }

    public function submit(Request $request)
    {
//        return $request;
        $this->validation($request);
        Notice::addOrUpdate($request);
        if(Auth::user()->role == 1){
            $route = 'admin';
        }
        else{
            $route = 'teacher';
        }
        return redirect()->route($route.'.notice.list')->with('message', 'Notice Has Been Added Successfully!!');
    }

    public function list()
    {
        if(Auth::user()->role == 2){
            $data['items'] = Notice::where('branch_id', Auth::user()->branch_code)->orWhere('branch_id', '0')->get();
        }
        else if(Auth::user()->role == 4){
            $data['items'] = Notice::where('circulated_by', Auth::user()->id)->orWhere('circulated_by', '1')->get();
        }
        else{
            $data['items'] = Notice::where('circulated_by', Auth::user()->id)->orWhere('notice_status_id', 1)->latest()->get();
        }

        return view('admin.notice.list', $data);
    }

    public function request()
    {

        $data['items'] = Notice::where('circulated_by', '!=', Auth::user()->id)->where('notice_status_id', '!=', 1)->latest()->get();


        return view('admin.notice.list', $data);
    }

    public function edit($id)
    {
        $data['students'] = Student::latest()->get();
        $data['item'] = Notice::find($id);
        $data['batches'] = CourseBatch::where('course_id', $data['item']->branch_id)->get();
        return view('admin.notice.form', $data);
    }

    public function update(Request $request)
    {
        $this->validation($request);
        Notice::addOrUpdate($request);
        return redirect()->route('admin.notice.list')->with('message', 'Notice Information Has Been Update Successfully!!');
    }

    public function remove(Request $request)
    {
        Notice::remove($request->id);
        return back()->with('message', 'Notice Has Been Removed Successfully!!');
    }

    public function validation($request){
        $request->validate([
            'notice_title'=>['required'],
            'notice_description'=>['required'],
            'branch_id'=>['required'],
        ]);
    }
}
