<?php

namespace App\Http\Controllers;

use App\Mail\Testmailreact;
use App\Models\Branch;
use App\Models\BranchStudent;
use App\Models\Certificate;
use App\Models\Coupon;
use App\Models\Course;
use App\Models\CourseBatch;
use App\Models\CourseBenefit;
use App\Models\CourseCategory;
use App\Models\CourseModule;
use App\Models\CourseProject;
use App\Models\CourseResource;
use App\Models\Gallery;
use App\Models\GalleryImage;
use App\Models\LearningContent;
use App\Models\Page;
use App\Models\Student;
use App\Models\User;
use App\Models\Webinar;
use App\Models\WebinarTopic;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Faq;
use App\Models\Offer;
use App\Models\QustionAnswer;
use App\Models\Testimonial;
use Carbon\Carbon;
use App\Utility\SmsUtility;
use Illuminate\Support\Facades\Mail;
use Session;


use Illuminate\Support\Str;


class HomeController extends Controller
{
    private $user;
    public function index()
    {
        $data['about'] = Page::where('key', 'home_about_content')->first();
        $data['recent_courses'] = Course::where('course_status_id', 1)->orderBy('id', 'desc')->get()->take(8);
        $data['popular_courses'] = Course::where('course_status_id', 1)->where('is_trending', 1)->latest()->get()->take(8);
        $data['items'] = CourseCategory::where('status', 1)->orderBy('position', 'asc')->get();
        $data['testimonials'] = Testimonial::where('status', 1)->orderBy('id', 'desc')->get();

        return view('frontend.pages.homepage.index2', $data);
    }

    public function examResult()
    {
        if (isset($_GET['student_roll']) && $_GET['student_roll'] > 0) {
            $data['item'] = BranchStudent::where('student_roll', $_GET['student_roll'])->first();
            return view('frontend.pages.student-result.index', $data);
        }
        return view('frontend.pages.student-result.index');
    }

    public function courses(Request $request)
    {
        // Initial query with course status condition
        $courses = Course::whereIn('course_status_id', [1, 2]);
    
        // Check if 'category' is set in the request and is not empty
        if ($request->has('category') && $request->category != '') {
            $category = CourseCategory::where('slug', $request->category)->first();
            
            if ($category) {
                // Filter by category ID if the category exists
                $courses = $courses->where('category_id', $category->id);
            }
        }
    
        // Execute the query and get the results
        $data['items'] = $courses->orderBy('category_id', 'desc')->get();
    
        // Return the view with the filtered data
        return view('frontend.pages.courses.index', $data);
    }
    
    public function courseDetail($slug)
    {
        $data['item'] = Course::where('slug', $slug)->first();
        if ($data['item'] != null) {
            $id = $data['item']->id;

            $data['batches'] = CourseBatch::where('course_id', $id)->where('status', 1)->get();
            $data['outcomes'] = LearningContent::where('course_id', $id)->where('topic', 'course_outcome')->get();
            $data['software_learning'] = LearningContent::where('course_id', $id)->where('topic', 'software_learning')->get();
            $data['faq'] = Faq::where('course_id', $id)->get();
            $data['resources'] = CourseResource::where('course_id', $id)->orderBy('type', 'desc')->get();
            $data['good_to_know'] = CourseModule::where('course_id', $id)->orderBy('module_name', 'asc')->get();
            $data['webinar'] = Webinar::where('course_id', $id)->where('date', '>=', date('Y-m-d'))->orderBy('date', 'asc')->first();
            if ($data['webinar'] != null) {
                $data['topics'] = WebinarTopic::where('webinar_id', $data['webinar']->id)->get();
            }
            $data['benefits'] = CourseBenefit::where('course_id', $id)->get();
            $data['projects'] = CourseProject::where('course_id', $id)->get();

            // Fetch active branches
            $data['course_branches'] = Branch::where('branch_status_id', 1)->orderBy('branch_type_id', 'asc')->get();

            // Fetch batches grouped by branch
            $data['batches'] = CourseBatch::where('course_id', $id)->where('status', 1)->get()->groupBy('branch_id');

            $data['teachers'] = CourseBatch::select('teacher_id')->where('course_id', $id)->where('status', 1)->distinct()->get();

            return view('frontend.pages.courses.details', $data);
        } else {
            return redirect()->route('not-found');
        }
    }

    public function courseCategory()
    {
        $data['items'] = CourseCategory::where('status', 1)->orderBy('position', 'asc')->get();
        return view('frontend.pages.courses.category', $data);
    }

    public function categoryCourses($slug)
    {
        $data['category'] = CourseCategory::where('slug', $slug)->first();
        if ($data['category'] != null) {
            $id = $data['category']->id;
            $data['items'] = Course::where('category_id', $id)->where('course_status_id', '!=', 0)->orderBy('course_name', 'asc')->get();
            return view('frontend.pages.courses.category_courses', $data);
        } else {
            return redirect()->route('not-found');
        }
    }

    public function gallery()
    {
        $data['items'] = GalleryImage::latest()->get();
        return view('frontend.pages.gallery.index', $data);
    }

    public function checkout($slug)
    {
        $data['item'] = Course::where('slug', $slug)->first();
        $data['batches'] = CourseBatch::where('course_id', $data['item']->id)
                ->where('status', 1)
                ->with('branch')
                ->get();
        return view('frontend.pages.checkout.index', $data);
    }

    public function resources()
    {
        return view('frontend.pages.site-resources.index');
    }

    public function contact()
    {
        // dd(Branch::where('branch_status_id', 1)->orderBy('id', 'desc')->get());
        return view('frontend.pages.contact-us.index');
    }

    public function branches()
    {
        $data = [];
        if (isset($_GET['branch_code']) && $_GET['branch_code'] > 0) {
            $data['item'] = Branch::where('branch_code', $_GET['branch_code'])->first();
        }
        return view('frontend.pages.branches.index', $data);
    }

    public function allWebinar()
    {
        $data['webinars'] = Webinar::where('date', '>=', date('Y-m-d'))->orderBy('date', 'asc')->get();
        return view('frontend.pages.webinar.index', $data);
    }

    public function about()
    {
        $data['about'] = Page::where('key', 'about_content')->first();
        $data['testimonials'] = Testimonial::where('status', 1)->orderBy('id', 'desc')->get();
        // return view('frontend.pages.about-us.index', $data);
        return view('frontend.pages.about-us.index2', $data);
    }

    public function privacyPolicy()
    {
        return view('frontend.pages.privacy-policy.index');
    }

    public function terms()
    {
        return view('frontend.pages.terms-conditions.index');
    }

    public function cookies()
    {
        return view('frontend.pages.cookies.index');
    }

    public function help()
    {
        return view('frontend.pages.help.index');
    }
    public function faq()
    {
        return view('frontend.pages.faq.index');
    }
    public function notFound()
    {
        return view('frontend.pages.not-found.index');
    }

    public function appLink()
    {
        return back()->with('info', 'Coming Soon');
    }

    public function applyCoupon(Request $request)
    {

        // return $request;
        $course_id = $request->course_id;
        $coupon = Coupon::where('coupon_code', $request->coupon_code)
            ->first();
        // dd($coupon);
        if ($coupon->type == 2) {
            $offer = Offer::where('coupon_id', $coupon->id)->first();
            $offer_courses = json_decode($offer->course_ids);
            if (in_array($course_id, $offer_courses) == false) {
                return back()->with('error', 'This coupon is not valid.');
            }
        } else {
            if ($coupon->course_id != 0 && $coupon->course_id != $course_id) {
                return back()->with('error', 'This coupon is not valid.');
            }
        }

        if (session('coupon')) {
            if (session('coupon')['coupon_code'] == $coupon->coupon_code) {
                return back()->with('error', 'You Already Used This Coupon');
            }
        }

        if ($coupon == Null) {
            // dd('null');
            return back()->with('error', 'This coupon is not valid.');
        }

        if ($coupon->expire_date < Carbon::now()) {
            return back()->with('error', 'This coupon has expired.');
        }

        $request->session()->put('coupon', [
            'coupon_id' => $coupon->id,
            'coupon_code' => $coupon->coupon_code,
            'discount_type' => $coupon->discount_type,
            'discount' => $coupon->discount,
        ]);


        return back()->with('success', 'Coupon applied successfully!');
    }

    public function applyCouponAjax(Request $request){
        $course_id = $request->course_id;
        $coupon = Coupon::where('coupon_code', $request->coupon_code)
            ->first();
        // dd($coupon);
        if ($coupon->type == 2) {
            $offer = Offer::where('coupon_id', $coupon->id)->first();
            $offer_courses = json_decode($offer->course_ids);
            if (in_array($course_id, $offer_courses) == false) {
                return back()->with('error', 'This coupon is not valid.');
            }
        } else {
            if ($coupon->course_id != 0 && $coupon->course_id != $course_id) {
                return back()->with('error', 'This coupon is not valid.');
            }
        }

        if (session('coupon')) {
            if (session('coupon')['coupon_code'] == $coupon->coupon_code) {
                return back()->with('error', 'You Already Used This Coupon');
            }
        }

        if ($coupon == Null) {
            // dd('null');
            return back()->with('error', 'This coupon is not valid.');
        }

        if ($coupon->expire_date < Carbon::now()) {
            return back()->with('error', 'This coupon has expired.');
        }

        $request->session()->put('coupon', [
            'coupon_id' => $coupon->id,
            'coupon_code' => $coupon->coupon_code,
            'discount_type' => $coupon->discount_type,
            'discount' => $coupon->discount,
        ]);

        // reduce the total_use_limit
        if ($coupon->total_use_limit !== null) {
            $coupon->decrement('total_use_limit');
        }

        return response()->json(true);
    }

    public function removeCoupon(Request $request)
    {

        $request->session()->forget('coupon');

        return response()->json(true);
        // return back()->with('success', 'Coupon removed successfully!');
    }

    public function submitQustion(Request $request)
    {
        // return $request;
        QustionAnswer::create([
            'email' => $request->email,
            'phone' => $request->phone,
            'qustion' => $request->qustion,
        ]);
        return back()->with('success', 'Your Qustion Successfully Submitted, We Will Reply You Soon!!');
    }

    public function apisendEmail(Request $request)
    {
        $validatedData = $request->validate([
            'step1' => 'required|string',
            'step2' => 'required|string',
            'step3' => 'required|string',
            'step4' => 'required|string',
            'name' => 'required|string|max:255',
            'phone' => 'required|string',
            'email' => 'required|email',
        ]);

        // Create an answer object or use the validated data directly
        $answer = (object) $validatedData; // Convert array to object if needed

        // Send the email
        Mail::to($answer->email)->send(new Testmailreact($answer));

        return response()->json(['message' => 'Email sent successfully']);
    }

    public function verifyCertificate()
    {

        return view('frontend.pages.verify-certificate.index');
    }

    public function submitVerify(Request $request)
    {
        $certificate = Certificate::where('serial_num', $request->serial_num)->first();

        if ($certificate != null) {
            return redirect()->route('certificate.verify')->with([
                'success' => 'Here is your information!',
                'certificate' => $certificate
            ]);
        } else {
            return redirect()->route('certificate.verify')->with('error', 'No information found!');
        }
    }

    public function getBatchesByBranchAndCourse($branch_id, $course_id, $batch_type)
    {
        // Check the course type
        $course = Course::find($course_id);
        
        $batches = array();

        if($course){
            if($branch_id == 0){
                // return response()->json('ok');
                $batches = CourseBatch::where('course_id', $course_id)
                ->where('batch_type', $batch_type)
                ->where('status', 1)
                ->with('branch')
                ->get();
            }
            else{
                $batches = CourseBatch::where('branch_id', $branch_id)
                ->where('course_id', $course_id)
                ->where('batch_type', $batch_type)
                ->where('status', 1)
                ->with('branch')
                ->get();
            }
        }

        return response()->json($batches);
    }
}
