<?php

namespace App\Http\Controllers;

use App\Models\Faq;
use Illuminate\Http\Request;

class FaqController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $faq = Faq::latest();

        $data['items'] = $faq->select('course_id')->distinct()->paginate(50);

        return view('admin.course-faq.list', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.course-faq.form');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $this->validation($request);
        // return $request;
        Faq::add($request);

        return redirect()->route('admin.course.faq.list')->with('message', 'Faq Added Successfully!!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        // dd('ok');
        $data['item'] = Faq::where('course_id', $id)->get();
        $data['course_id'] = $id;
        return view('admin.course-faq.form', $data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $this->validation($request);
        Faq::change($request);

        return redirect()->route('admin.course.faq.list')->with('message', 'Faq Updated Successfully!!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        Faq::remove($request->id);
        return back()->with('message', 'Faq Deleted Successfully!!');
    }

    public function validation($request){
        $request->validate([
            'course_id' => ['required'],
            'question' => ['required'],
            'answer' => ['required']
        ]);
    }
}
