<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\BranchStudent;
use App\Models\ClassSchedule;
use App\Models\CourseBatch;
use App\Models\CourseEnrollment;
use App\Models\ExamAttendance;
use App\Models\StudentAttendance;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use PDF;

class ExamAttendanceController extends Controller
{
    private $exam;
    public function add()
    {
        $students = CourseEnrollment::where('status', 1);
        if(isset($_GET['course_id']) && $_GET['course_id'] >0){
            $students = $students->where('course_id', $_GET['course_id']);
            $data['batches'] = CourseBatch::where('course_id', $_GET['course_id'])->get();
        }
        if(isset($_GET['batch_id']) && $_GET['batch_id'] >0){
            $students = $students->where('batch_id', $_GET['batch_id']);
            $existing_attendance = ExamAttendance::where('teacher_user_id', Auth::user()->id)->where('batch_id', $_GET['batch_id'])->pluck('schedule_id')->toArray();
            $data['schedules'] = ClassSchedule::where('batch_id', $_GET['batch_id'])->where('date', date('Y-m-d'))->whereNotIn('id', $existing_attendance)->get();

        }
        if (isset($_GET['session_id']) && $_GET['session_id'] >0 && isset($_GET['course_id']) && $_GET['course_id'] >0 && isset($_GET['date']) && $_GET['date'] >0){
            if(ExamAttendance::where('date', $_GET['date'])
                ->where('course_id', $_GET['course_id'])
                ->where('session_id', $_GET['session_id'])
                ->where('branch_code', Auth::user()->branch_code)->first()){
                return back();
            }
        }
        $data['items'] = $students->orderBy('student_id', 'asc')->get();

        return view('admin.exam-attendance.form', $data);
    }
    public function submit(Request $request)
    {
//        return $request;
        $request->validate([
            'course_id' => 'required',
            'batch_id' => 'required',
            'schedule_id' => 'required',
        ]);
        $this->exam = ExamAttendance::add($request);
        StudentAttendance::add($this->exam, $request);

        return redirect()->route('teacher.attendance.list')->with('message', 'Attendance Has Been Submitted');
    }

    public function list()
    {
        if (Auth::user()->role == 1){
            $data['items'] = ExamAttendance::latest()->orderBy('date', 'desc')->get();
        }
        else{
            $data['items'] = ExamAttendance::where('teacher_user_id', Auth::user()->id)->latest()->orderBy('date', 'desc')->get();
        }

        return view('admin.exam-attendance.list', $data);
    }
    public function details($id)
    {
        $data['items'] = StudentAttendance::where('exam_id', $id)->get();
        return view('admin.exam-attendance.details', $data);
    }
    public function update(Request $request)
    {
//        return $request;
        $this->exam= ExamAttendance::updateExamAttendance($request);
        StudentAttendance::updateAttendance($this->exam, $request);

        return redirect()->route('teacher.attendance.list')->with('message', 'Exam Attendance Has Been Updated!!');
    }
    public function print($id)
    {
        $this->exam = ExamAttendance::find($id);
        $data['items'] = StudentAttendance::where('exam_id', $id)->get();
        $data['exam'] = $this->exam;
        $pdf = PDF::loadView('admin.exam-attendance.attendance-print', $data);
        return $pdf->stream('Attendance-Sheet-'.$this->exam->course->course_name.'-'.$this->exam->batch->batch_name.'.pdf');
    }
}
