<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\ClassSchedule;
use App\Models\Course;
use App\Models\CourseBatch;
use App\Models\Notice;
use App\Models\Session;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
class DashboardController extends Controller
{
    public function index()
    {
//        foreach (CourseBatch::all() as $id=> $ba){
//            $ba->batch_code = str_repeat('0', max(0, 2 - strlen($id+1))).$id+1;
//            $ba->save();
//        }
        if(Auth::user()->role == 1){
           $data['schedules'] = ClassSchedule::where('date', date('Y-m-d'))->get();
            $data['item'] = Notice::orderBy('id', 'desc')->first();
        }
        elseif(Auth::user()->role == 4){
            $data['schedules'] = ClassSchedule::where('date', date('Y-m-d'))->where('teacher_id', Auth::user()->id)->get();
            $course = CourseBatch::select('course_id')->where('teacher_id', Auth::user()->teacher->id)->distinct()->pluck('course_id')->toArray();
            $batches = CourseBatch::where('teacher_id', Auth::user()->teacher->id)->pluck('id')->toArray();
            $data['item'] = Notice::where('branch_id', 0)->orwhere(function ($query) use($course, $batches){
             $query->whereIn('branch_id', $course)->where(function ($query) use($batches){
                 $query->whereIn('batch_id', $batches)->orWhere('batch_id', 0);
             });
            })->orderBy('id', 'desc')->first();
        }
        else{
            Auth::logout();
            return redirect()->route('login');
        }
        return view('admin.dashboard.dashboard', $data);
    }

    public function profile()
    {
        $data['item'] = Branch::where('branch_code', Auth::user()->branch_code)->first();
        return view('admin.branch.profile', $data);
    }
}
