<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\BranchAccount;
use App\Models\BranchStudent;
use App\Models\Coupon;
use App\Models\CourseBatch;
use Illuminate\Http\Request;
use App\Models\CourseEnrollment;
use App\Models\Student;
use Illuminate\Support\Facades\Auth;
use App\Models\Course;
use Illuminate\Routing\Route;
use Session;

class CourseEnrollmentController extends Controller
{

    public function add(){
        $data['students'] = Student::where('student_status_id', 1)->get();
        return view('admin.course-enrollment.form', $data);
    }

    public function enrollCheck($id){
        // return $id;

        Session::put('currentCourseRoute',  'course.details');
        Session::put('currentCourseId', $id);
        // dd(Session::get('currentCourseId'));

        return redirect()->route('student.sign-in');
    }
    
    public function payment(Request $request) {
        if(Auth::user() && Auth::user()->role == 3){
            //$student = Student::where('user_id', Auth::user()->id)->first();
        }
        else{
            $request->validate([
                'course_id' => ['required'],
                'student_id' => ['required'],
            ]);
            //$student = Student::find($request->student_id);
        }
        // return $student;
        $course_enrollment = CourseEnrollment::where('student_id', $request->student_id)->where('course_id', $request->course_id)->first();
        // dd($course_enrollment);
        if($course_enrollment != null && $course_enrollment->status == 1){
            session()->forget('coupon');
            return back()->with('error', 'Already Enrolled In this Course!!');
        }
        elseif($course_enrollment != null && $course_enrollment->status == 0){
            // dd('ok');
            session()->forget('coupon');
            return back()->with('error', 'Already Applied for this Course!!');
        }
        else{
            $request->validate([
                'payment_method' => ['required'],
                // 'payment_number' => ['required'],
                // 'batch_id'       => ['required']
            ]);
            if(Course::find($request->course_id)){
                $total_amount = $request->total_fee - $request->discount;
                Session::put('checkout_request', $request->all());
                Session::put('payment_method', $request->payment_method);
                Session::put('payment_amount', $total_amount);
                
                $invoice_no = getLastEnrollmentId()+1;
                if($invoice_no < 10){
                    $invoice_no = '0'.$invoice_no;
                }
                $invoice_no = 'FC'.date('my').$invoice_no;
                
                Session::put('invoice_no', $invoice_no);
                    
                if($request->payment_method == 'bkash'){
                    $bkash = new BkashController;
                    return $bkash->pay();
                }
                
                if($request->payment_method == 'nagad'){
                    return back();
                }
            }
            else{
                session()->forget('coupon');
                return back()->with('message', 'No Course Found!!');
            }
        }
    }
    
    public function store(Request $request) {
        // dd($request);
        $batch = Null;
        if($request->batch != Null){
            $total_enrollment = CourseEnrollment::where('batch_id', $request->batch_id)->count();
            $batch = CourseBatch::where('id', $request->batch_id)->first();
        }
        if($request->batch_id_online != Null){
            $total_enrollment = CourseEnrollment::where('batch_id', $request->batch_id_online)->count();
            $batch = CourseBatch::where('id', $request->batch_id_online)->first();
        }
        if($batch){
            if($total_enrollment == $batch->max_student){
                return back()->with('message', 'Batch Already Filled!!');
            }
        }
        
        if(Auth::user() && Auth::user()->role == 3){
            $student = Student::where('user_id', Auth::user()->id)->first();
        }
        else{
            $student = Student::find($request->student_id);
        }
        
        // $branchStudent = CourseEnrollment::add($request, $student->id);
        $branchStudent = CourseEnrollment::addNew($request, $student->id);
        if(Auth::user()->role == 1){
            BranchAccount::addBill($branchStudent);
        }
        

        if(substr($student->student_phone,0,3)=="+88"){
            $phone =  $student->student_phone;
        }elseif(substr( $student->student_phone,0,2)=="88"){
            $phone = '+'. $student->student_phone;
        }else{
            $phone = '+88'. $student->student_phone;
        }
        $course = Course::find($request->course_id);
        $message = 'Dear '. $student->student_name.', Your Have Successfully Enrolled in '.$course->course_name.'. Regards - '.getSettings('site_name');
//        SmsUtility::sendSMS($phone, $message);

        //dd(Auth::user());
        if(Auth::user()->role == 3){
            if(session()->has('coupon')){
                $coupon = Coupon::findOrFail(session()->get('coupon')['coupon_id']);
                if ($coupon && $coupon->total_use_limit !== null) {
                    $coupon->decrement('total_use_limit');
                }
            }
            
            session()->forget('coupon');
            session()->forget('checkout_request');
            session()->forget('payment_method');
            session()->forget('payment_amount');
            session()->forget('invoice_no');
            
            return redirect()->route('student.courses')->with('success', 'Course Enrollment Request Submitted Successfully!!');
        }else{
            // dd('wrong route');
            session()->forget('coupon');
            // reduce the total_use_limit

            return redirect()->route('admin.course.enrollment.list')->with('success', 'Course Enrolled Successfully!!');
        }
    }

    public function list(){
        if(Auth::user()->role == 1){
            $temp = 1;
            $enrollments = CourseEnrollment::where(function ($query) use($temp){
                $query->where('status', 1)->orWhere('status', 3);
            })->latest();
            if(isset($_GET['batch_id']) && $_GET['batch_id'] > 0){
                $enrollments = $enrollments->where('batch_id', $_GET['batch_id']);
            }
            if(isset($_GET['year']) && $_GET['year'] > 0){
                $enrollments = $enrollments->whereYear('created_at', $_GET['year']);
            }
            if(isset($_GET['course_id']) && $_GET['course_id'] > 0){

                $enrollments = $enrollments->where('course_id', $_GET['course_id']);
                $data['batches'] = CourseBatch::where('course_id', $_GET['course_id'])->get();
//                return $enrollments->get();
            }
            if(isset($_GET['student_roll']) && $_GET['student_roll'] > 0){
                $student = BranchStudent::where('student_roll', $_GET['student_roll'])->first();
                if($student){
                    $enrollments = $enrollments->where('student_id', $student->student_id);
                }
                // return $student;

            }
            $data['items'] = $enrollments->paginate(100);
            return view('admin.course-enrollment.list', $data);
        }
        else{
            $student = Student::where('user_id', Auth::user()->id)->latest()->paginate(50);
            $data['items'] = CourseEnrollment::where('student_id', $student->id)->latest()->paginate(100);
            return view('frontend.student.course_enrollments', $data);
        }
    }

    public function enrollmentRequest(){
        if(Auth::user()->role == 1){
            $data['items'] = CourseEnrollment::where('status', 0)->latest()->paginate(100);
            return view('admin.course-enrollment.list', $data);
        }
        else{
            $student = Student::where('user_id', Auth::user()->id)->latest()->paginate(50);
            $data['items'] = CourseEnrollment::where('student_id', $student->id)->latest()->paginate(100);
            return view('frontend.student.course_enrollments', $data);
        }
    }

    public function edit($id){
        $data['item'] = CourseEnrollment::findOrFail($id);
        $data['students'] = Student::where('student_status_id', 1)->get();
        $data['batches'] = CourseBatch::where('course_id', $data['item']->course_id)->where('status', 1)->get();
        $data['branches'] = Branch::where('branch_status_id', 1)->get();
        // return $data;
        return view('admin.course-enrollment.form', $data);
    }

    public function update(Request $request){
        // return $request;
        $request->validate([
            'student_id' => ['required'],
            'course_id' => ['required'],
            'batch_id' => ['required'],
            'payment_method' => ['required'],
            'payment_number' => ['required'],
        ]);

        if($request->batch_id){
            $batch = CourseBatch::find($request->batch_id);
            $total_enrollments = CourseEnrollment::where('batch_id', $request->batch_id)->count();
//            return $total_enrollments;
            if($total_enrollments > $batch->max_student){
                return back()->with('message', 'Batch is Filled, Try Another Batch');
            }
        }

        $enrollment = CourseEnrollment::add($request, $request->student_id);
        $account = BranchAccount::where('student_id', $request->student_id)->where('course_id', $request->course_id)->first();
        if($request->status == 1 && $account == null){
            BranchAccount::addBill($enrollment);
        }
        return redirect()->route('admin.course.enrollment.list')->with('message', 'Course Enrollment Updated Successfully!!');
    }
    public function changeStatus(Request $request) {

       //  return $request;
        $course_enrollment = CourseEnrollment::find($request->id);
        $course_enrollment->status = $request->status;
        $course_enrollment->save();

        return back()->with('message', 'Course Enrollment Status Changed Successfully!!');
    }

    public function remove(Request $request){
        // return $request;
        CourseEnrollment::remove($request->id);
        return back()->with('message', 'Course Enrollment Removed Successfully!!');
    }
}
