<?php

namespace App\Http\Controllers;

use App\Models\Course;
use App\Models\CourseCategory;
use Illuminate\Http\Request;

class CourseCategoryController extends Controller
{
    public function add()
    {
        return view('admin.course.category.form');
    }


    public function submit(Request $request)
    {
//        return $request;
        $this->validation($request);
        CourseCategory::addOrUpdate($request);
        return redirect()->route('admin.course.category.list')->with('message', 'Course Category Has Been Added Successfully!!');
    }

    public function list()
    {
        $courseCategory = CourseCategory::latest();

        $data['items'] = $courseCategory->paginate(50);
        return view('admin.course.category.list', $data);
    }

    public function edit($id)
    {
        $data['item'] = CourseCategory::find($id);

        return view('admin.course.category.form', $data);
    }

    public function update(Request $request)
    {
//        return $request;
        $request->validate([
            'name'=>['required'] ,
        ]);
        CourseCategory::addOrUpdate($request);

        return redirect()->route('admin.course.category.list')->with('message', 'Course Category Has Been Updated Successfully!!');
    }

    public function remove(Request $request)
    {
        Course::deleteCategoryCourses($request->id);
        CourseCategory::remove($request->id);
        return back()->with('message', 'Course Category Has Been Removed Successfully!!');
    }
    public function validation($request){
        $request->validate([
            'name'=>['required', 'unique:course_categories'] ,
            'image'=>['required'],
        ]);
    }
}
