<?php

namespace App\Http\Controllers;

use App\Models\ClassSchedule;
use App\Models\Course;
use App\Models\CourseBatch;
use App\Models\Teacher;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ClassScheduleController extends Controller
{
    public function add()
    {
        $teacher = Teacher::where('user_id', Auth::user()->id)->first();
        $schedules = ClassSchedule::select('course_id')->where('teacher_id', $teacher->id)->distinct()->get();
        $courses = CourseBatch::select('course_id')->where('teacher_id', $teacher->id)->whereNotIn('course_id', $schedules)->distinct()->get();
        $data['assigned_courses'] = assignedCourses();
        return view('teacher.schedule.form', $data);
    }

    public function submit(Request $request){
//        return $request;
        $request->validate([
            'course_id' => 'required',
            'batch_id'  => 'required',
            'date'      => 'required',

        ]);

        $course = Course::where('id', $request->course_id)->first();
        if($course->course_type == 'online'){
            $request->validate([
                'link'      => 'required|array'
            ]);
        }
        if($course && $course->total_lectures < count($request->date)){
            dd('ok');
            return back()->with('message', 'Course Has not Enough Lectures');
        }
//        return $course;
        foreach ($request->date as $date){
            if($date < $course->start_date ){
//                dd($date, $course->start_date);
                return back()->with('message', 'Invalid Date. Course Will Start From '.$course->start_date);
            }
        }

        ClassSchedule::add($request);
        return redirect()->route('teacher.schedule.list', $request->batch_id)->with('message', 'Class Schedule Added Successfully.');
    }

    public function list($id)
    {
        $data['items'] = ClassSchedule::where('teacher_id', Auth::user()->id)->where('batch_id', $id)->orderBy('date', 'asc')->get();
        return view('teacher.schedule.list', $data);
    }
    public function allSchedules()
    {
        $data['items'] = ClassSchedule::where('teacher_id', Auth::user()->id)->orderBy('date', 'asc')->get();
        return view('teacher.schedule.list', $data);
    }

    public function edit($id){
        $data['item'] = ClassSchedule::where('batch_id',$id)->get();
        $data['assigned_courses'] = assignedCourses();
        return view('teacher.schedule.form', $data);
    }
    public function update(Request $request){
        $request->validate([
            'course_id' => 'required',
            'batch_id'  => 'required',
            'date'      => 'required|array',
            'link'      => 'required|array'
        ]);

        $course = Course::where('id', $request->course_id)->first();
        if($course && $course->total_lectures < count($request->date)){
            return back()->with('error', 'Course Has not Enough Lectures');
        }

        foreach ($request->date as $date){
            if($date < $course->start_date ){
                return back()->with('error', 'Invalid Date');
            }
        }
        ClassSchedule::where('batch_id', $request->batch_id)->delete();

        ClassSchedule::add($request);
        return redirect()->route('teacher.schedule.list', $request->batch_id)->with('message', 'Class Schedule Updated Successfully.');
    }

    public function remove(Request $request){
        ClassSchedule::remove($request->id);
        return redirect()->route('teacher.schedule.list')->with('message', 'Class Schedule Deleted Successfully.');
    }

    public function getSchedule()
    {
        return response()->json(ClassSchedule::where('batch_id', $_GET['batch_id'])->orderBy('date', 'asc')->get());

    }

    public function endClass(Request $request)
    {
        $request->validate([
            'id' => ['required'],
            'summary' => ['required'],
        ]);

        ClassSchedule::endClass($request);

        return back()->with('message', 'Class Schedule Ended Successfully.');
    }

}
