<?php
    $route = Route::currentRouteName();
?>
<?php $__env->startSection('title'); ?>
    <?php if($route == 'admin.course.enrollment.list'): ?>
    Course Enrollment
    <?php else: ?>
    Course Enrollment Requests
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                            <h3 class="text-center">
                                <strong>

                                    <?php if($route == 'admin.course.enrollment.list'): ?>
                                        View Enrollment
                                    <?php else: ?>
                                        View Enrollment Requests
                                    <?php endif; ?>

                                </strong>
                        </h3>

                        </div>

                    </div>
                    <hr>

                    <div class="row">
                        <div class="col-md-12">
                            <form id="filterForm">
                                <div class="row">
                                    <div class="form-group col-sm-4">
                                        <label for="" class="form-control-label">Student Roll</label>
                                        <input name="student_roll" id="student_roll" placeholder="Enter Student Roll" onchange="filter()" type="text" class="form-control" value="<?php if(isset($_GET['student_roll'])): ?><?php echo e($_GET['student_roll']); ?><?php endif; ?>">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <label for="" class="form-control-label">Year</label>
                                        <select name="year" id="year" onchange="filter()" class="form-control">
                                            <option value="">All</option>
                                            <?php for($i=2018; $i<=date('Y'); $i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php if(isset($_GET['year'])): ?> <?php if($i == $_GET['year']): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($i); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label for="" class="form-control-label">Course</label>
                                        <select name="course_id" id="course_id" onchange="filter()" class="form-control">
                                            <option value="">All</option>
                                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($course->id); ?>" <?php if(isset($_GET['course_id'])): ?> <?php if($course->id == $_GET['course_id']): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($course->course_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php if($route == 'admin.course.enrollment.list'): ?>
                                        <div class="form-group col-sm-3">
                                            <label for="" class="form-control-label">Batch</label>
                                            <select name="batch_id" id="session_id" onchange="filter()" class="form-control">
                                                <option value="">All</option>
                                                <?php if(isset($batches)): ?>
                                                    <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($batch->id); ?>" <?php if(isset($_GET['batch_id'])): ?> <?php if($batch->id == $_GET['batch_id']): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($batch->batch_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    <?php endif; ?>

                                </div>

                            </form>
                        </div>
                    </div>

                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Student Name <br>Roll</th>
                            <th>Course Name<br><span class="second-line">Course Code</span></th>
                            <th>Branch Name<br></th>
                            <th>Batch Name</th>
                            <th>Fee<br><span class="second-line">Discount</span></th>
                            <th>Payment Method<br><span class="second-line">Account Number</span></th>
                            <th>Status<br><span class="second-line"></span></th>
                            <th>Action</th>
                            <?php if($route == 'admin.course.enrollment.list'): ?>
                            
                            <?php endif; ?>
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->student->student_name ?? ''); ?><br><span><?php echo e($item->branchStudent->student_roll ?? ''); ?></span></td>
                                <td><?php echo e($item->course->course_name ?? ''); ?><br><span><?php echo e($item->course->course_code ?? ''); ?></span></td>
                                <td><?php echo e($item->branch->branch_name ?? ''); ?></td>
                                <td><?php echo e($item->batch->batch_name ?? ''); ?></td>
                                <td><?php echo e($item->total_fee); ?><br><span><?php echo e($item->discount); ?></span></td>
                                <td><?php echo e($item->payment_method); ?><br><span><?php echo e($item->payment_number); ?></span></td>
                                <td class="text-center">
                                    <div class="mb-2">
                                        <span class="<?php echo e($item->status == 1 || $item->status == 3 ? 'bg-success':'bg-danger'); ?> p-2 text-white" style="border-radius:5px">
                                            <?php if($item->status == 1): ?>
                                                Approved
                                            <?php elseif($item->status == 2): ?>
                                            Rejected
                                            <?php elseif($item->status == 3): ?>
                                                Completed
                                            <?php else: ?>
                                            Pending
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    </td>
                                <?php if($route != 'admin.course.enrollment.list'): ?>
                                    <td class="btn-group">
                                        <a  title="Approve" href="<?php echo e(route('admin.course.enrollment.edit', ['id' => $item->id])); ?>" class="btn btn-primary"><i class="fa fa-check-circle"></i></a>
                                        <a  title="Reject" onclick="changeStatus(0, <?php echo e($item->id); ?>)" class="btn btn-danger mx-2"><i class="fa fa-trash"></i></a>
                                        <form action="<?php echo e(route('admin.course.enrollment.status.change')); ?>" id="statusChangeForm<?php echo e($item->id); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                            <input type="hidden" name="status" id="status<?php echo e($item->id); ?>" value="">

                                        </form>
                                    </td>
                                <?php else: ?>
                                    <td class="btn-group">
                                        <form action="<?php echo e(route('admin.course.enrollment.delete')); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                            <button class="btn btn-danger"><i class="fa fa-trash"></i></button>
                                        </form>
                                        <?php if($item->status == 3): ?>
                                            <a  onclick="test(<?php echo e($item->branchStudent->id); ?>)" class="btn btn-info mx-2"><i class="fa fa-download"></i></a>

                                        <?php endif; ?>

                                    </td>
                                    <?php if($route == 'admin.course.enrollment.list'): ?>
                                        
                                    <?php endif; ?>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                    <?php echo e($items->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<script>
    function changeStatus(val, id){
        alert(val);
        jQuery('#status'+id).val(val);
        jQuery('#statusChangeForm'+id).submit();
    }
    function test(id){
        url = '<?php echo e(route('admin.student.certificate.print',":id")); ?>'
        url = url.replace(':id', id);
        var test_window = window.open(url);
        test_window.onload = function() {
            // Trigger the print functionality for the new window
            test_window.print();
        }
        // Open a new window or tab with the URL of the page you want to print
    }
</script>
</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/admin/course-enrollment/list.blade.php ENDPATH**/ ?>