<?php $__env->startSection('title'); ?>
    Branch List
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
    <?php
    use App\Models\Upazila;
    use App\Models\District;
    if (isset($_GET['branch_district'])){
        $district = District::find($_GET['branch_district']);
    }
    if (isset($_GET['branch_upazila'])){
        $upazila = Upazila::find($_GET['branch_upazila']);
    }
    ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                    <h3 class="text-center"><strong>View Branch List</strong>
                        <a href="<?php echo e(route('admin.branch.add')); ?>" class="float-right btn btn-primary">Add Branch</a></h3>
                    <hr>
                    <form action="" id="filterForm">
                        <div class="row mb-4">
                            <div class="form-group col-sm-3">
                                <label for="" class="form-control-label">Branch Name or Code</label>
                                <input type="text" name="branch" class="form-control" onchange="filter()" placeholder="Enter Branch Name or Branch Code" value="<?php if(isset($_GET['branch']) && $_GET['branch']>0): ?><?php echo e($_GET['branch']); ?> <?php endif; ?>">
                            </div>
                            <div class="form-group col-sm-3"><label for="" class="form-control-label">Branch Division</label>
                                <select name="branch_division" onchange="filter()" id="division_id" class="form-control">
                                    <option value="">All</option>
                                    <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($division->id); ?>"
                                        <?php if(isset($_GET['branch_division'])): ?><?php echo e($_GET['branch_division'] == $division->id ? 'selected': ''); ?><?php endif; ?>>
                                            <?php echo e($division->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-3"><label for="" class="form-control-label">Branch District</label>
                                <select name="branch_district" onchange="filter()" id="district_id" class="form-control">
                                    <option value="">All</option>
                                    <?php if(isset($_GET['branch_division']) && $_GET['branch_division'] >0): ?>
                                        <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($district->id); ?>" <?php if(isset($_GET['branch_district'])): ?><?php echo e($_GET['branch_district'] == $district->id ? 'selected': ''); ?><?php endif; ?>><?php echo e($district->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>




                                </select>

                            </div>
                            <div class="form-group col-sm-3"><label for="" class="form-control-label">Branch Upazila</label>
                                <select name="branch_upazila" onchange="filter()" id="upazila_id" class="form-control">
                                    <option value="">All</option>
                                    <?php if(isset($_GET['branch_district']) && $_GET['branch_district']>0): ?>
                                        <?php $__currentLoopData = $upazilas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $upazila): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($upazila->id); ?>" <?php if(isset($_GET['branch_upazila'])): ?><?php echo e($_GET['branch_upazila'] == $upazila->id ? 'selected': ''); ?><?php endif; ?>><?php echo e($upazila->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>



                                </select>
                            </div>

                        </div>

                    </form>
                </div>
                <div class="card-body table-responsive">
                    <table class="table table-striped">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Name<br><span class="second-line">Code</span></th>
                                <th>Email<br><span class="second-line">Phone</span></th>
                                <th>Division<br><span class="second-line">District</span></th>
                                <th>Upazila<br><span class="second-line">Area</span></th>
                                <th>Type<br><span class="second-line">Join Date</span></th>
                                <th>Total Students<br><span class="second-line">Registration Status</span></th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        <?php $i=1; ?>
                        <tbody>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->branch_name); ?><br><span class="text-info"><?php echo e($item->branch_code); ?></span></td>
                                <td><?php echo e($item->branch_email); ?><br><span><?php echo e($item->branch_phone); ?></span></td>
                                <td><?php echo e($item->division->name); ?><br><span><?php echo e($item->district->name); ?></span></td>
                                <td><?php echo e($item->upazila->name); ?> <br><span><?php echo e($item->branch_area); ?></span></td>
                                <td><?php echo e($item->branch_type_id == 1 ? 'Head Branch':'Branch'); ?><br><span><?php echo e($item->join_date); ?></span></td>
                                <td class="text-center"><?php echo e(count(getStudentsByBranchId($item->id))); ?><br>
                                    <div class="mt-2">
                                        <span class="<?php echo e($item->registration_status_id == 1 ? 'bg-success':'bg-danger'); ?> p-2 text-white" style="border-radius:5px">
                                    <?php echo e($item->registration_status_id == 1 ? 'Active':'Inactive'); ?></span>
                                    </div>
                                </td>

                                <td class="btn-group">
                                    <a href="<?php echo e(route('admin.branch.edit', ['id'=>$item->id])); ?>" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                    <form action="<?php echo e(route('admin.branch.remove')); ?>" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                        <button type="submit" title="Remove" class="btn btn-danger" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                    </form>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                    <?php echo e($items->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>






































































    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {

                var reader = new FileReader();
                reader.onload = function (e) {
                    document.querySelector("#img").setAttribute("src",e.target.result);
                };

                reader.readAsDataURL(input.files[0]);
            }
        }
        jQuery(document).ready( function () {
            jQuery('#myTable').DataTable();
        } );
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/admin/branch/list.blade.php ENDPATH**/ ?>