<?php $__env->startSection('title'); ?>
    Batch List
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                            <h3 class="text-center"><strong>View Batch List</strong></h3>
                        </div>
                        <div class="col-md-2">
                            <a href="<?php echo e(route('batch.add')); ?>" class="float-right btn btn-primary">Add Batch</a>
                        </div>
                    </div>

                    <hr>
                    <form action="" id="filterForm">
                        <div class="row mb-3">
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Course</label>
                                <select name="course_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($course->id); ?>" <?php if(isset($_GET['course_id'])): ?><?php echo e($_GET['course_id'] == $course->id ? 'selected':''); ?><?php endif; ?>><?php echo e($course->course_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                            </div>
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Teacher</label>
                                <select name="teacher_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($teacher->id); ?>"
                                        <?php if(isset($_GET['teacher_id'])): ?><?php echo e($_GET['teacher_id'] == $teacher->id ? 'selected':''); ?><?php endif; ?>>
                                            <?php echo e($teacher->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                            </div>

                        </div>

                    </form>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Batch Name</th>
                            <th>Branch Name</th>
                            <th>Course Name<br><span class="second-line">Session Name</span></th>
                            <th>Assigned Teacher</th>
                            <th>Total Student / <br> Max Students</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->batch_name); ?></td>
                                <td><?php echo e($item->branch->branch_name ?? ''); ?></td>
                                <td><?php echo e($item->course->course_name ?? ''); ?><br><span><?php echo e($item->session->session_name ?? ''); ?></span></td>
                                <td><?php echo e($item->teacher->name); ?></td>
                                <?php $total_student = \App\Models\CourseEnrollment::where('batch_id', $item->id)->where('status', 1)->count() ?>
                                <td><?php echo e(count(getStudentsByBatchId($item->id))); ?>/<span><?php echo e($item->max_student); ?></span></td>

                                <td class="text-center">
                                    <div class="mb-2">
                                        <span class="<?php echo e($item->status == 1 || $item->status == 3 ? 'bg-success':'bg-danger'); ?> p-2 text-white" style="border-radius:5px">
                                    <?php if($item->status == 1): ?>
                                        Active
                                            <?php elseif($item->status == 3): ?>
                                        Completed
                                            <?php else: ?>
                                        Inactive
                                    <?php endif; ?>
                                        </span>
                                    </div>
                                </td>

                                <td class="btn-group">
                                    <a href="<?php echo e(route('batch.edit', ['id'=>$item->id])); ?>" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                    <form action="<?php echo e(route('batch.remove')); ?>" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                        <button type="submit" title="Remove" class="btn btn-danger" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                    </form>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/admin/batch/list.blade.php ENDPATH**/ ?>