<?php $__env->startSection('title'); ?>
    Course Schedule
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php $route = Route::currentRouteName(); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                    <div class="d-flex justify-content-between">
                        <h3 class="text-center"><strong>View Classes</strong></h3>
                       <?php if(count($items) > 0 && $route == 'teacher.schedule.list'): ?>
                            <a href="<?php echo e(route('teacher.schedule.edit', $items->first()->batch_id)); ?>" class=" ms-3 btn btn-success"  title="Edit Class Schedule"><i class="fa fa-pencil"> Edit Schedule</i></a>
                        <?php endif; ?>
                    </div>


                </div>
                <div class="card-body table-responsive">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course</th>
                            <th>Branch</th>
                            <th>Batch</th>
                            <th>Date</th>
                            <th>Time</th>
                            <th>Status</th>
                            <th>Action</th>

                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->course->course_name ?? 'N/A'); ?></td>
                                <td><?php echo e($item->branch->branch_name ?? 'N/A'); ?></td>
                                <td><?php echo e($item->batch->batch_name ?? 'N/A'); ?></td>
                                <td width="150px"><?php echo e($item->date); ?></td>
                                <td><?php echo e($item->batch->time ?? 'N/A'); ?></td>
                                <td>
                                    <div class="mt-2">
                                        <span class="<?php echo e($item->status == 1 ? 'bg-success':'bg-danger'); ?> p-2 text-white" style="border-radius:5px">
                                    <?php echo e($item->status == 1 ? 'Active':'Ended'); ?></span>
                                    </div>
                                </td>

                                <td class="btn-group">
                                    <?php if($item->status == 1): ?>
                                    <a href="<?php echo e($item->link); ?>" title="Join Class" class="btn btn-primary"><i class="fa fa-sign-in"></i></a>
                                    <a href="<?php echo e($item->link); ?>" data-toggle="modal" data-target="#exampleModal" title="End Class" class="btn btn-danger mx-2"><i class="fa fa-window-close"></i></a>
                                    <?php endif; ?>
                                    <!-- Button trigger modal -->


                                    <!-- Modal -->
                                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Class Summary</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form action="<?php echo e(route('teacher.schedule.end')); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                                    <div class="modal-body">
                                                        <textarea name="summary" placeholder="Write Class Summary" id="" class="summernote form-control" cols="30" rows="10" required></textarea>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                        <button type="submit" class="btn btn-primary">Save changes</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>

    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script>
        jQuery(document).ready(function() {
            jQuery('.summernote').summernote();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/teacher/schedule/list.blade.php ENDPATH**/ ?>