<?php $__env->startSection('title'); ?>
    <?php if(isset($item)): ?>Edit <?php else: ?> Add <?php endif; ?> Student
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="row mt-1">
        <div class="card card-body">
            <form action="<?php if(isset($item)): ?><?php echo e(route('student.update')); ?><?php else: ?><?php echo e(route('student.submit')); ?><?php endif; ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" value="<?php if(isset($item)): ?><?php echo e($item->student_id); ?><?php endif; ?>">
                <div class="row mb-3">
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header text-center">
                                <?php if(isset($item)): ?>
                                <?php else: ?>

                                    <?php if(getSettings('registration_status') != 1): ?><h3><strong class="text-danger">You Can not Register a Student Now</strong></h3> <?php endif; ?>
                                <?php endif; ?>
                                <h3><strong>Personal Information</strong></h3>
                            </div>
                            <div class="card-body">
                                <div class="row mb-1">
                                    <div class="form-group col-md-12">
                                        <label for="" class="form-control-label">Student Name
                                            <span class="text-danger">*</span>
                                        </label>
                                        <input type="text" name="student_name" id=""
                                               class="form-control <?php $__errorArgs = ['student_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               value="<?php if(isset($item)): ?><?php echo e($item->student->student_name); ?><?php else: ?><?php echo e(old('student_name')); ?><?php endif; ?>" placeholder="Enter Student Name" required>
                                        <?php $__errorArgs = ['student_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback" role="alert"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="row mb-1">
                                    <div class="form-group col-md-6">
                                        <label for="" class="form-control-label">Phone Number
                                            <span class="text-danger">*</span>
                                        </label>
                                        <input type="number" name="student_phone" id=""
                                               class="form-control <?php $__errorArgs = ['student_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               value="<?php if(isset($item)): ?><?php echo e($item->student->student_phone); ?><?php else: ?><?php echo e(old('student_phone')); ?><?php endif; ?>" placeholder="Enter Student Phone Number" required>
                                        <?php $__errorArgs = ['student_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback" role="alert"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="" class="form-control-label">Email Address</label>
                                        <input type="email" name="student_email" id=""
                                               class="form-control"
                                               value="<?php if(isset($item)): ?><?php echo e($item->student->student_email); ?><?php else: ?><?php echo e(old('student_email')); ?><?php endif; ?>">
                                    </div>
                                </div>
                                <div class="row mb-1">
                                    <div class="form-group col-md-6">
                                        <label for="" class="form-control-label">Father's Name</label>
                                        <input type="text" name="father_name" id=""
                                               class="form-control"
                                               value="<?php if(isset($item)): ?><?php echo e($item->student->father_name); ?><?php else: ?><?php echo e(old('father_name')); ?><?php endif; ?>" placeholder="Enter Father's Name">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="" class="form-control-label">Mother's Name</label>
                                        <input type="text" name="mother_name" id=""
                                               class="form-control"
                                               value="<?php if(isset($item)): ?><?php echo e($item->student->mother_name); ?><?php else: ?><?php echo e(old('mother_name')); ?><?php endif; ?>" placeholder="Enter Mother's Name">
                                    </div>
                                </div>
                                <div class="row mb-1">
                                    <div class="form-group col-md-6">
                                        <label for="" class="form-control-label">Date of Birth</label>
                                        <input type="date" name="student_dob" id=""
                                               class="form-control"
                                               value="<?php if(isset($item)): ?><?php echo e(date('Y-m-d', strtotime($item->student->student_dob))); ?><?php else: ?><?php echo e(old('student_dob')); ?><?php endif; ?>">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="" class="form-control-label">Admission Date</label>
                                        <input type="text" name="join_date" id=""
                                               class="form-control"
                                               value="<?php if(isset($item)): ?><?php echo e($item->student->join_date); ?><?php else: ?><?php echo e(date('d-m-Y')); ?><?php endif; ?>" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card-header text-center"><h3><strong>Student Image</strong></h3></div>
                        <div class="card-body">
                            <?php if(isset($item)): ?>
                                <?php if($item->student->student_image): ?>
                                    <img src="<?php echo e(asset($item->student->student_image)); ?>"alt="" height="200px" width="200px" id="img" class="mb-3 mx-4">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('admin-assets')); ?>/images/default.jpg"alt="" height="200px" width="200px" id="img" class="mb-3 mx-4">
                                <?php endif; ?>
                            <?php else: ?>
                                <img src="<?php echo e(asset('admin-assets')); ?>/images/default.jpg" alt="" height="200px" width="200px" id="img" class="mb-3 mx-4">
                            <?php endif; ?>
                            <input type="file" class="form-control <?php $__errorArgs = ['student_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="student_image" accept="image/*" style="padding: 3px" onchange="readURL(this)">
                            <?php $__errorArgs = ['student_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback" role="alert"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header text-center"><h3><strong>Additional Information</strong></h3></div>
                            <div class="card-body">
                                <div class="row mb-1">
                                    <div class="form-group col-md-4"><label for="" class="form-control-label">Gender</label>
                                        <select name="student_gender" id="" class="form-control">
                                            <option value="" selected>Select Gender</option>
                                            <option value="1" <?php if(isset($item)): ?><?php echo e($item->student->student_gender == 1 ? 'selected':''); ?><?php endif; ?>>Male</option>
                                            <option value="2" <?php if(isset($item)): ?><?php echo e($item->student->student_gender == 2 ? 'selected':''); ?><?php endif; ?>>Female</option>
                                            <option value="3" <?php if(isset($item)): ?><?php echo e($item->student->student_gender == 3 ? 'selected':''); ?><?php endif; ?>>Others</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-4"><label for="" class="form-control-label">Religion</label>
                                        <select name="student_religion" id="" class="form-control">
                                            <option value="" selected>Select Religion</option>
                                            <option value="1" <?php if(isset($item)): ?><?php echo e($item->student->student_religion == 1 ? 'selected':''); ?><?php endif; ?>>Islam</option>
                                            <option value="2" <?php if(isset($item)): ?><?php echo e($item->student->student_religion == 2 ? 'selected':''); ?><?php endif; ?>>Hinduism</option>
                                            <option value="3" <?php if(isset($item)): ?><?php echo e($item->student->student_religion == 3 ? 'selected':''); ?><?php endif; ?>>Christianity</option>
                                            <option value="4" <?php if(isset($item)): ?><?php echo e($item->student->student_religion == 4 ? 'selected':''); ?><?php endif; ?>>Buddhism</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-4"><label for="" class="form-control-label">Nationality
                                            <span class="text-danger">*</span></label>
                                        <select name="student_nationality" id="" class="form-control">
                                            <option value="1" selected>Bangladeshi</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header text-center"><h3><strong>Academic Information</strong></h3></div>
                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="form-group col-md-3">
                                        <label for="" class="form-control-label">SSC Board</label>
                                        <select name="ssc_board" id="" class="form-control">
                                            <option value="">Select Board</option>
                                            <?php for($i=1; $i<=count($boards); $i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php if(isset($item)): ?><?php echo e($item->student->ssc_board == $i ? 'selected':''); ?><?php endif; ?>>
                                                    <?php echo e($boards[$i-1]); ?></option>
                                            <?php endfor; ?>

                                        </select>
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="" class="form-control-label">SSC Roll</label>
                                        <input type="text" name="ssc_roll" class="form-control" placeholder="Enter SSC Roll No" value="<?php if(isset($item)): ?><?php echo e($item->student->ssc_roll); ?><?php else: ?><?php echo e(old('ssc_roll')); ?><?php endif; ?>">
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="" class="form-control-label">SSC Result (GPA)</label>
                                        <input
                                            type="text" class="form-control" name="ssc_result" placeholder="Enter SSC Result" value="<?php if(isset($item)): ?><?php echo e($item->student->ssc_result); ?><?php else: ?><?php echo e(old('ssc_result')); ?><?php endif; ?>">
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="" class="form-control-label">SSC Passing Year</label>
                                        <input type="text" name="ssc_year" class="form-control" placeholder="Enter SSC Passing Year" value="<?php if(isset($item)): ?><?php echo e($item->student->ssc_year); ?><?php else: ?><?php echo e(old('ssc_year')); ?><?php endif; ?>">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-3">
                                        <label for="" class="form-control-label">JSC Board</label>
                                        <select name="jsc_board" id="" class="form-control">
                                            <option value="" selected>Select Board</option>
                                            <?php for($i=1; $i<=count($boards); $i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php if(isset($item)): ?><?php echo e($item->student->jsc_board == $i ? 'selected':''); ?><?php endif; ?>>
                                                    <?php echo e($boards[$i-1]); ?></option>
                                            <?php endfor; ?>

                                        </select>
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="" class="form-control-label">JSC Roll</label>
                                        <input type="text" name="jsc_roll" class="form-control" placeholder="Enter JSC Roll No" value="<?php if(isset($item)): ?><?php echo e($item->student->jsc_roll); ?><?php else: ?><?php echo e(old('jsc_roll')); ?><?php endif; ?>">
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="" class="form-control-label">JSC Result (GPA)</label>
                                        <input
                                            type="text" class="form-control" name="jsc_result" placeholder="Enter JSC Result" value="<?php if(isset($item)): ?><?php echo e($item->student->jsc_result); ?><?php else: ?><?php echo e(old('jsc_result')); ?><?php endif; ?>">
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="" class="form-control-label">JSC Passing Year</label>
                                        <input type="text" name="jsc_year" class="form-control" placeholder="Enter JSC Passing Year" value="<?php if(isset($item)): ?><?php echo e($item->student->jsc_year); ?><?php else: ?><?php echo e(old('jsc_year')); ?><?php endif; ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                               















































<div class="row mb-3">
    <div class="col-md-12 card card-body">
        <div class="card-header text-center"><strong>Sign in Information</strong></div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group"><label for="vat" class=" form-control-label">Password
                            <span class="text-danger">* [minimum length 8]</span></label>
                        <div class="input-group">
                            <input type="password" id="password" name="password"
                                   class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php if(isset($item)): ?><?php echo e($item->student->password); ?><?php else: ?><?php echo e(old('password')); ?><?php endif; ?>" required>
                            <a class="btn btn-light input-group-addon" onclick="togglePassword()"><i class="fa fa-eye"></i></a>
                        </div>
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback" role="alert"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group"><label for="vat" class=" form-control-label">Confirm Password
                            <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="password" id="password_confirmation" name="password_confirmation"
                                   class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   value="<?php if(isset($item)): ?><?php echo e($item->student->password); ?><?php else: ?><?php echo e(old('password')); ?><?php endif; ?>" required>
                            <a class="btn btn-light input-group-addon" onclick="toggleConfirmPassword()"><i class="fa fa-eye"></i></a>
                        </div>
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback" role="alert"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="form-group col-md-4">
                    <label for="" class="form-control-label">Status</label>
                    <div class="form-check">
                        <input class="form-check-input" value="1" type="radio" name="student_status_id" id="flexRadioDefault3" checked>
                        <label class="form-check-label" for="flexRadioDefault1">
                            Active
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" value="0" type="radio" name="student_status_id" id="flexRadioDefault4"
                        <?php if(isset($item)): ?><?php echo e($item->student->student_status_id != 1 ? 'checked':''); ?><?php endif; ?>>
                        <label class="form-check-label" for="flexRadioDefault2">
                            Inactive
                        </label>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <?php if(isset($item)): ?>
                            <button type="submit" class="btn btn-primary form-control">Update Student Information</button>
                        <?php else: ?>
                            <button type="submit" id="submitBtn" class="btn btn-primary form-control">Add  Student Information</button>
                        <?php endif; ?>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        function readURL(input) {
            if (input.files && input.files[0]) {

                var reader = new FileReader();
                reader.onload = function (e) {
                    document.querySelector("#img").setAttribute("src",e.target.result);
                };

                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
    <script>
        jQuery(document).ready(function(){
            var regStatus = <?php echo e(getSettings('registration_status')); ?>;
            
            var branchRegStatus = 1;

                if(regStatus != '1' || branchRegStatus != 1){
                    <?php if(isset($item)): ?>
                    <?php else: ?>
                    jQuery('#submitBtn').prop('disabled', true);
                    jQuery('form').submit(function (event) {
                        event.preventDefault();
                        alert('Registration is now Deactivated!!');
                    });
                    <?php endif; ?>
            }
        });

        function togglePassword(){
        var pass =document.getElementById('password');
        if(pass.type == 'password'){
            pass.type = 'text';
        }
        else {
            pass.type = 'password';
        }

    }
    function toggleConfirmPassword(){
        var pass_confirm =document.getElementById('password_confirmation');
        if(pass_confirm.type == 'password'){
            pass_confirm.type = 'text';
        }
        else {
            pass_confirm.type = 'password';
        }
    }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/admin/student/form.blade.php ENDPATH**/ ?>