<?php $__env->startSection('title'); ?>
    Verify Certificate
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="pt-0 pt-lg-5 position-relative overflow-hidden my-auto">

        <!-- SVG decoration -->
        <figure class="position-absolute bottom-0 start-0">
            <svg width="822.2px" height="301.9px" viewBox="0 0 822.2 301.9">
                <path class="fill-warning opacity-5" d="M752.5,51.9c-4.5,3.9-8.9,7.8-13.4,11.8c-51.5,45.3-104.8,92.2-171.7,101.4c-39.9,5.5-80.2-3.4-119.2-12.1 c-32.3-7.2-65.6-14.6-98.9-13.9c-66.5,1.3-128.9,35.2-175.7,64.6c-11.9,7.5-23.9,15.3-35.5,22.8c-40.5,26.4-82.5,53.8-128.4,70.7 c-2.1,0.8-4.2,1.5-6.2,2.2L0,301.9c3.3-1.1,6.7-2.3,10.2-3.5c46.1-17,88.1-44.4,128.7-70.9c11.6-7.6,23.6-15.4,35.4-22.8 c46.7-29.3,108.9-63.1,175.1-64.4c33.1-0.6,66.4,6.8,98.6,13.9c39.1,8.7,79.6,17.7,119.7,12.1C634.8,157,688.3,110,740,64.6 c4.5-3.9,9-7.9,13.4-11.8C773.8,35,797,16.4,822.2,1l-0.7-1C796.2,15.4,773,34,752.5,51.9z"></path>
            </svg>
        </figure>
        <!-- SVG decoration -->
        <figure class="position-absolute top-0 end-0 d-none d-xl-block">
            <svg width="822.2px" height="301.9px" viewBox="0 0 822.2 301.9">
                <path class="fill-danger opacity-3" d="M752.5,51.9c-4.5,3.9-8.9,7.8-13.4,11.8c-51.5,45.3-104.8,92.2-171.7,101.4c-39.9,5.5-80.2-3.4-119.2-12.1 c-32.3-7.2-65.6-14.6-98.9-13.9c-66.5,1.3-128.9,35.2-175.7,64.6c-11.9,7.5-23.9,15.3-35.5,22.8c-40.5,26.4-82.5,53.8-128.4,70.7 c-2.1,0.8-4.2,1.5-6.2,2.2L0,301.9c3.3-1.1,6.7-2.3,10.2-3.5c46.1-17,88.1-44.4,128.7-70.9c11.6-7.6,23.6-15.4,35.4-22.8 c46.7-29.3,108.9-63.1,175.1-64.4c33.1-0.6,66.4,6.8,98.6,13.9c39.1,8.7,79.6,17.7,119.7,12.1C634.8,157,688.3,110,740,64.6 c4.5-3.9,9-7.9,13.4-11.8C773.8,35,797,16.4,822.2,1l-0.7-1C796.2,15.4,773,34,752.5,51.9z"></path>
            </svg>
        </figure>

        <div class="container position-relative">
            <div class="row g-5 align-items-center justify-content-center">
                <div class="col-lg-5">
                    <!-- Title -->
                    <h1 class="mt-4 mt-lg-0">Verify Certificate!</h1>
                    <!-- info -->
                    <p>Verify your certifates by entering serial number of the certificate.</p>
                    <!-- Progress bar -->









                    <!-- Newsletter -->
                    <form class="mt-4" action="<?php echo e(route('submit.verify')); ?>" method="Post">
                        <?php echo csrf_field(); ?>
                        <!-- Info -->

                        <div class="bg-body border rounded-2 p-2">
                            <!-- Input subscribe -->
                            <div class="input-group">
                                <input class="form-control border-0 me-1" type="number" name="serial_num" placeholder="Enter Serial Number">
                                <button type="submit" class="btn btn-blue mb-0 rounded-2">Verify!</button>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="col-lg-7 text-center">
                    <!-- Image -->
                    <img src="<?php echo e(asset('frontend-assets')); ?>/fonts/certificate-verify.jpg" class="h-300px" alt="">
                </div>
            </div>
        </div>
        <?php if(session('certificate')): ?>
        <div class="container position-relative mt-5">
            <div class="row g-5 align-items-center justify-content-center">
                <div class="col-lg-12">
                    <!-- Title -->
                    <div class="card">
                        <div class="card-header"><h3 class="text-center">Student Information</h3></div>
                        <div class="card-body table-responsive">
                            <table class="table table-borderless table-striped">
                                <tr>
                                    <th width="20%">Name</th>
                                    <td><?php echo e(session('certificate')->name); ?></td>
                                    
                                </tr>
                                <tr>
                                    <th width="20%">Roll</th>
                                    <td><?php echo e(session('certificate')->student_roll); ?></td>
                                </tr>
                                <tr>
                                    <th width="20%">Registration Number</th>
                                    <td><?php echo e(session('certificate')->student_registration_num); ?></td>
                                </tr>

                                <tr>
                                    <th width="20%">Course Name</th>
                                    <td><?php echo e(session('certificate')->course_name); ?></td>
                                </tr>
                                <tr>
                                    <th width="20%">Branch Name</th>
                                    <td><?php echo e(session('certificate')->branch_name); ?></td>
                                </tr>
                                <tr>
                                    <th width="20%">Batch Name</th>
                                    <td><?php echo e(session('certificate')->batch_name); ?></td>
                                </tr>
                                <tr>
                                    <th width="20%">Certificate Given On</th>
                                    <td><?php echo e(session('certificate')->created_at); ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <?php endif; ?>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/frontend/pages/verify-certificate/index.blade.php ENDPATH**/ ?>