<?php $__env->startSection('title'); ?>
    All Webinar List
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="bg-light">
        <div class="container">

            <!-- Title -->
            <div class="row position-relative pb-4">
                <div class="col-lg-8 position-relative">
                    <!-- Title -->
                    <h1>All Seminar Schedule</h1>
                    <p>Still undecided about which course to pursue? Curious about the career paths or the facilities we
                        offer? We’re here to help you with all your questions every week. We host course-specific seminars
                        where our expert mentors provide an overview of the courses and discuss potential career
                        opportunities. Attend these seminars to find the course that aligns perfectly with your goals.</p>
                </div>
            </div>
        </div>
    </section>
    <style>
        @media (max-width: 768px) {
            .text_main {
                padding: 15px;
                /* Adjust padding for smaller screens */
                flex-direction: column;
                /* Stack content vertically on mobile */
            }

            .join_btn {
                width: 100%;
                /* Full width button on mobile */
                margin-top: 10px;
                /* Add some margin for spacing */
            }
        }
    </style>
    <section>
        <div class="container my-4">
            <div class="row justify-content-center">
                <?php if(count($webinars) > 0): ?>
                    <?php $__currentLoopData = $webinars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $webinar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-12 mb-4">
                            <div class="seminar_content border rounded-3 shadow-sm p-4 position-relative">
                                <ul class="list-unstyled mb-0">
                                    <li class="d-flex align-items-center">
                                        <div
                                            class="date bg-light text-center p-3 me-4 border rounded-3 border-primary text-black">
                                            <div class="fs-4 fw-bold text-black">
                                                <?php echo e(\Carbon\Carbon::parse($webinar->date)->format('d')); ?></div>
                                            <div style="color: #EB343C">
                                                <?php echo e(\Carbon\Carbon::parse($webinar->date)->format('M, y')); ?></div>
                                        </div>
                                        <div class="text_main d-flex flex-column flex-md-row justify-content-between w-100"
                                            style="border: 1px solid #ccc; border-radius: 15px; padding: 28px;">
                                            <div class="text mb-3 mb-md-0">
                                                <h4 class="mb-1"><?php echo e($webinar->title); ?></h4>
                                                <p class="mb-0">
                                                    <?php echo e($webinar->type == 1 ? 'Online' : 'Offline'); ?>, Time:
                                                    <?php echo e($webinar->time); ?>

                                                </p>
                                            </div>
                                            <div class="join_btn align-self-md-center">
                                                <button class="btn btn-primary w-100 w-md-auto" data-bs-toggle="modal"
                                                    data-bs-target="#webinarModal<?php echo e($webinar->id); ?>">Click Here</button>
                                            </div>
                                            <div class="modal fade" id="webinarModal<?php echo e($webinar->id); ?>" tabindex="-1"
                                                aria-labelledby="webinarModalLabel" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="registerModalLabel">Register for
                                                                Free
                                                                Webinar</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                                aria-label="Close"></button>
                                                        </div>
                                                        <form action="<?php echo e(route('webinar.booking.submit')); ?>" method="post">
                                                            <div class="modal-body">
                                                                <?php echo csrf_field(); ?>
                                                                <input type="hidden" name="webinar_id"
                                                                    value="<?php echo e($webinar->id ?? ''); ?>">
                                                                <div class="mb-3">
                                                                    <label for="name" class="form-label">Name <span
                                                                            class="text-danger">*</span></label>
                                                                    <input type="text"
                                                                        class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                        name="name" id="name" placeholder="Name"
                                                                        value="<?php echo e(Auth::check() && Auth::user()->role == 3 ? Auth::user()->name : old('name')); ?>"
                                                                        required>
                                                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                        <div class="invalid-feedback" role="alert">
                                                                            <?php echo e($message); ?></div>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="phone" class="form-label">Phone</label>
                                                                    <input type="tel" name="phone"
                                                                        class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                        id="phone" placeholder="Phone"
                                                                        value="<?php echo e(Auth::check() != null && Auth::user()->role == 3 ? Auth::user()->student->student_phone : old('phone')); ?>"
                                                                        required>
                                                                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                        <div class="invalid-feedback" role="alert">
                                                                            <?php echo e($message); ?></div>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="email" class="form-label">Email</label>
                                                                    <input type="email" name="email"
                                                                        class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                        id="email" placeholder="Email"
                                                                        value="<?php echo e(Auth::check() != null && Auth::user()->role == 3 ? Auth::user()->email : old('email')); ?>"
                                                                        required>
                                                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                        <div class="invalid-feedback" role="alert">
                                                                            <?php echo e($message); ?></div>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="address" class="form-label">Address</label>
                                                                    <textarea type="text" name="address" class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="address"
                                                                        placeholder="Address" required><?php echo e(old('address')); ?></textarea>
                                                                    <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                        <div class="invalid-feedback" role="alert">
                                                                            <?php echo e($message); ?></div>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>

                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit"
                                                                    class="btn btn-primary">Submit</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                                <div class="design-border"></div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <h2 class="text-center" style="color: #EB343C">No Seminar Available</h2>
                <?php endif; ?>

            </div>
        </div>

    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/websited/lms.website-designer-pro.com/resources/views/frontend/pages/webinar/index.blade.php ENDPATH**/ ?>