<?php $__env->startSection('title'); ?>
    Student Bills
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                    <h3 class="text-center"><strong>View Student Bills</strong>
                        <a href="<?php echo e(route('student.bill.add')); ?>" class="float-right btn btn-primary">Add bill</a></h3>
                    <hr>
                    <form action="" id="filterForm">
                        <div class="row">
                            <div class="form-group col-md-4"><label for="" class="form-control-label">Student Roll No</label>
                                <input type="number" placeholder="Enter Roll" name="student_roll" onchange="filter()" class="form-control" value="<?php if(isset($_GET['student_roll'])): ?><?php echo e($_GET['student_roll']); ?><?php endif; ?>">
                            </div>
                            <div class="form-group col-md-4"><label for="" class="form-control-label">Join Year</label>
                                <select name="year" id="year" onchange="filter()" class="form-control">
                                    <option value="">All</option>
                                    <?php for($i=2018; $i<=date('Y'); $i++): ?>)
                                        <option value="<?php echo e($i); ?>" <?php if(isset($_GET['year'])): ?><?php echo e($_GET['year'] == $i ? 'selected':''); ?><?php endif; ?>><?php echo e($i); ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                            <div class="form-group col-md-4"><label for="" class="form-control-label">Join Month</label>
                                <select name="month" id="" onchange="filter()" class="form-control">
                                    <option value="">All</option>
                                    <?php for($i=1; $i<=12; $i++): ?>
                                        <option value="<?php echo e($i); ?>" <?php if(isset($_GET['month'])): ?><?php echo e($_GET['month'] == $i ? 'selected':''); ?><?php endif; ?>><?php echo e($months[$i-1]); ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                        </div>
                    </form>

                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Student Name</th>
                            <th>Roll No</th>
                            <th>Course Name</th>
                            <th>Bill Amount</th>
                            <th>Paid</th>
                            
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $student = getStudentById($item->student_id);
                            $branchStudent = getBranchStudentByStudentId($item->student_id);
                            ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($student != null ? $student->student_name:''); ?></td>
                                <td><?php echo e($branchStudent != null ? $branchStudent->student_roll: ''); ?></td>
                                <td><?php echo e($item->course->course_name ?? ''); ?></td>
                                <td><?php echo e($item->total_fee); ?></td>
                                <td><?php echo e($item->total_paid); ?></td>
                                

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </table>
                    <?php echo e($items->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/websited/lms.website-designer-pro.com/resources/views/admin/student-bill/list.blade.php ENDPATH**/ ?>