<section>
    <div class="container position-relative">
        <div class="row">
        	<div class="col-12">
        		<div style="" class="bg-grad-pink p-4 p-sm-5 rounded-3">
        			<div class="row position-relative">
        				<!-- Svg decoration -->
        				<figure
        					class="fill-white opacity-1 position-absolute top-50 start-0 translate-middle-y">
        					<svg width="141px" height="141px">
        						<path
        							d="M140.520,70.258 C140.520,109.064 109.062,140.519 70.258,140.519 C31.454,140.519 -0.004,109.064 -0.004,70.258 C-0.004,31.455 31.454,-0.003 70.258,-0.003 C109.062,-0.003 140.520,31.455 140.520,70.258 Z">
        						</path>
        					</svg>
        				</figure>
        				<!-- Action box -->
        				<div class="col-11 mx-auto position-relative">
        					<div class="row align-items-center">
        						<!-- Title -->
        						<div class="col-lg-7 text-center text-sm-start">
        							<h3 class="text-white">Admission Going On!</h3>
        							<p class="text-white mb-3 mb-lg-0">Seats are limited, so register and enroll in your desired course asap. Book your seat and start learning for a better career.</p>
        						</div>
        						<!-- Content and input -->
        						<div class="col-lg-5 text-center text-sm-end">
        							<a href="tel:<?php echo e(getSettings('Phone')); ?>" class="btn btn-white text-dark mb-0 footer_cta_contact_btn" style="width: 140px">Contact Us</a><br>
        							<a href="<?php echo e(route('courses')); ?>" class="btn btn-white text-dark mb-0 mt-2 footer_cta_view_btn" style="width: 140px">View Courses</a>
        						</div>
        					</div>
        				</div>
        			</div> <!-- Row END -->
        		</div>
        	</div>
        </div>
    </div>
</section>

<footer class="bg-dark pt-5">
    <div class="container">
        <!-- Row START -->
        <div class="row g-4">

            <!-- Widget 1 START -->
            <div class="col-lg-3">
                <!-- logo -->
                <a class="me-0" href="index_2.html">
                    <img class="h-40px" src="<?php echo e(asset(getSettings('site_logo_dark'))); ?>" alt="logo">
                </a>
                <p class="my-3 text-body-secondary"> <?php echo e(getSettings('short_description') ?? ''); ?></p>
                <!-- Social media icon -->
                <ul class="list-inline mb-0 mt-3">
                    <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-facebook"
                            href="<?php echo e(getSettings('facebook_url')); ?>"><i class="fab fa-fw fa-facebook-f"></i></a> </li>
                    <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-instagram"
                            href="<?php echo e(getSettings('instagram_url')); ?>"><i class="fab fa-fw fa-instagram"></i></a> </li>
                    <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-twitter"
                            href="<?php echo e(getSettings('twitter_url')); ?>"><i class="fab fa-fw fa-twitter"></i></a> </li>
                    <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-linkedin"
                            href="<?php echo e(getSettings('linkedIn_url')); ?>"><i class="fab fa-fw fa-linkedin-in"></i></a> </li>
                    <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-youtube"
                            href="<?php echo e(getSettings('youtube_url')); ?>"><i class="fab fa-fw fa-youtube"></i></a> </li>
                </ul>
            </div>
            <!-- Widget 1 END -->

            <!-- Widget 2 START -->
            <div class="col-lg-6">
                <div class="row g-4">
                    <!-- Link block -->
                    <div class="col-6 col-md-6">
                        <h5 class="mb-2 mb-md-4 text-white">Quick Links</h5>
                        <ul class="nav flex-column text-primary-hover">
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('about.us')); ?>">About Us</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('course.categories')); ?>">Course
                                    Categories</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('courses')); ?>">Courses</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('contact')); ?>">Contact Us</a></li>

                        </ul>
                    </div>

                    <!-- Link block -->
                    <div class="col-6 col-md-6">
                        <h5 class="mb-2 mb-md-4 text-white">Community</h5>
                        <ul class="nav flex-column text-primary-hover">
                            
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('faq')); ?>">FAQ</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('terms-conditions')); ?>">Terms & Conditions</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('privacy-policy')); ?>">Privacy Policy</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('certificate.verify')); ?>">Verify Certificate</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('offer.all')); ?>">Offers</a></li>
                        </ul>
                    </div>

                    <!-- Link block -->
                </div>
            </div>
            <!-- Widget 2 END -->

            <!-- Widget 3 START -->
            <div class="col-lg-3">
                <h5 class="mb-2 mb-md-4 text-white">Contact</h5>
                <!-- Time -->
                <p class="mb-2 text-body-secondary">
                    Phone:<span class="h6 fw-light text-white ms-2" ><a href="tel:<?php echo e(getSettings('Phone')); ?>" class="text-white"><?php echo e(getSettings('Phone')); ?></a></span>
                </p>
                <p class="mb-2 text-body-secondary">
                    WhatsApp:<span class="h6 fw-light text-white ms-2" ><a href="https://wa.me/<?php echo e(str_replace('-', '', getSettings('whatsapp_number'))); ?>" class="text-white"><?php echo e(getSettings('whatsapp_number')); ?></a></span>
                </p>
                <p class="mb-2 text-body-secondary">Visit Time:<span
                        class="h6 fw-light text-white ms-2"><span class="" data-bs-toggle="tooltip" data-bs-animation="false" data-bs-placement="bottom" data-bs-original-title="<?php echo e(getSettings('close_status') ?? ''); ?>"><?php echo e(getSettings('visiting_time')); ?></span></span></p>
                <p class="mb-0 text-body-secondary">Email:<span
                        class="h6 fw-light text-white ms-2"><a href="mailto:<?php echo e(getSettings('email')); ?>" class="text-white"><?php echo e(getSettings('email')); ?></a></span></p>

                <div class="row g-2 mt-2">
                    <!-- Google play store button -->
                    <div class="col-6 col-sm-4 col-md-3 col-lg-6">
                        
                        <div data-bs-toggle="tooltip" data-bs-animation="false" data-bs-placement="bottom"
                            data-bs-original-title="Coming Soon"> <img
                                src="<?php echo e(asset('frontend-assets')); ?>/fonts/google-play.svg" alt=""> </div>
                    </div>
                    <!-- App store button -->
                    <div class="col-6 col-sm-4 col-md-3 col-lg-6">
                        <div data-bs-toggle="tooltip" data-bs-animation="false" data-bs-placement="bottom"
                            data-bs-original-title="Coming Soon"> <img
                                src="<?php echo e(asset('frontend-assets')); ?>/fonts/app-store.svg" alt="app-store"> </div>
                    </div>
                </div> <!-- Row END -->
            </div>
            <!-- Widget 3 END -->
        </div><!-- Row END -->

        <!-- Divider -->
        <hr class="mt-4 mb-0">

        <!-- Bottom footer -->
        <div class="py-3 mb-5 mb-lg-0">
            <div class="container px-0">
                <div class="py-3 text-center text-md-center">
                    <!-- copyright text -->
                    <div class="text-body-secondary"> ©2016-<?php echo e(date('Y')); ?> | <a
                            href="<?php echo e(route('home')); ?>" style="color: #fff; font-weight: bold"><?php echo e(getSettings('site_name') ?? ''); ?></a> | All Rights Reserved
                        |
                        Developed by <a href="https://www.skydreamit.com/" class="" style="color: #fff; font-weight: bold">Sky Dream IT</a> </div>
                    <!-- copyright links-->
                </div>
            </div>
        </div>
    </div>
    
    <div class="custom-nav-container d-block d-md-none">
        <div class="custom-nav-box">
            <ul class="custom-nav-list">
                <!--<li class="custom-nav-item active">-->
                <li class="custom-nav-item side-menu">
                    <a href="<?php echo e(route('home')); ?>" class="custom-nav-link">
                        <div class="custom-nav-icon">
                            <!--<i class="fa fa-home"></i>--> <!-- Home Icon -->
                            <img src="<?php echo e(asset('frontend-assets/images/bottom-nav')); ?>/home.png" alt="Home">
                        </div>
                        <span class="custom-nav-text">Home</span>
                    </a>
                </li>
                <li class="custom-nav-item side-menu">
                    <a href="<?php echo e(route('courses')); ?>" class="custom-nav-link">
                        <div class="custom-nav-icon">
                            <!--<i class="fa-solid fa-book"></i>-->
                            <img src="<?php echo e(asset('frontend-assets/images/bottom-nav')); ?>/diploma.png" alt="Courses">
                        </div>
                        <span class="custom-nav-text">Courses</span>
                    </a>
                </li>
                <li class="custom-nav-item side-menu">
                    <a href="<?php echo e(route('offer.all')); ?>" class="custom-nav-link">
                        <div class="custom-nav-icon">
                            <!--<i class="fas fa-rocket" ></i>-->
                            <img src="<?php echo e(asset('frontend-assets/images/bottom-nav')); ?>/discount.png" alt="Offers">
                        </div>
                        <span class="custom-nav-text">Offers</span>
                    </a>
                </li>
                <li class="custom-nav-item side-menu">
                    <a href="https://wa.me/<?php echo e(str_replace('-', '', getSettings('whatsapp_number'))); ?>" class="custom-nav-link">
                        <div class="custom-nav-icon">
                            <!--<i class="fab fa-whatsapp-square" ></i>-->
                            <img src="<?php echo e(asset('frontend-assets/images/bottom-nav')); ?>/whatsapp.png" alt="Whatsapp">
                        </div>
                        <span class="custom-nav-text">Contact</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>






</footer>
<?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/frontend/include/footer.blade.php ENDPATH**/ ?>