
<!-- Navbar Start -->
<?php $route = Route::currentRouteName(); ?>

<?php
    if ($route != 'course.details' && $route !='checkout') {
        session()->forget('coupon');
    }
    if($route != 'student.sign-up' && $route != 'student.sign-in' && $route != 'student.email.verification' && $route != 'student.verification-code.resend' && $route !='checkout' ){
        Session::forget('currentCourseRoute');
        Session::forget('currentCourseId');
    }
?>

<?php if($route == 'home'): ?>
<style>
    header {
    position: relative;
    z-index: 1020;
    background: #FAF0F3;
}
</style>
<?php else: ?>
<style>
    header {
    position: relative;
    z-index: 1020;
    background: white;
}
</style>
<?php endif; ?>
<style>
    .special-hover {
    border-radius: 50%;
}

.special-hover:hover {
    color: white !important;
    background: #c11d1dc9;
}
.special-nav-hover:hover {
    color: white !important;
    background: #EB343C;
}

.special-hover i:hover{
    transform: scale(1.2);
    transition: transform 0.2s ease-in-out;
}
</style>
    <!-- Top header START -->
<div class="w-100" style="background-color: <?php echo e($route == 'home' ? '#FAF0F3' : 'white'); ?>;">
    <div class="navbar-top navbar-dark d-none d-xl-block py-2 mx-2 mx-md-4 rounded-bottom-4" style="background-color: #EB343C; color: white;" >
        <div class="container">
            <div class="d-lg-flex justify-content-lg-between align-items-center">
                <!-- Navbar top Left-->
                <!-- Top info -->
                <ul class="nav align-items-center justify-content-center">
                    <li class="nav-item me-3" data-bs-toggle="tooltip" data-bs-animation="false" data-bs-placement="bottom" data-bs-original-title="<?php echo e(getSettings('close_status') ?? ''); ?>">
                        <span><i class="far fa-clock me-2"></i>Visit time: <?php echo e(getSettings('visiting_time') ?? ''); ?></span>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link special-nav-hover" href="tel:<?php echo e(getSettings('Phone') ?? ''); ?>"><i class="fas fa-headset me-2"></i>Call us now: <?php echo e(getSettings('Phone') ?? ''); ?></a>
                    </li>
                </ul>

                <!-- Navbar top Right-->
                <div class="nav d-flex align-items-center justify-content-center">
                    <!-- Top social -->
                    <ul class="list-unstyled d-flex mb-0">
                        <li> <a class="px-2 nav-link special-hover" href="<?php echo e(getSettings('facebook_url') ?? '#'); ?>"><i class="fab fa-facebook"></i></a> </li>
                        <li> <a class="px-2 nav-link special-hover" href="<?php echo e(getSettings('instagram_url') ?? '#'); ?>"><i class="fab fa-instagram"></i></a> </li>
                        <li> <a class="px-2 nav-link special-hover" href="<?php echo e(getSettings('twitter_url') ?? '#'); ?>"><i class="fab fa-twitter"></i></a> </li>
                        <li> <a class="px-2 nav-link special-hover" href="<?php echo e(getSettings('linkedIn_url') ?? '#'); ?>"><i class="fab fa-linkedin-in"></i></a> </li>
                        <li> <a class="px-2 nav-link special-hover" href="<?php echo e(getSettings('youtube_url') ?? '#'); ?>"><i class="fab fa-youtube"></i></a> </li>
                        
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Top header END -->

<!-- Header START -->
<header class="navbar-light header-static navbar-sticky">
    <!-- Logo Nav START -->
    <nav class="navbar navbar-expand-xl">
        <div class="container">
            <!-- Logo START -->
            <?php
                $site_logo = getSettings('site_logo');
                $site_logo_dark = getSettings('site_logo_dark');
            ?>
            <a class="navbar-brand me-0" href="<?php echo e(route('home')); ?>">
               <img class="light-mode-item navbar-brand-item" src="<?php echo e(asset($site_logo)); ?>" alt="logo">
               <img class="dark-mode-item navbar-brand-item" src="<?php echo e(asset($site_logo_dark)); ?>" alt="logo">
                
            </a>
            <!-- Logo END -->

            <!-- Main navbar START -->
            <div class="navbar-collapse collapse" id="navbarCollapse">

                <!-- Nav Search END -->
                <ul class="navbar-nav navbar-nav-scroll mx-auto">
                    <!-- Nav item 1 Demos -->
                    <li class="nav-item dropdown">
                        <a class="nav-link " href="<?php echo e(route('home')); ?>" >Home</a>
                    </li>
                    <li class="nav-item"><a class="nav-link " href="<?php echo e(route('about.us')); ?>">About Us</a></li>
                    <li class="nav-item dropdown dropdown-fullwidth">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Course Categories</a>
                        <div class="dropdown-menu dropdown-menu-end" data-bs-popper="none">
                            <div class="row p-4">
                                <!-- Dropdown column item -->
                                <?php $__currentLoopData = $course_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $categorycourse = findCategoryCourse($item->id);

                                ?>
                                <div class="col-xl-3 col-xxl-3 mb-3">
                                    <h6 class="mb-0"><img src="<?php echo e(asset($item->image)); ?>" class="course-cat-img rounded-circle me-1" alt=""> <?php echo e($item->name); ?></h6>
                                    <hr>
                                    <ul class="list-unstyled">
                                        <?php if(count($categorycourse) > 0): ?>
                                        <?php $__currentLoopData = $categorycourse; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li> <a href="<?php echo e(route('course.details', $course->slug)); ?>" class="dropdown-item"><?php echo e(Str::limit($course->course_name, 25, '...')); ?></a> </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <li> <a href="<?php echo e(route('category.course', $item->slug)); ?>" class="dropdown-item">View All</a> </li>
                                        <?php endif; ?>


                                    </ul>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                            </div>
                        </div>
                    </li>

                    <!-- Nav item 3 Account -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="accounntMenu" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Courses</a>
                        <ul class="dropdown-menu" aria-labelledby="accounntMenu">
                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li style=""> <a  class="d-flex overflow-auto dropdown-item" href="<?php echo e(route('course.details', $item->slug)); ?>"><img src="<?php echo e(asset($item->image)); ?>" class="rounded-circle me-1 course-img"><span class="course-name overflow-auto"><?php echo e($item->course_name); ?></span></a> </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <li style=""> <a href="<?php echo e(route('courses')); ?>" class="dropdown-item text-center view-all-btn">View All</a> </li>


                        </ul>
                    </li>
                    <!-- Nav item 4 Component-->
                    <li class="nav-item"><a class="nav-link " href="<?php echo e(route('gallery')); ?>">Gallery</a></li>
                    <li class="nav-item"><a class="nav-link " href="<?php echo e(route('contact')); ?>">Contact Us</a></li>

                </ul>
            </div>
            <!-- Main navbar END -->

            <!-- Nav Search START -->
            <div class="nav nav-item dropdown nav-search px-1 px-lg-3 d-none" >
                <a class="nav-link" role="button" href="#" id="navSearch" data-bs-toggle="dropdown" aria-expanded="true" data-bs-auto-close="outside" data-bs-display="static">
                    <i class="bi bi-search fs-4"> </i>
                </a>
                <div class="dropdown-menu dropdown-menu-end shadow rounded p-2" aria-labelledby="navSearch" data-bs-popper="none">
                    <form class="input-group">
                        <input class="form-control border-primary" type="search" placeholder="Search..." aria-label="Search">
                        <button class="btn btn-primary m-0" type="submit">Search</button>
                    </form>

                </div>
            </div>
            <!-- Nav Search END -->
            
            
            <!-- Profile START -->
            <?php if(auth()->guard()->check()): ?>
            <?php if(Auth::user()->role == 3): ?>
            <?php
                $user = findUser();
            ?>
            <div class="dropdown ms-1 ms-lg-0 account-btn">
                <a class="avatar avatar-sm p-0" href="#" id="profileDropdown" role="button" data-bs-auto-close="outside" data-bs-display="static" data-bs-toggle="dropdown" aria-expanded="false">
                    <?php if($user->student_image != null): ?>
                        <img class="avatar-img rounded-circle border border-white border-3 shadow"
                             src="<?php echo e(asset($user->student_image)); ?>" alt="">
                    <?php else: ?>
                        <img class="avatar-img rounded-circle border border-white border-3 shadow"
                             src="<?php echo e(asset('admin-assets')); ?>/images/default.jpg" alt="" width="200px">
                    <?php endif; ?>

                </a>
                <a href="<?php echo e(route('student.dashboard')); ?>" class="ms-2 d-none d-lg-inline text-black"><?php echo e(Auth::user()->name); ?></a>

                <ul class="dropdown-menu dropdown-animation dropdown-menu-end shadow pt-3" aria-labelledby="profileDropdown">
                    <!-- Profile info -->
                    <li class="px-3 mb-3">
                        <div class="d-flex align-items-center">
                            <!-- Avatar -->
                            <div class="avatar me-3">
                                <?php if($user->student_image != null): ?>
                                    <img class="avatar-img rounded-circle border border-white border-3 shadow"
                                         src="<?php echo e(asset($user->student_image)); ?>" alt="">
                                <?php else: ?>
                                    <img class="avatar-img rounded-circle border border-white border-3 shadow"
                                         src="<?php echo e(asset('admin-assets')); ?>/images/default.jpg" alt="" width="200px">
                                <?php endif; ?>
                            </div>
                            <div>
                                <a class="h6" href="#"><?php echo e(Auth::user()->name); ?></a>
                                <p class="small m-0"><?php echo e(Auth::user()->email); ?></p>
                            </div>
                        </div>
                    </li>
                    <li> <hr class="dropdown-divider"></li>
                    <!-- Links -->
                    <li><a class="dropdown-item" href="<?php echo e(route('student.dashboard')); ?>"><i class="bi bi-ui-checks-grid fa-fw me-2"></i>Dashboard</a></li>
                    <li><a class="dropdown-item" href="<?php echo e(route('student.courses')); ?>"><i class="bi bi-basket fa-fw me-2"></i>My Courses</a></li>
                    <li><a class="dropdown-item" href="<?php echo e(route('student.profile.edit')); ?>"><i class="bi bi-person fa-fw me-2"></i>Edit Profile</a></li>
                    <li><a class="dropdown-item bg-danger-soft-hover" href="#" onclick="event.preventDefault(); document.getElementById('logoutForm').submit()"><i class="bi bi-power fa-fw me-2"></i>Sign Out</a></li>
                    <form action="<?php echo e(route('logout')); ?>" id="logoutForm" method="POST">
                        <?php echo csrf_field(); ?>
                    </form>
                    <!-- Dark mode options START -->

                    <!-- Dark mode options END-->
                </ul>
            </div>

            <?php else: ?>
            <div class="nav nav-item dropdown nav-search px-1 px-lg-3 signin-btn" style="color: black">
                <a href="<?php echo e(route('student.sign-in')); ?>" class="nav-link" >
                    <i class="bi bi-person fs-4"> </i><span style="position:relative; bottom: 3px">Sign In</span>
                </a>

            </div>
            <?php endif; ?>

            <?php endif; ?>
            <?php if(auth()->guard()->guest()): ?>
            <div class="nav nav-item dropdown nav-search px-1 px-lg-3 signin-btn" style="color: black">
                <a href="<?php echo e(route('student.sign-in')); ?>" class="nav-link pe-0" >
                    <i class="bi bi-person fs-4"> </i><span style="position:relative; bottom: 3px">Sign In</span>
                </a>

            </div>
            <?php endif; ?>
            <!-- Profile START -->
            
            <!-- Responsive navbar toggler -->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation" style="margin-right: -10px">
				<span class="navbar-toggler-animation">
					<span></span>
					<span></span>
					<span></span>
				</span>
            </button>
        </div>
    </nav>
    <!-- Logo Nav END -->
</header>
<!-- Header END -->

<?php
if($route != 'student.email.verification' && $route !='student.forget-password.verify' && $route != 'student.password.change'){
//    dd($route);
    Session::forget('request');
    Session::forget('verification_code');
}
?>
<?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/frontend/include/header.blade.php ENDPATH**/ ?>