<?php $__env->startSection('title'); ?>
    Contact Us
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- =======================
    Page Banner START -->
    <section class="pt-5 pb-0"
        style="background-image:url(<?php echo e(asset('frontend-assets')); ?>/fonts/map.svg); background-position: center left; background-size: cover;">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-xl-6 text-center mx-auto">
                    <!-- Title -->
                    <h6 class="text-primary">Contact us</h6>
                    <h1 class="mb-4">We're here to help!</h1>
                </div>
            </div>

            <div class="row">
                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $colClass = 'col-lg-4';
                        if (count($branches) == 1) {
                            $colClass = 'col-lg-12';
                        } elseif (count($branches) == 2) {
                            $colClass = 'col-lg-6';
                        }
                    ?>
                    <div class="<?php echo e($colClass); ?> col-sm-12 mt-lg-0">
                        <div class="card card-body shadow py-5 text-center h-100">
                            <!-- Title -->
                            <h5 class="mb-3"><?php echo e($branch->branchType->branch_type_name); ?> Address</h5>
                            <h6 class="mb-3"><?php echo e($branch->branch_name); ?></h6>
                            <ul class="list-inline mb-0">
                                <!-- Address -->
                                <li class="list-item mb-3 h6 fw-light">
                                    <a href="#">
                                        <i class="fas fa-fw fa-map-marker-alt me-2 mt-1"></i><?php echo e($branch->branch_area); ?>

                                    </a>
                                </li>
                                <!-- Phone number -->
                                <li class="list-item mb-3 h6 fw-light">
                                    <a href="#">
                                        <i class="fas fa-fw fa-phone-alt me-2"></i><?php echo e($branch->branch_phone); ?>

                                    </a>
                                </li>
                                <!-- Email id -->
                                <li class="list-item mb-0 h6 fw-light">
                                    <a href="#">
                                        <i class="far fa-fw fa-envelope me-2"></i><?php echo e($branch->branch_email); ?>

                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>


            <!-- Contact info box -->

        </div>
    </section>
    <!-- =======================
        Page Banner END -->

    <!-- =======================
        Image and contact form START -->
    <section>
        <div class="container">
            <div class="row g-4 g-lg-0 align-items-center">

                <div class="col-md-6 align-items-center text-center">
                    <!-- Image -->
                    <img src="<?php echo e(asset('frontend-assets')); ?>/fonts/contact.svg" class="h-400px" alt="">

                    <!-- Social media button -->
                    <div class="d-sm-flex align-items-center justify-content-center mt-2 mt-sm-4">
                        <h5 class="mb-0">Follow us on:</h5>
                        <ul class="list-inline mb-0 ms-sm-2">
                            <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-facebook"
                                    href="<?php echo e(getSettings('facebook_url')); ?>"><i class="fab fa-fw fa-facebook-f"></i></a>
                            </li>
                            <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-instagram"
                                    href="<?php echo e(getSettings('instagram_url')); ?>"><i class="fab fa-fw fa-instagram"></i></a>
                            </li>
                            <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-twitter"
                                    href="<?php echo e(getSettings('twitter_url')); ?>"><i class="fab fa-fw fa-twitter"></i></a> </li>
                            <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-linkedin"
                                    href="<?php echo e(getSettings('linkedIn_url')); ?>"><i class="fab fa-fw fa-linkedin-in"></i></a>
                            </li>
                            <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-youtube"
                                    href="<?php echo e(getSettings('youtube_url')); ?>"><i class="fab fa-fw fa-youtube"></i></a> </li>
                        </ul>
                    </div>
                </div>

                <!-- Contact form START -->
                <div class="col-md-6">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <!-- Title -->
                    <h2 class="mt-4 mt-md-0">Let's talk</h2>
                    <p>To request a quote or want to meet up for coffee, contact us directly or fill out the form and we
                        will get back to you promptly</p>

                    <form action="<?php echo e(route('user.message.send')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <!-- Name -->
                        <div class="mb-4 bg-light-input">
                            <label for="yourName" class="form-label">Your name *</label>
                            <input type="text" name="name" class="form-control form-control-lg" id="yourName"
                                required>
                        </div>
                        <!-- Email -->
                        <div class="mb-4 bg-light-input">
                            <label for="emailInput" class="form-label">Email address *</label>
                            <input type="email" name="email" class="form-control form-control-lg" id="emailInput"
                                required>
                        </div>
                        <!-- Message -->
                        <div class="mb-4 bg-light-input">
                            <label for="textareaBox" class="form-label">Message *</label>
                            <textarea class="form-control" name="message" id="textareaBox" rows="4" required></textarea>
                        </div>
                        <!-- reCAPTCHA -->
                        <div class="mb-4">
                            <?php echo NoCaptcha::display(); ?>

                        </div>
                        <!-- Button -->
                        <div class="d-grid">
                            <button class="btn btn-lg btn-primary mb-0" type="submit">Send Message</button>
                        </div>
                    </form>
                </div>

                <!-- Contact form END -->
            </div>
        </div>
    </section>
    <!-- =======================
        Image and contact form END -->

    <!-- =======================
        Map START -->
    
    <!-- =======================
        Map END -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/frontend/pages/contact-us/index.blade.php ENDPATH**/ ?>