<?php $__env->startSection('title'); ?>
    Assigned Batch List
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                            <h3 class="text-center"><strong>View Assigned Batch List</strong></h3>
                        </div>
                    </div>

                    <hr>
                    <form action="" id="filterForm">
                        <div class="row mb-3">
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Status</label>
                                <select name="course_status_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="1" <?php if(isset($_GET['course_status_id'])): ?><?php echo e($_GET['course_status_id'] == '1' ? 'selected':''); ?><?php endif; ?>>Active</option>
                                    <option value="0" <?php if(isset($_GET['course_status_id'])): ?><?php echo e($_GET['course_status_id'] == '0' ? 'selected':''); ?><?php endif; ?>>Inactive</option>
                                </select>

                            </div>
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Course Type</label>
                                <select name="course_type" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="online"
                                    <?php if(isset($_GET['course_type'])): ?><?php echo e($_GET['course_type'] == 'online' ? 'selected':''); ?><?php endif; ?>>
                                        Offline</option>
                                    <option value="offline" <?php if(isset($_GET['course_type'])): ?><?php echo e($_GET['course_type'] == 'offline' ? 'selected':''); ?><?php endif; ?>
                                    >Online</option>
                                </select>
                            </div>

                        </div>

                    </form>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course Name<br><span class="second-line">Course Code</span></th>
                            <th>Branch Name</th>
                            <th>Batch Name</th>
                            <th>Duration<br><span class="second-line">Lectures</span></th>
                            <th><span class="second-line">Type</span></th>
                            <th><span class="second-line">Total Students</span></th>
                            <th><span class="second-line">Status</span></th>
                            <th>Action</th>
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->course->course_name ?? ''); ?><br><span><?php echo e($item->course->course_code ?? ''); ?></span></td>
                                <td><?php echo e($item->branch->branch_name ?? ''); ?></td>
                                <td><?php echo e($item->batch_name ?? ''); ?></td>
                                <td><?php echo e($item->course->course_duration); ?><br><span><?php echo e($item->course->total_lectures); ?></span></td>
                                <td><span><?php echo e($item->course->course_type); ?> <br></span><a href="<?php echo e($item->course->course_type == 'online' ? $item->course->course_link:''); ?>"><?php echo e($item->course->course_type == 'online' ? $item->course->course_link:''); ?></a></td>

                                <td class="text-center">
                                    <span><?php echo e(count(getStudentsByBatchId($item->id))); ?></span>
                                    </td>
                                <td class="text-center"><?php if($item->completion_request == 1 ): ?> Completion Requested <?php elseif($item->status == 1): ?>Ongoing <?php elseif($item->status == 3): ?> Completed <?php else: ?> Inactive <?php endif; ?> </td>
                                <td class="btn-group">
                                    <a href="<?php echo e(route('teacher.student.list.by-batch', $item->id)); ?>" class=" ms-3 btn btn-primary"  title="View Students"><i class="fa fa-users"></i></a>
                                    <a href="<?php echo e(route('teacher.schedule.list', $item->id)); ?>" class="btn btn-success mx-1" title="View Class Schedule"><i class="fa fa-calendar"></i></a>
                                <?php if($item->status != 4  && $item->completion_request != 1): ?>
                                        <a href="<?php echo e(route('teacher.batch.complete.request', $item->id)); ?>" class="btn btn-info" title="Complete Course"><i class="fa fa-check"></i></a>
                                    <?php endif; ?>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/teacher/batch/list.blade.php ENDPATH**/ ?>