<?php $__env->startSection('title'); ?>
    Testimonials
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row mt-1">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header text-center">
                    <h3 class="text-success"><?php echo e(session('message')); ?></h3>
                    <h2>Testimonial List</h2>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Profession</th>
                            <th>Image</th>
                            <th>Course</th>
                            <th>Rating</th>
                            <th>Description</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->name); ?></td>
                                <td>
                                    <?php echo e($item->profession); ?>

                                </td>
                                <td>
                                    <?php if($item->image != null): ?>
                                        <img src="<?php echo e(asset($item->image)); ?>" class="rounded-circle" height="50px" width="50px" alt="">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('admin-assets')); ?>/images/default.jpg" class="rounded-circle" height="50px" width="50px" alt="">
                                    <?php endif; ?>

                                </td>
                                <td><?php echo e($item->course->course_name ?? ''); ?></td>
                                <td><?php echo e($item->rating); ?></td>
                                <td><?php echo e($item->description); ?></td>
                                <td>
                                    <div class="mt-2">
                                        <span class="<?php echo e($item->status == 1 ? 'bg-success':'bg-danger'); ?> p-2 text-white" style="border-radius:5px">
                                    <?php echo e($item->status == 1 ? 'Active':'Inactive'); ?></span>
                                    </div>
                                </td>
                                <td class="btn-group">
                                    <a href="<?php echo e(route('admin.testimonial.edit', ['id'=>$item->id])); ?>" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                    <form action="<?php echo e(route('admin.testimonial.remove')); ?>" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                        <button type="submit" title="Remove" class="btn btn-danger" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/admin/testimonial/list.blade.php ENDPATH**/ ?>