<style>
    .dashboard-shadow {
        font-size: 3rem;
        /* Adjust the font size as needed */
        font-weight: bold;
        /* Make the text bold */
        color: #ffffff;
        /* White text color */
        text-shadow: 3px 3px 6px rgba(0, 0, 0, 0.7);
        /* Shadow effect */
    }
</style>
<section class="pt-0">
    <div class="container-fluid px-0">
        <div class="card bg-blue h-100px h-md-200px rounded-0"
            style="background:url('<?php echo e(asset('frontend-assets')); ?>/images/04.png') no-repeat center center; background-size:cover;">
            <div class="d-flex justify-content-center align-items-center h-100">
                <?php if(Route::currentRouteName() == 'student.dashboard'): ?>
                    <h1 class="text-white dashboard-shadow">Dashboard</h1>
                <?php elseif(Route::currentRouteName() == 'student.courses'): ?>
                    <h1 class="text-white dashboard-shadow">My Courses</h1>
                <?php elseif(Route::currentRouteName() == 'student.profile.edit'): ?>
                    <h1 class="text-white dashboard-shadow">Edit Profile</h1>
                <?php elseif(Route::currentRouteName() == 'student.notice'): ?>
                    <h1 class="text-white dashboard-shadow">Notices</h1>
                <?php elseif(Route::currentRouteName() == 'student.curriculum'): ?>
                    <h1 class="text-white dashboard-shadow">Course Curriculum</h1>
                <?php elseif(Route::currentRouteName() == 'student.course.review'): ?>
                    <h1 class="text-white dashboard-shadow">Review Course</h1>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="container mt-n4">
        <div class="row">
            <div class="col-12">
                <div class="card bg-transparent card-body pb-0 px-0 mt-2 mt-sm-0">
                    <div class="row d-sm-flex justify-sm-content-between mt-2 mt-md-0">
                        <!-- Avatar -->
                        <div class="col-auto">
                            <div class="avatar avatar-xxl position-relative mt-n3">
                                <?php if($user->student_image != null): ?>
                                <img class="avatar-img rounded-circle border border-white border-3 shadow"
                                    src="<?php echo e(asset($user->student_image)); ?>" alt="">
                                <?php else: ?>
                                    <img class="avatar-img rounded-circle border border-white border-3 shadow"
                                         src="<?php echo e(asset('admin-assets')); ?>/images/default.jpg" alt="" width="200px">
                                <?php endif; ?>
                                
                            </div>
                        </div>

                        <!-- Profile info -->
                        <div class="col d-sm-flex justify-content-between align-items-center">
                            <div>
                                <h1 class="my-1 fs-4"><?php echo e(Auth::user()->name); ?></h1>
                                <ul class="list-inline mb-0">
                                    
                                    <li class="list-inline-item me-3 mb-1 mb-sm-0">
                                        <span class="h6"><?php echo e(count($enrolled_course_count)); ?></span>
                                        <span class="text-body fw-light">Enrolled courses</span>
                                    </li>
                                    
                                </ul>
                            </div>
                            <!-- Button -->
                            <div class="mt-2 mt-sm-0">
                                <a href="<?php echo e(route('courses')); ?>" class="btn btn-sm btn-success-soft mb-0">View All
                                    Courses</a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Advanced filter responsive toggler START -->
                <!-- Divider -->
                
                <!-- Advanced filter responsive toggler END -->
            </div>
        </div>
    </div>
</section>
<?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/frontend/student/include/header.blade.php ENDPATH**/ ?>