<?php $__env->startSection('title'); ?>
    Offer Details
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="description" content="Start your freelancing career with expert-led courses on in-demand skills and live projects. Get certified and have a chance to join our agency!">
    <meta name="keywords" content="freelancing career courses in Bangladesh">
    
    <meta name="og:title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="og:image" content="<?php echo e(asset('frontend-assets')); ?>/images/meta_image.png">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <section class="pt-0">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <!-- Card item START -->
                    <div class="card overflow-hidden h-400px rounded-3" style="background-image:url(<?php echo e(asset($item->image)); ?>); background-position: center left; background-size: cover;">
                        <!-- Background dark overlay -->
                        <div class="bg-overlay bg-dark opacity-6"></div>

                        <!-- Card image overlay -->
                        <div class="card-img-overlay d-flex align-items-start flex-column">
                            <!-- Card overlay Top -->
                            <div class="w-100 mb-auto d-flex justify-content-end">
                                <button class="btn btn-sm btn-white mb-0 offer-link" data-offer="<?php echo e(route('offer.details', $item->slug)); ?>"><i class="bi bi-share"></i> Share</button>
                            </div>
                            <!-- Card overlay bottom -->
                            <div class="w-100 mt-auto">
                                <div class="row p-0 p-sm-3">
                                    <div class="col-11 col-lg-7">
                                        <!-- Title -->
                                        <h1 class="text-white"><?php echo e($item->title); ?></h1>
                                        <p class="text-white mb-0"><?php echo $item->description; ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Card item END -->
                </div>
            </div>
        </div>
    </section>
    <!-- =======================
    Main banner END -->

    <!-- =======================
    Page content START -->
    <section class="pt-0">
        <div class="container">
            <div class="row g-4 g-lg-5">

                <!-- Main content START -->
                <div class="col-lg-12 order-2">
                    <!-- Organization and time -->
                    <div class="bg-light rounded-3 p-3 mb-4">
                        <div class="row g-4">
                            <!-- Organization -->
                            <?php if($item->start_date <= date('Y-m-d')): ?>
                                <div class="col-md-4 ">

                                    <div class="d-flex align-items-center">
                                        <!-- Avatar -->
                                        <div class="avatar align-middle">
                                            <div class="avatar-img rounded-1 bg-danger"><span class="text-white position-absolute top-50 start-50 translate-middle fw-bold"><img
                                                        src="<?php echo e(asset('frontend-assets')); ?>/icons/discount-1.png" alt=""></span></div>
                                        </div>
                                        <!-- Info -->
                                        <div class="ms-2">
                                            
                                            <?php if($item->start_date > date('Y-m-d')): ?>
                                                <h6 class="mb-0">Upcoming</h6>
                                            <?php else: ?>
                                                <h6 class="mb-0 border border-1 border-secondary" style="border-radius: 0.325rem"><span class="mx-3">
                                                    <?php echo e($item->coupon->coupon_code ?? 'No Coupon'); ?></span>
                                                    <span class="btn btn-primary coupon-code mb-0 rounded-end"  data-coupon="<?php echo e($item->coupon->coupon_code ?? ''); ?>">
                                                <i class="fa fa-copy"></i>
                                            </span>

                                                </h6>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="col-md-4 mx-auto">
                                    <h6 class="small ms-2">Status:</h6>
                                    <div class="d-flex align-items-center">
                                        <h6 class="text-primary ms-2">Upcoming</h6>
                                    </div>
                                </div>
                            <?php endif; ?>


                            <!-- Location -->
                            <div class="col-md-4">

                                <div class="d-flex align-items-center">
                                    <!-- Avatar -->
                                    <div class="avatar align-middle flex-shrink-0">
                                        <div class="avatar-img rounded-2 bg-dark">
                                            <span class="position-absolute top-50 start-50 translate-middle text-white"><i class="bi bi-people"></i></span>
                                        </div>
                                    </div>
                                    <div>
                                        <h6 class="small ms-2">Use Limit:</h6>
                                        <h6 class="fw-normal mb-0 ms-2"><?php echo e($item->coupon->total_use_limit ?? '0'); ?> <small>(Each User Can Use The Coupon <?php echo e($item->coupon->limit_per_user); ?> Time<?php echo e($item->coupon != null && $item->coupon->limit_per_user > 0 ? 's':''); ?>)</small></h6>
                                    </div>
                                </div>
                            </div>


                            <!-- Date & Time -->
                            <div class="col-md-4">

                                <div class="d-flex align-items-center">
                                    <!-- Avatar -->
                                    <div class="avatar align-middle flex-shrink-0">
                                        <div class="avatar-img rounded-2 bg-dark">
                                            <span class="position-absolute top-50 start-50 translate-middle text-white"><i class="bi bi-calendar-fill"></i></span>
                                        </div>
                                    </div>
                                    <div class="ms-2">
                                        <?php if($item->start_date > date('Y-m-d')): ?>
                                            <h6 class="small">Starts From:</h6>
                                            <h6 class="fw-normal mb-0"><?php echo e(date('d M, Y', strtotime($item->start_date))); ?></h6>
                                        <?php else: ?>
                                            <h6 class="small">Validity:</h6>
                                            <h6 class="fw-normal mb-0"><?php echo e(date('d M, Y', strtotime($item->end_date))); ?></h6>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Content -->
                    <h4>About This Offer</h4>
                    <?php echo $item->description; ?>

                    <h6>Using the coupon you will get <?php echo e($item->coupon->discount ?? ''); ?><?php echo e($item->coupon && $item->coupon_discount_type == 1 ? 'BDT':'%'); ?> discount on the courses below.</h6>

                    <!-- Speakers -->
                    <h4 class="mt-4 mb-3">Applicable Courses</h4>

                    <!-- Speaker list START -->
































                    <div class="row ">
                        <!-- Slider START -->
                        <?php $__currentLoopData = json_decode($item->course_ids); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $course = getCourseById($course_id) ?>
                            <?php if($course): ?>
                            <div class="col-md-4 my-3">
                                <div class="card shadow h-100">
                                    <a href="<?php echo e(route('course.details', $course->slug)); ?>">
                                        <div class="rounded-top overflow-hidden">
                                            <div class="card-overlay-hover">
                                                <!-- Image -->
                                                <img src=" <?php echo e(asset($course->image)); ?>" class="card-img-top"
                                                     alt="course image">

                                            </div>
                                        </div>
                                    </a>
                                    <!-- Card body -->
                                    <div class="card-body">
                                        <!-- Rating and avatar -->
                                        <div class="d-flex justify-content-between">
                                            <!-- Rating and info -->
                                            <ul class="list-inline hstack gap-2 mb-0">
                                                <!-- Info -->
                                                <li class="list-inline-item d-flex justify-content-center align-items-center">
                                                    <div class="icon-md bg-orange bg-opacity-10 text-orange rounded-circle"><i class="fas fa-clock"></i></div>
                                                    <span class="h6 fw-light mb-0 ms-2"><?php echo e($course->course_duration); ?></span>
                                                </li>
                                                <!-- Rating -->



                                            </ul>
                                            <!-- Avatar -->
                                            <div class="d-flex justify-content-center align-items-center">
                                                <div class="icon-md bg-primary bg-opacity-15 text-primary rounded-circle"><i class="fas fa-table"></i></div>
                                                <span class="h6 fw-light mb-0 ms-2"><?php echo e($course->total_lectures); ?> Lecture<?php echo e($course->total_lectures > 1 ? 's':''); ?></span>
                                            </div>
                                        </div>
                                        <!-- Divider -->
                                        <hr>
                                        <div class="d-flex justify-content-between mb-3">
                                            <div class="hstack gap-2">
                                                <a href="<?php echo e(route('course.details', $course->slug)); ?>" class="badge text-bg-dark">
                                                    <?php echo e(Str::title($course->course_type)); ?>

                                                </a>
                                            </div>
                                        </div>
                                        <!-- Title -->
                                        <h5 class="card-title"><a href="<?php echo e(route('course.details', $course->slug)); ?>"><?php echo e($course->course_name); ?></a></h5>
                                        <!-- Badge and Price -->
                                        <div
                                            class="d-flex justify-content-between align-items-center mb-0 position-relative">
                                            <!-- Category -->
                                            <a href="<?php echo e(route('category.course', $course->category->slug ?? '#')); ?>"
                                               class="badge bg-info bg-opacity-10 text-info me-2" style="
                                                    margin-top: 20px">
                                                <i class="fas fa-circle small fw-bold"></i> <?php echo e($course->category->name); ?>

                                            </a>
                                            <!-- Price Container -->
                                            <div class="">
                                                <?php if($course->course_status_id == 1): ?>
                                                    <del class="text-danger mb-1 ">
                                                        <?php echo e($course->course_fee ?? ''); ?> BDT
                                                    </del>
                                                    <h5 class="text-success mb-0">
                                                        <?php echo e($course->course_fee - $course->discount ?? ''); ?> BDT
                                                    </h5>
                                                <?php elseif($course->course_status_id == 2): ?>
                                                    <h4 class="bg-info bg-opacity-10" style="color: #D6293E;padding: 5px;border-radius: 9px;">Upcoming</h4>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <!-- Slider END -->
                    </div>
                    <!-- Speaker list END -->

                </div>
                <!-- Main content END -->


            </div><!-- Row END -->
        </div>
    </section>
    <!-- =======================
    Page content END -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function() {
            // Initialize Bootstrap tooltips
            $('[data-bs-toggle="tooltip"]').tooltip();

            // Function to copy coupon code to clipboard
            $(document).on('click', '.coupon-code', function() {
                // Get the coupon code from data attribute
                var couponCode = $(this).data('coupon');

                // Create a temporary input element to copy the text
                var tempInput = $('<input>');
                $('body').append(tempInput);
                tempInput.val(couponCode).select();
                document.execCommand('copy');
                tempInput.remove();

                // Update tooltip to show success message
                $(this).attr('title', 'Coupon Code Copied!').tooltip('show');

                // Revert back to the original tooltip after a short delay
                // var _this = $(this);
                // setTimeout(function() {
                //     _this.attr('title', 'Click to copy!').tooltip('hide');
                // }, 1500);
            });
        });
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/frontend/pages/offer/detail.blade.php ENDPATH**/ ?>