<?php $__env->startSection('title'); ?>
    All Offers
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- =======================
Page Banner START -->
    <section class="bg-dark align-items-center d-flex" style="background:url(<?php echo e(asset('frontend-assets')); ?>/images/04.png) no-repeat center center; background-size:cover;">
        <!-- Main banner background image -->
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <!-- Title -->
                    <h1 class="text-white">All Offers</h1>
                    <!-- Breadcrumb -->
                    <div class="d-flex">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb breadcrumb-dark breadcrumb-dots mb-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                                <li class="breadcrumb-item " aria-current="page">Offers</li>
                                <li class="breadcrumb-item active" aria-current="page">All</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- =======================
    Page Banner END -->

    <!-- =======================
    Page content START -->
    <section class="pb-0 py-sm-5">
        <div class="container">













































            <div class="row">
                <!-- Main content START -->
                <div class="col-xl-12 col-xxl-12">

                    <!-- Course list START -->
                    <div class="row g-4">
                        <?php if(count($items) > 0): ?>
                        <?php else: ?>
                            <div class="col-12 text-center">
                                <h3 class="text-primary">
                                    No Offers Available. Keep An Eye For Our Upcoming Offers.
                                </h3>
                            </div>
                        <?php endif; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!-- Card list START -->
                            <div class="col-12">
                                <div class="card shadow overflow-hidden p-2">
                                    <div class="row g-0">
                                        <div class="col-md-5 overflow-hidden">
                                            <img src="<?php echo e(asset($item->image)); ?>" class="rounded-2" alt="Card image">
                                            <!-- Ribbon -->



                                        </div>
                                        <div class="col-md-7">
                                            <div class="card-body">
                                                <!-- Badge and rating -->
                                                <div class="d-flex justify-content-between align-items-center mb-2">
                                                    <!-- Badge -->

                                                    <!-- Rating and wishlist -->




                                                </div>

                                                <!-- Title -->
                                                <h5 class="card-title"><a href="#"><?php echo e($item->title); ?> <span class="text-primary"><?php echo e($item->start_date > date('Y-m-d') ? '(Upcoming)':''); ?></span></a></h5>
                                                <p class="text-truncate-2 d-none d-lg-block"><?php echo $item->description; ?></p>

                                                <!-- Info -->
                                                <ul class="list-inline">
                                                    <li class="list-inline-item h6 fw-light mb-1 mb-sm-0"><i class="far fa-clock text-danger me-2"></i><?php echo e(date('d M, Y', strtotime($item->start_date))); ?> - <?php echo e(date('d M, Y', strtotime($item->end_date))); ?></li>
                                                    <li class="list-inline-item h6 fw-light">
                                                        <i class="fas fa-hourglass-half text-warning me-2"></i> <span class="fw-bold"><?php echo e($item->start_date > date('Y-m-d') ? 'Starting In: ':'Ending In:'); ?></span>
                                                        <span class="countdown-timer" data-end-date="<?php echo e($item->start_date > date('Y-m-d') ? $item->start_date:$item->end_date); ?>"></span>
                                                    </li>






                                                    <li class="list-inline-item h6 fw-light"><i class="fas fa-users text-success me-2"></i><?php echo e($item->coupon->total_use_limit ?? 0); ?> Coupon<?php echo e($item->coupon && $item->coupon->total_use_limit > 0 ? 's':''); ?> <?php echo e($item->start_date > date('Y-m-d') ? 'Available':'Remaining'); ?> <small class="text-danger">(Conditions Apply)</small></li>
                                                </ul>

                                                <!-- Price and avatar -->
                                                <div class="d-sm-flex justify-content-sm-<?php echo e($item->start_date <= date('Y-m-d') ? 'between':'end'); ?> align-items-center">
                                                    <!-- Price -->
                                                    <?php if($item->start_date <= date('Y-m-d')): ?>
                                                        <div class="mt-3 mt-sm-0">
                                                            <h6 class="mb-0 border border-1 border-secondary" style="border-radius: 0.325rem"><span class="mx-3"><?php echo e($item->coupon->coupon_code ?? 'No Coupon'); ?></span>
                                                                <span class="btn btn-primary coupon-code mb-0 rounded-end"  data-coupon="<?php echo e($item->coupon->coupon_code ?? ''); ?>">
                                                <i class="fa fa-copy"></i>
                                            </span>
                                                            </h6>
                                                            
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="mt-3 mt-sm-0">
                                                        <a href="<?php echo e(route('offer.details', $item->slug)); ?>" class="btn btn-dark">View Details</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Card list END -->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </div>
                    <!-- Course list END -->

                    <!-- Pagination START -->
                    <div class="col-12">
                        <?php echo e($items->links('pagination::bootstrap-5')); ?>

                    </div>
                    <!-- Pagination END -->
                </div>
                <!-- Main content END -->

























































































































































































            </div><!-- Row END -->
        </div>
    </section>
    <!-- =======================
    Page content END -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function() {
            // Function to calculate and update the countdown timer
            function updateCountdown() {
                // Loop through each countdown-timer element
                $('.countdown-timer').each(function() {
                    // Get the end date from the data attribute
                    var endDateStr = $(this).data('end-date');
                    var endDate = new Date(endDateStr);

                    // Get the current date and time
                    var now = new Date();

                    // Calculate the difference in milliseconds
                    var diff = endDate - now;

                    // Convert milliseconds into days, hours, minutes, and seconds
                    var days = Math.floor(diff / (1000 * 60 * 60 * 24));
                    var hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    var minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
                    var seconds = Math.floor((diff % (1000 * 60)) / 1000);

                    // Update the countdown timer text
                    if (diff > 0) {
                        $(this).text(days + "d " + hours + "h " + minutes + "m " + seconds + "s");
                    } else {
                        // If time is expired
                        $(this).text("Expired");
                    }
                });
            }

            // Update countdown every second
            setInterval(updateCountdown, 1000);
        });
    </script>
    <script>
        $(document).ready(function() {
            // Initialize Bootstrap tooltips
            $('[data-bs-toggle="tooltip"]').tooltip();

            // Function to copy coupon code to clipboard
            $(document).on('click', '.coupon-code', function() {
                // Get the coupon code from data attribute
                var couponCode = $(this).data('coupon');

                // Create a temporary input element to copy the text
                var tempInput = $('<input>');
                $('body').append(tempInput);
                tempInput.val(couponCode).select();
                document.execCommand('copy');
                tempInput.remove();

                // Update tooltip to show success message
                $(this).attr('title', 'Coupon Code Copied!').tooltip('show');

                // Revert back to the original tooltip after a short delay
                // var _this = $(this);
                // setTimeout(function() {
                //     _this.attr('title', 'Click to copy!').tooltip('hide');
                // }, 1500);
            });
        });
    </script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/frontend/pages/offer/index.blade.php ENDPATH**/ ?>