@extends('admin.master')
@section('title')
    Student List
@endsection
@section('content')

    @php
    $column='col-sm-2';
    $route = Route::currentRouteName();

    @endphp
    <div class="row mt-5 ">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="text-center">Batch Students</h2>
                    <h4 class="text-center text-success">{{session('message')}}</h4>

                        <hr>
                        <form id="filterForm">
                            <div class="row">
                                <div class="form-group col-sm-{{$route != 'teacher.student.list.by-batch' ? '6':'12'}}">
                                    <label for="" class="form-control-label">Student Roll</label>
                                    <input name="student_roll" id="student_roll" placeholder="Enter Student Roll" onchange="filter()" type="text" class="form-control" value="@isset($_GET['student_roll']){{$_GET['student_roll']}}@endisset">
                                </div>
                                @if($route != 'teacher.student.list.by-batch')
                                <div class="form-group col-sm-6">
                                    <label for="" class="form-control-label">Course</label>
                                    <select name="course_id" id="year" onchange="filter()" class="form-control">
                                        <option value="">All</option>
                                        @foreach(assignedCourses() as $course)
                                            <option value="{{$course->course_id}}" @isset($_GET['course_id']) @if($course->course_id == $_GET['course_id']) selected @endif @endisset>{{$course->course->course_name ?? ''}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="" class="form-control-label">Branch</label>
                                    <select name="branch_id" id="year" onchange="filter()" class="form-control">
                                        <option value="">All</option>
                                        @isset($assigned_branches)
                                            @foreach($assigned_branches as $branch)
                                                <option value="{{$branch->branch_id}}" @isset($_GET['branch_id']) @if($branch->branch_id == $_GET['branch_id']) selected @endif @endisset>{{$branch->branch->branch_name ?? ''}}</option>
                                            @endforeach
                                        @endisset
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="" class="form-control-label">Batch</label>
                                    <select name="batch_id" id="year" onchange="filter()" class="form-control">
                                        <option value="">All</option>
                                        @isset($batches)
                                            @foreach($batches as $batch)
                                                <option value="{{$batch->id}}" @isset($_GET['batch_id']) @if($batch->batch_id == $_GET['batch_id']) selected @endif @endisset>{{$batch->batch_name ?? ''}}</option>
                                            @endforeach
                                        @endisset
                                    </select>
                                </div>
                                @endif
                                {{--                            <div class="form-group col-sm-4">--}}
                                {{--                                <label for="" class="form-control-label">Year</label>--}}
                                {{--                                <select name="year" id="year" onchange="filter()" class="form-control">--}}
                                {{--                                    <option value="">All</option>--}}
                                {{--                                    @for($i=2018; $i<=date('Y'); $i++)--}}
                                {{--                                        <option value="{{$i}}" @isset($_GET['year']) @if($i == $_GET['year']) selected @endif @endisset>{{$i}}</option>--}}
                                {{--                                    @endfor--}}
                                {{--                                </select>--}}
                                {{--                            </div>--}}
                            </div>

                        </form>

                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="filter_table" class="table table-striped">
                            <thead>
                                <tr>
                                <th>#</th>
                                <th>Image</th>
                                <th>Name</th>
{{--                               <th>Father's Name<br><span class="second-line">Mother's Name</span></th>--}}
                                <th>Roll No<br><span class="second-line">Registration No</span></th>
                                <th>Phone</th>
                                <th>Course Name</th>
{{--                                @if(Auth::user()->role == 1)--}}
                                <th>Branch Name</th>
                                <th>Batch Name</th>
                                    <th>Status</th>
{{--                                @endif--}}

{{--                                <th>Join Date</th>--}}
{{--                                @if(Auth::user()->role == 2)--}}
{{--                                    <th>Action</th>--}}
{{--                                @endif--}}
                                {{-- <th>Download</th> --}}
                            </tr>
                            </thead>
                            @php $i=1; @endphp
                            <tbody>
{{--                            @php dd($items) @endphp--}}
                                @foreach($items as $item)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>
                                        @if($item->student && $item->student->student_image != null)
                                            <img src="{{asset($item->student->student_image ?? '')}}" class="rounded-circle" width="50px" alt="">
                                        @endif
                                    </td>
                                    <td>{{$item->student->student_name ?? ''}}</td>
                                    <td>{{$item->student_roll ?? ''}} <br><span>{{$item->student_registration ?? ''}}</span></td>
                                    <td>{{$item->student->student_phone ?? ''}}</td>
                                    <td>{{$item->course->course_name ?? ''}}</td>
                                    <td>{{$item->branch->branch_name ?? ''}}</td>
                                    <td>{{$item->batch->batch_name ?? ''}}</td>
                                    <td>
                                        @if($item->status != 3)
                                            <form action="{{route('teacher.student.status.change')}}" id="statusChangeForm{{$item->id}}" method="post">
                                                @csrf
                                                <input type="hidden" value="{{$item->id}}" name="id">
                                                <select name="status" id="status{{$item->id}}" class="form-control" onchange="submitForm({{$item->id}})">
                                                    <option value="1" {{$item->status == '1' ? 'selected':''}}>On Going</option>
                                                    <option value="4" {{$item->status == '4' ? 'selected':''}}>Dropped</option>
                                                    <option value="3" {{$item->status == '3' ? 'selected':''}}>Completed</option>
                                                    <option value="2" {{$item->status == '2' ? 'selected':''}}>Banned</option>
                                                </select>
                                            </form>
                                        @else
                                            Completed
                                        @endif

                                    </td>


                                </tr>

                            @endforeach
                            </tbody>
                        </table>
                        {{$items->links('pagination::bootstrap-5')}}
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class="modal" id="myModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="{{route('teacher.student.status.change')}}"  method="post">
                    @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Reason</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="status" id="reason_status" value="">
                    <input type="hidden" value="" name="id" id="reason_id">
                    <textarea name="comment" class="form-control" placeholder="Enter Reason" id="" cols="30" rows="10" required></textarea>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <script>
        function filter(){
            jQuery('#filterForm').submit()
        }
        function submitForm(id){
            var value = jQuery('#status'+id).val();
            if(value == 2 || value == 4){
                jQuery('#reason_status').val(value);
                jQuery('#reason_id').val(id);
                jQuery('#myModal').modal('show');
            }
            else {
                jQuery('#myModal').modal('hide');
                jQuery('#statusChangeForm'+id).submit();
            }

        }
    </script>
{{--    <script>--}}
{{--        jQuery(document).ready(function() {--}}
{{--            jQuery('#mySelect').change(function() {--}}
{{--                if ($(this).val() == 2 || $(this).val() == 4) { // Replace 'option2' with the desired value--}}
{{--                    jQuery('#reason_status').val(value);--}}
{{--                    jQuery('#myModal').modal('show');--}}
{{--                } else {--}}
{{--                    jQuery('#myModal').modal('hide');--}}
{{--                }--}}
{{--            });--}}
{{--        });--}}
{{--    </script>--}}
@endpush

