@extends('admin.master')
@section('title')
    Assigned Course List
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success">{{session('message')}}</h4>
                            <h3 class="text-center"><strong>View Assigned Course List</strong></h3>
                        </div>
                    </div>

                    <hr>
                    <form action="" id="filterForm">
                        <div class="row mb-3">
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Status</label>
                                <select name="course_status_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="1" @isset($_GET['course_status_id']){{$_GET['course_status_id'] == '1' ? 'selected':''}}@endisset>Active</option>
                                    <option value="0" @isset($_GET['course_status_id']){{$_GET['course_status_id'] == '0' ? 'selected':''}}@endisset>Inactive</option>
                                </select>

                            </div>
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Course Type</label>
                                <select name="course_type" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="offline"
                                    @isset($_GET['course_type']){{$_GET['course_type'] == 'offline' ? 'selected':''}}@endisset>
                                        Offline</option>
                                    <option value="online" @isset($_GET['course_type']){{$_GET['course_type'] == 'online' ? 'selected':''}}@endisset
                                    >Online</option>
                                </select>
                            </div>

                        </div>

                    </form>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course Name<br><span class="second-line">Course Code</span></th>
                            <th>Duration<br><span class="second-line">Lectures</span></th>
                            <th><span class="second-line">Type</span></th>
                            <th><span class="second-line">Assign Batches</span></th>
                            <th><span class="second-line">Total Students</span></th>
                        </tr>
                        @php $i=1; @endphp
                        @foreach($items as $item)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$item->course->course_name ?? ''}}<br><span>{{$item->course->course_code ?? ''}}</span></td>
                                <td>{{$item->course->course_duration}}<br><span>{{$item->course->total_lectures}}</span></td>
                                <td><span>{{ $item->course->course_type}} <br></span><a href="{{$item->course->course_type == 'online' ? $item->course->course_link:''}}">{{$item->course->course_type == 'online' ? $item->course->course_link:''}}</a></td>
                                <td>{{count(getAssignedBatchesByCourseId($item->course_id))}}</td>
                                <td class="text-center">
                                    <span>{{count(getStudentsByCourseId($item->course_id))}}</span>
                                    </td>

                            </tr>
                        @endforeach
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
