@extends('frontend.master')
@section('title')
Notice Board
@endsection
@section('content')

@php
    $user = findUser();
    $enrolled_course_count = getEnrolledCourses()->get();
@endphp
<!-- =======================
Page Banner START -->

@include('frontend.student.include.header')
<!-- =======================
Page Banner END -->

<!-- =======================
Page content START -->
<section class="pt-0">
	<div class="container">
		<div class="row">

			@include('frontend.student.include.sidebar')

			<!-- Main content START -->
			<div class="col-xl-9">
				<div class="card bg-transparent border rounded-3">
					<!-- Card header START -->
					<div class="card-header bg-transparent border-bottom">
						<h3 class="mb-0">My Notice</h3>
					</div>
					<!-- Card header END -->

					<!-- Card body START -->
					<div class="card-body">


						<!-- Course list table START -->
						<div class="table-responsive border-0">
							<table class="table table-dark-gray align-middle p-4 mb-0 table-hover">
								<!-- Table head -->
								<thead>
									<tr>
                                        <th scope="col" class="border-0 rounded-start">Course</th>
										<th scope="col" class="border-0">Title</th>

										<th scope="col" class="border-0">Description</th>
										<th scope="col" class="border-0">Date</th>

									</tr>
								</thead>

								<!-- Table body START -->
                                @php
                                    $j = 0;
                                @endphp
								<tbody>
                                    @if(count($notices) >0)
                                    @foreach ($notices as $item)


                                        <tr>
                                            <!-- Table data -->
                                            <td>
                                                <div class="d-flex align-items-center">

                                                    <div class="mb-0 ms-2">

                                                        <h6><a href="#">{{ $item->course->course_name ?? '' }}</a></h6>

                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">

                                                    <div class="mb-0 ms-2">

                                                        <h6><a href="#">{{ $item->notice_title ?? '' }}</a></h6>

                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{ $item->notice_description }}</td>
                                            <td>{{ date('Y-m-d', strtotime($item->notice_date)) }}</td>

                                        </tr>

                                    @endforeach
                                    @else
                                        <tr>
                                            <td colspan="3" class="text-center">No Notice Found</td>
                                        </tr>
                                    @endif

									<!-- Table item -->

								</tbody>
								<!-- Table body END -->
							</table>
                            {{-- {{$notices->links('pagination::bootstrap-4')}} --}}
						</div>
						<!-- Course list table END -->


					</div>
					<!-- Card body START -->
				</div>
			<!-- Main content END -->
			</div><!-- Row END -->
		</div>
	</div>
</section>
<!-- =======================
Page content END -->
@endsection
