<!-- Left sidebar START -->
@php $route = Route::currentRouteName();; @endphp
<div class="col-xl-3">
    <!-- Responsive offcanvas body START -->
    <div class="offcanvas-xl offcanvas-end" tabindex="-1" id="offcanvasSidebar">
        <!-- Offcanvas header -->
        <div class="offcanvas-header bg-light">
            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">My profile</h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" data-bs-target="#offcanvasSidebar" aria-label="Close"></button>
        </div>
        <!-- Offcanvas body -->
        <div class="offcanvas-body p-3 p-xl-0">
            <div class="bg-dark border rounded-3 p-3 w-100">
                <!-- Dashboard menu -->
                <div class="list-group list-group-dark list-group-borderless collapse-list">
                    <a class="list-group-item {{$route == 'student.dashboard' ? 'active':''}}" href="{{ route('student.dashboard') }}"><i class="bi bi-ui-checks-grid fa-fw me-2"></i>Dashboard</a>
                    <a class="list-group-item {{$route == 'student.courses' ? 'active':''}}" href="{{ route('student.courses') }}"><i class="bi bi-basket fa-fw me-2"></i>My Courses</a>
                    <a class="list-group-item {{$route == 'student.profile.edit' ? 'active':''}}" href="{{ route('student.profile.edit') }}"><i class="bi bi-pencil-square fa-fw me-2"></i>Edit Profile</a>
                    <a class="list-group-item {{$route == 'student.notice' ? 'active':''}}" href="{{ route('student.notice') }}"><i class="bi bi-envelope fa-fw me-2"></i>Notices</a>
                    <a class="list-group-item text-danger bg-danger-soft-hover" href="#" onclick="event.preventDefault(); document.getElementById('logoutForm').submit()">
                        <i class="fas fa-sign-out-alt fa-fw me-2"></i>Sign Out
                    </a>
                    <form action="{{ route('logout') }}" id="logoutForm" method="POST">
                        @csrf
                    </form>
                    
                    {{-- <!-- Collapse menu -->
                    <a class="list-group-item" data-bs-toggle="collapse" href="#collapseauthentication" role="button" aria-expanded="false" aria-controls="collapseauthentication">
                        <i class="bi bi-lock fa-fw me-2"></i>Dropdown level
                    </a>
                    <!-- Submenu -->
                    <ul class="nav collapse flex-column" id="collapseauthentication" data-bs-parent="#navbar-sidebar">
                        <li class="nav-item"> <a class="nav-link" href="#">Dropdown item</a></li>
                        <li class="nav-item"> <a class="nav-link" href="#">Dropdown item</a></li>
                    </ul> --}}
                </div>
            </div>
        </div>
    </div>
    <!-- Responsive offcanvas body END -->
</div>
<!-- Left sidebar END -->
