@extends('frontend.master')
@section('title')
    All Webinar List
@endsection

@section('meta')
    <meta name="title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="description" content="Start your freelancing career with expert-led courses on in-demand skills and live projects. Get certified and have a chance to join our agency!">
    <meta name="keywords" content="freelancing career courses in Bangladesh">
    
    <meta name="og:title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="og:image" content="{{asset('frontend-assets')}}/images/meta_image.png">
@endsection

@section('content')
    <section class="bg-light">
        <div class="container">

            <!-- Title -->
            <div class="row position-relative pb-4">
                <div class="col-lg-8 position-relative">
                    <!-- Title -->
                    <h1>All Seminar Schedule</h1>
                    <p>Still undecided about which course to pursue? Curious about the career paths or the facilities we
                        offer? We’re here to help you with all your questions every week. We host course-specific seminars
                        where our expert mentors provide an overview of the courses and discuss potential career
                        opportunities. Attend these seminars to find the course that aligns perfectly with your goals.</p>
                </div>
            </div>
        </div>
    </section>
    <style>
        @media (max-width: 768px) {
            .text_main {
                padding: 15px;
                /* Adjust padding for smaller screens */
                flex-direction: column;
                /* Stack content vertically on mobile */
            }

            .join_btn {
                width: 100%;
                /* Full width button on mobile */
                margin-top: 10px;
                /* Add some margin for spacing */
            }
        }
    </style>
    <section>
        <div class="container my-4">
            <div class="row justify-content-center">
                @if (count($webinars) > 0)
                    @foreach ($webinars as $webinar)
                        <div class="col-lg-12 mb-4">
                            <div class="seminar_content border rounded-3 shadow-sm p-4 position-relative">
                                <ul class="list-unstyled mb-0">
                                    <li class="d-flex align-items-center">
                                        <div
                                            class="date bg-light text-center p-3 me-4 border rounded-3 border-primary text-black">
                                            <div class="fs-4 fw-bold text-black">
                                                {{ \Carbon\Carbon::parse($webinar->date)->format('d') }}</div>
                                            <div style="color: #EB343C">
                                                {{ \Carbon\Carbon::parse($webinar->date)->format('M, y') }}</div>
                                        </div>
                                        <div class="text_main d-flex flex-column flex-md-row justify-content-between w-100"
                                            style="border: 1px solid #ccc; border-radius: 15px; padding: 28px;">
                                            <div class="text mb-3 mb-md-0">
                                                <h4 class="mb-1">{{ $webinar->title }}</h4>
                                                <p class="mb-0">
                                                    {{ $webinar->type == 1 ? 'Online' : 'Offline' }}, Time:
                                                    {{ $webinar->time }}
                                                </p>
                                            </div>
                                            <div class="join_btn align-self-md-center">
                                                <button class="btn btn-primary w-100 w-md-auto" data-bs-toggle="modal"
                                                    data-bs-target="#webinarModal{{ $webinar->id }}">Click Here</button>
                                            </div>
                                            <div class="modal fade" id="webinarModal{{ $webinar->id }}" tabindex="-1"
                                                aria-labelledby="webinarModalLabel" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="registerModalLabel">Register for
                                                                Free
                                                                Webinar</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                                aria-label="Close"></button>
                                                        </div>
                                                        <form action="{{ route('webinar.booking.submit') }}" method="post">
                                                            <div class="modal-body">
                                                                @csrf
                                                                <input type="hidden" name="webinar_id"
                                                                    value="{{ $webinar->id ?? '' }}">
                                                                <div class="mb-3">
                                                                    <label for="name" class="form-label">Name <span
                                                                            class="text-danger">*</span></label>
                                                                    <input type="text"
                                                                        class="form-control @error('name') is-invalid @enderror"
                                                                        name="name" id="name" placeholder="Name"
                                                                        value="{{ Auth::check() && Auth::user()->role == 3 ? Auth::user()->name : old('name') }}"
                                                                        required>
                                                                    @error('name')
                                                                        <div class="invalid-feedback" role="alert">
                                                                            {{ $message }}</div>
                                                                    @enderror
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="phone" class="form-label">Phone</label>
                                                                    <input type="tel" name="phone"
                                                                        class="form-control @error('phone') is-invalid @enderror"
                                                                        id="phone" placeholder="Phone"
                                                                        value="{{ Auth::check() != null && Auth::user()->role == 3 ? Auth::user()->student->student_phone : old('phone') }}"
                                                                        required>
                                                                    @error('phone')
                                                                        <div class="invalid-feedback" role="alert">
                                                                            {{ $message }}</div>
                                                                    @enderror
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="email" class="form-label">Email</label>
                                                                    <input type="email" name="email"
                                                                        class="form-control @error('email') is-invalid @enderror"
                                                                        id="email" placeholder="Email"
                                                                        value="{{ Auth::check() != null && Auth::user()->role == 3 ? Auth::user()->email : old('email') }}"
                                                                        required>
                                                                    @error('email')
                                                                        <div class="invalid-feedback" role="alert">
                                                                            {{ $message }}</div>
                                                                    @enderror
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="address" class="form-label">Address</label>
                                                                    <textarea type="text" name="address" class="form-control @error('address') is-invalid @enderror" id="address"
                                                                        placeholder="Address" required>{{ old('address') }}</textarea>
                                                                    @error('address')
                                                                        <div class="invalid-feedback" role="alert">
                                                                            {{ $message }}</div>
                                                                    @enderror
                                                                </div>

                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit"
                                                                    class="btn btn-primary">Submit</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                                <div class="design-border"></div>
                            </div>
                        </div>
                    @endforeach
                @else
                <h2 class="text-center" style="color: #EB343C">No Seminar Available</h2>
                @endif

            </div>
        </div>

    </section>
@endsection
