
<!-- Navbar Start -->
@php $route = Route::currentRouteName(); @endphp

@php
    if ($route != 'course.details' && $route !='checkout') {
        session()->forget('coupon');
    }
    if($route != 'student.sign-up' && $route != 'student.sign-in' && $route != 'student.email.verification' && $route != 'student.verification-code.resend' && $route !='checkout' ){
        Session::forget('currentCourseRoute');
        Session::forget('currentCourseId');
    }
@endphp

@if ($route == 'home')
<style>
    header {
    position: relative;
    z-index: 1020;
    background: #FAF0F3;
}
</style>
@else
<style>
    header {
    position: relative;
    z-index: 1020;
    background: white;
}
</style>
@endif
<style>
    .special-hover {
    border-radius: 50%;
}

.special-hover:hover {
    color: white !important;
    background: #c11d1dc9;
}
.special-nav-hover:hover {
    color: white !important;
    background: #EB343C;
}

.special-hover i:hover{
    transform: scale(1.2);
    transition: transform 0.2s ease-in-out;
}
</style>
    <!-- Top header START -->
<div class="w-100" style="background-color: {{ $route == 'home' ? '#FAF0F3' : 'white' }};">
    <div class="navbar-top navbar-dark d-none d-xl-block py-2 mx-2 mx-md-4 rounded-bottom-4" style="background-color: #EB343C; color: white;" >
        <div class="container">
            <div class="d-lg-flex justify-content-lg-between align-items-center">
                <!-- Navbar top Left-->
                <!-- Top info -->
                <ul class="nav align-items-center justify-content-center">
                    <li class="nav-item me-3" data-bs-toggle="tooltip" data-bs-animation="false" data-bs-placement="bottom" data-bs-original-title="{{ getSettings('close_status') ?? '' }}">
                        <span><i class="far fa-clock me-2"></i>Visit time: {{ getSettings('visiting_time') ?? '' }}</span>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link special-nav-hover" href="tel:{{ getSettings('Phone') ?? '' }}"><i class="fas fa-headset me-2"></i>Call us now: {{ getSettings('Phone') ?? '' }}</a>
                    </li>
                </ul>

                <!-- Navbar top Right-->
                <div class="nav d-flex align-items-center justify-content-center">
                    <!-- Top social -->
                    <ul class="list-unstyled d-flex mb-0">
                        <li> <a class="px-2 nav-link special-hover" href="{{ getSettings('facebook_url') ?? '#' }}"><i class="fab fa-facebook"></i></a> </li>
                        <li> <a class="px-2 nav-link special-hover" href="{{ getSettings('instagram_url') ?? '#' }}"><i class="fab fa-instagram"></i></a> </li>
                        <li> <a class="px-2 nav-link special-hover" href="{{ getSettings('twitter_url') ?? '#' }}"><i class="fab fa-twitter"></i></a> </li>
                        <li> <a class="px-2 nav-link special-hover" href="{{ getSettings('linkedIn_url') ?? '#' }}"><i class="fab fa-linkedin-in"></i></a> </li>
                        <li> <a class="px-2 nav-link special-hover" href="{{ getSettings('youtube_url') ?? '#' }}"><i class="fab fa-youtube"></i></a> </li>
                        {{-- <li>
                            <div class="bg-light dark-mode-switch theme-icon-active d-flex align-items-center p-1 rounded mt-2">
                                <button type="button" class="btn btn-sm mb-0" data-bs-theme-value="light">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-sun fa-fw mode-switch" viewBox="0 0 16 16">
                                        <path d="M8 11a3 3 0 1 1 0-6 3 3 0 0 1 0 6zm0 1a4 4 0 1 0 0-8 4 4 0 0 0 0 8zM8 0a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 0zm0 13a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 13zm8-5a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2a.5.5 0 0 1 .5.5zM3 8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2A.5.5 0 0 1 3 8zm10.657-5.657a.5.5 0 0 1 0 .707l-1.414 1.415a.5.5 0 1 1-.707-.708l1.414-1.414a.5.5 0 0 1 .707 0zm-9.193 9.193a.5.5 0 0 1 0 .707L3.05 13.657a.5.5 0 0 1-.707-.707l1.414-1.414a.5.5 0 0 1 .707 0zm9.193 2.121a.5.5 0 0 1-.707 0l-1.414-1.414a.5.5 0 0 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .707zM4.464 4.465a.5.5 0 0 1-.707 0L2.343 3.05a.5.5 0 1 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .708z"></path>
                                        <use href="#"></use>
                                    </svg> Light
                                </button>
                                <button type="button" class="btn btn-sm mb-0" data-bs-theme-value="dark">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-moon-stars fa-fw mode-switch" viewBox="0 0 16 16">
                                        <path d="M6 .278a.768.768 0 0 1 .08.858 7.208 7.208 0 0 0-.878 3.46c0 4.021 3.278 7.277 7.318 7.277.527 0 1.04-.055 1.533-.16a.787.787 0 0 1 .81.316.733.733 0 0 1-.031.893A8.349 8.349 0 0 1 8.344 16C3.734 16 0 12.286 0 7.71 0 4.266 2.114 1.312 5.124.06A.752.752 0 0 1 6 .278zM4.858 1.311A7.269 7.269 0 0 0 1.025 7.71c0 4.02 3.279 7.276 7.319 7.276a7.316 7.316 0 0 0 5.205-2.162c-.337.042-.68.063-1.029.063-4.61 0-8.343-3.714-8.343-8.29 0-1.167.242-2.278.681-3.286z"></path>
                                        <path d="M10.794 3.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387a1.734 1.734 0 0 0-1.097 1.097l-.387 1.162a.217.217 0 0 1-.412 0l-.387-1.162A1.734 1.734 0 0 0 9.31 6.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387a1.734 1.734 0 0 0 1.097-1.097l.387-1.162zM13.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.156 1.156 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.156 1.156 0 0 0-.732-.732l-.774-.258a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732L13.863.1z"></path>
                                        <use href="#"></use>
                                    </svg> Dark
                                </button>
                                <button type="button" class="btn btn-sm mb-0 active" data-bs-theme-value="auto">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-circle-half fa-fw mode-switch" viewBox="0 0 16 16">
                                        <path d="M8 15A7 7 0 1 0 8 1v14zm0 1A8 8 0 1 1 8 0a8 8 0 0 1 0 16z"></path>
                                        <use href="#"></use>
                                    </svg> Auto
                                </button>
                            </div>
                        </li> --}}
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Top header END -->

<!-- Header START -->
<header class="navbar-light header-static navbar-sticky">
    <!-- Logo Nav START -->
    <nav class="navbar navbar-expand-xl">
        <div class="container">
            <!-- Logo START -->
            @php
                $site_logo = getSettings('site_logo');
                $site_logo_dark = getSettings('site_logo_dark');
            @endphp
            <a class="navbar-brand me-0" href="{{route('home')}}">
               <img class="light-mode-item navbar-brand-item" src="{{asset($site_logo)}}" alt="logo">
               <img class="dark-mode-item navbar-brand-item" src="{{asset($site_logo_dark)}}" alt="logo">
                {{-- <span style="position: relative; top: 5px; font-size:18px">Universal IT Institute</span> --}}
            </a>
            <!-- Logo END -->

            <!-- Main navbar START -->
            <div class="navbar-collapse collapse" id="navbarCollapse">

                <!-- Nav Search END -->
                <ul class="navbar-nav navbar-nav-scroll mx-auto">
                    <!-- Nav item 1 Demos -->
                    <li class="nav-item dropdown">
                        <a class="nav-link " href="{{route('home')}}" >Home</a>
                    </li>
                    <li class="nav-item"><a class="nav-link " href="{{route('about.us')}}">About Us</a></li>
                    <li class="nav-item dropdown dropdown-fullwidth">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Course Categories</a>
                        <div class="dropdown-menu dropdown-menu-end" data-bs-popper="none">
                            <div class="row p-4">
                                <!-- Dropdown column item -->
                                @foreach ($course_categories as $item)
                                @php
                                    $categorycourse = findCategoryCourse($item->id);

                                @endphp
                                <div class="col-xl-3 col-xxl-3 mb-3">
                                    <h6 class="mb-0"><img src="{{asset($item->image)}}" class="course-cat-img rounded-circle me-1" alt=""> {{ $item->name }}</h6>
                                    <hr>
                                    <ul class="list-unstyled">
                                        @if(count($categorycourse) > 0)
                                        @foreach ($categorycourse as $course)
                                        <li> <a href="{{ route('course.details', $course->slug) }}" class="dropdown-item">{{ Str::limit($course->course_name, 25, '...') }}</a> </li>
                                        @endforeach
                                        <li> <a href="{{ route('category.course', $item->slug) }}" class="dropdown-item">View All</a> </li>
                                        @endif


                                    </ul>
                                </div>
                                @endforeach




                            </div>
                        </div>
                    </li>

                    <!-- Nav item 3 Account -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="accounntMenu" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Courses</a>
                        <ul class="dropdown-menu" aria-labelledby="accounntMenu">
                            @foreach ($courses as $item)
                            <li style=""> <a  class="d-flex overflow-auto dropdown-item" href="{{ route('course.details', $item->slug) }}"><img src="{{asset($item->image)}}" class="rounded-circle me-1 course-img"><span class="course-name overflow-auto">{{ $item->course_name }}</span></a> </li>
                            @endforeach
                            <li style=""> <a href="{{ route('courses') }}" class="dropdown-item text-center view-all-btn">View All</a> </li>


                        </ul>
                    </li>
                    <!-- Nav item 4 Component-->
                    <li class="nav-item"><a class="nav-link " href="{{route('gallery')}}">Gallery</a></li>
                    <li class="nav-item"><a class="nav-link " href="{{route('contact')}}">Contact Us</a></li>

                </ul>
            </div>
            <!-- Main navbar END -->

            <!-- Nav Search START -->
            <div class="nav nav-item dropdown nav-search px-1 px-lg-3 d-none" >
                <a class="nav-link" role="button" href="#" id="navSearch" data-bs-toggle="dropdown" aria-expanded="true" data-bs-auto-close="outside" data-bs-display="static">
                    <i class="bi bi-search fs-4"> </i>
                </a>
                <div class="dropdown-menu dropdown-menu-end shadow rounded p-2" aria-labelledby="navSearch" data-bs-popper="none">
                    <form class="input-group">
                        <input class="form-control border-primary" type="search" placeholder="Search..." aria-label="Search">
                        <button class="btn btn-primary m-0" type="submit">Search</button>
                    </form>

                </div>
            </div>
            <!-- Nav Search END -->
            
            
            <!-- Profile START -->
            @auth
            @if(Auth::user()->role == 3)
            @php
                $user = findUser();
            @endphp
            <div class="dropdown ms-1 ms-lg-0 account-btn">
                <a class="avatar avatar-sm p-0" href="#" id="profileDropdown" role="button" data-bs-auto-close="outside" data-bs-display="static" data-bs-toggle="dropdown" aria-expanded="false">
                    @if($user->student_image != null)
                        <img class="avatar-img rounded-circle border border-white border-3 shadow"
                             src="{{ asset($user->student_image) }}" alt="">
                    @else
                        <img class="avatar-img rounded-circle border border-white border-3 shadow"
                             src="{{ asset('admin-assets') }}/images/default.jpg" alt="" width="200px">
                    @endif

                </a>
                <a href="{{ route('student.dashboard') }}" class="ms-2 d-none d-lg-inline text-black">{{ Auth::user()->name }}</a>

                <ul class="dropdown-menu dropdown-animation dropdown-menu-end shadow pt-3" aria-labelledby="profileDropdown">
                    <!-- Profile info -->
                    <li class="px-3 mb-3">
                        <div class="d-flex align-items-center">
                            <!-- Avatar -->
                            <div class="avatar me-3">
                                @if($user->student_image != null)
                                    <img class="avatar-img rounded-circle border border-white border-3 shadow"
                                         src="{{ asset($user->student_image) }}" alt="">
                                @else
                                    <img class="avatar-img rounded-circle border border-white border-3 shadow"
                                         src="{{ asset('admin-assets') }}/images/default.jpg" alt="" width="200px">
                                @endif
                            </div>
                            <div>
                                <a class="h6" href="#">{{ Auth::user()->name }}</a>
                                <p class="small m-0">{{ Auth::user()->email }}</p>
                            </div>
                        </div>
                    </li>
                    <li> <hr class="dropdown-divider"></li>
                    <!-- Links -->
                    <li><a class="dropdown-item" href="{{ route('student.dashboard') }}"><i class="bi bi-ui-checks-grid fa-fw me-2"></i>Dashboard</a></li>
                    <li><a class="dropdown-item" href="{{ route('student.courses') }}"><i class="bi bi-basket fa-fw me-2"></i>My Courses</a></li>
                    <li><a class="dropdown-item" href="{{ route('student.profile.edit') }}"><i class="bi bi-person fa-fw me-2"></i>Edit Profile</a></li>
                    <li><a class="dropdown-item bg-danger-soft-hover" href="#" onclick="event.preventDefault(); document.getElementById('logoutForm').submit()"><i class="bi bi-power fa-fw me-2"></i>Sign Out</a></li>
                    <form action="{{ route('logout') }}" id="logoutForm" method="POST">
                        @csrf
                    </form>
                    <!-- Dark mode options START -->

                    <!-- Dark mode options END-->
                </ul>
            </div>

            @else
            <div class="nav nav-item dropdown nav-search px-1 px-lg-3 signin-btn" style="color: black">
                <a href="{{ route('student.sign-in') }}" class="nav-link" >
                    <i class="bi bi-person fs-4"> </i><span style="position:relative; bottom: 3px">Sign In</span>
                </a>

            </div>
            @endif

            @endauth
            @guest
            <div class="nav nav-item dropdown nav-search px-1 px-lg-3 signin-btn" style="color: black">
                <a href="{{ route('student.sign-in') }}" class="nav-link pe-0" >
                    <i class="bi bi-person fs-4"> </i><span style="position:relative; bottom: 3px">Sign In</span>
                </a>

            </div>
            @endguest
            <!-- Profile START -->
            
            <!-- Responsive navbar toggler -->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation" style="margin-right: -10px">
				<span class="navbar-toggler-animation">
					<span></span>
					<span></span>
					<span></span>
				</span>
            </button>
        </div>
    </nav>
    <!-- Logo Nav END -->
</header>
<!-- Header END -->

@php
if($route != 'student.email.verification' && $route !='student.forget-password.verify' && $route != 'student.password.change'){
//    dd($route);
    Session::forget('request');
    Session::forget('verification_code');
}
@endphp
