@extends('frontend.master')
@section('title')
Verify Email
@endsection
@section('content')
<section class="p-0 d-flex align-items-center position-relative overflow-hidden">

    <div class="container-fluid">
        <div class="row">
            <!-- left -->
            <div class=" col-12 col-lg-6 d-md-flex align-items-center justify-content-center bg-primary bg-opacity-10 d-none d-md-block">
                <div class="p-3 p-lg-5">
                    <!-- Title -->
                    <div class="text-center">
                        <h2 class="fw-bold">Welcome To Our Largest Community</h2>
                        <p class="mb-0 h6 fw-light">Let's learn something new today!</p>
                    </div>
                    <!-- SVG Image -->
                    <img src="fonts/02.svg" class="mt-5" alt="">
                    <!-- Info -->
                    <div class="d-sm-flex mt-5 align-items-center justify-content-center">
                        <!-- Avatar group -->
                        <ul class="avatar-group mb-2 mb-sm-0">
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/01.jpg" alt="avatar">
                            </li>
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/02_1.jpg" alt="avatar">
                            </li>
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/03.jpg" alt="avatar">
                            </li>
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/04.jpg" alt="avatar">
                            </li>
                        </ul>
                        <!-- Content -->
                        <p class="mb-0 h6 fw-light ms-0 ms-sm-3">4k+ Students joined us, now it's your turn.</p>
                    </div>
                </div>
            </div>

            <!-- Right -->
            <div class="col-12 col-lg-6 m-auto">
                <h4 class="text-center text-success">{{session('message')}}</h4>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <div class="row my-5">
                    <div class="col-sm-10 col-xl-8 m-auto">
                        <!-- Title -->
                        <img src="fonts/03.svg" class="h-40px mb-2" alt="">
                        <h2>Email Verification!</h2>
                        <p class="lead mb-4">Please Verify Your Provided Email By Entering The Code Provided In Your Email.</p>

                        <!-- Form START -->
                        <form action="{{ route('student.forget-password.verify.submit') }}" method="POST">
                            @csrf
                            <!-- Email -->
                            <div class="mb-4">
                                <label for="name" class="form-label">Verification Code *</label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text bg-light rounded-start border-0 text-secondary px-3"><i class="bi bi-code"></i></span>
                                    <input type="text" name="code" class="form-control border-0 bg-light rounded-end ps-1
                                    @error('code') is-invalid @enderror" placeholder="Verification Code" id="code" value="{{ old('code') }}" required>

                                </div>
                                @error('code')
                                        <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                @enderror
                            </div>
                            <!-- Button -->
                            <div class="align-items-center mt-0">
                                <div class="d-grid">
                                    <button class="btn btn-primary mb-0" type="submit">Verify</button>
                                </div>
                            </div>
                        </form>
                        <!-- Form END -->



                        <!-- Sign up link -->
                        <div class="mt-4 d-flex justify-content-end">
{{--                            <span>Already have an account?<a href="{{ route('student.sign-in') }}"> Sign In Here</a></span>--}}
                            <span id="resendCodeBtn" class="btn text-danger text-decoration-underline"><a href="{{route('student.verification-code.resend')}}">Resend Code</a></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

