@php use App\Models\User; @endphp
@extends('frontend.master')
@section('title')
Update Password
@endsection
@section('content')
<section class="p-0 d-flex align-items-center position-relative overflow-hidden">

    <div class="container-fluid">
        <div class="row">
            <!-- left -->
            <div class=" col-12 col-lg-6 d-md-flex align-items-center justify-content-center bg-primary bg-opacity-10 d-none d-md-block">
                <div class="p-3 p-lg-5">
                    <!-- Title -->
                    <div class="text-center">
                        <h2 class="fw-bold">Welcome To Our Largest Community</h2>
                        <p class="mb-0 h6 fw-light">Let's learn something new today!</p>
                    </div>
                    <!-- SVG Image -->
                    <img src="fonts/02.svg" class="mt-5" alt="">
                    <!-- Info -->
                    <div class="d-sm-flex mt-5 align-items-center justify-content-center">
                        <!-- Avatar group -->
                        <ul class="avatar-group mb-2 mb-sm-0">
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/01.jpg" alt="avatar">
                            </li>
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/02_1.jpg" alt="avatar">
                            </li>
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/03.jpg" alt="avatar">
                            </li>
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/04.jpg" alt="avatar">
                            </li>
                        </ul>
                        <!-- Content -->
                        <p class="mb-0 h6 fw-light ms-0 ms-sm-3">4k+ Students joined us, now it's your turn.</p>
                    </div>
                </div>
            </div>

            <!-- Right -->
            <div class="col-12 col-lg-6 m-auto">
                <h4 class="text-center text-success">{{session('message')}}</h4>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <div class="row my-5">
                    <div class="col-sm-10 col-xl-8 m-auto">
                        <!-- Title -->
                        <img src="fonts/03.svg" class="h-40px mb-2" alt="">
                        <h2>Email Verification!</h2>
                        <p class="lead mb-4">Please Verify Your Provided Email By Entering The Code Provided In Your Email.</p>

                        <!-- Form START -->
                        <form action="{{ route('student.password.update') }}" id='passwordChangeForm'  method="POST">
                            @csrf
                            <div class="col-xl-12">
                                <div class="card border bg-transparent rounded-3">
                                    <!-- Card header -->
                                    <div class="card-header bg-transparent border-bottom">
                                        <h5 class="card-header-title mb-0">Update password</h5>
                                    </div>
                                    <!-- Card body START -->
                                    <div class="card-body">
                                        <!-- New password -->
                                        <div class="mb-3">
                                            <label class="form-label"> Enter new password</label>
                                            <div class="input-group">
                                                <input name="password" class="form-control" type="password" placeholder="Enter new password">
                                                {{-- <span class="input-group-text p-0 bg-transparent">
                                                    <i class="far fa-eye cursor-pointer p-2 w-40px"></i>
                                                </span> --}}
                                            </div>
                                            <div class="rounded mt-1" id="psw-strength"></div>
                                        </div>
                                        <!-- Confirm password -->
                                        <div>
                                            <label class="form-label">Confirm new password</label>
                                            <input name="password_confirmation" class="form-control" type="password" placeholder="Enter new password">
                                        </div>
                                        <!-- Button -->
                                        <div class="d-flex justify-content-end mt-4">
                                            <button type="submit" onclick="return checkPassword()"   class="btn btn-primary mb-0">Change password</button>
                                        </div>
                                    </div>
                                    <!-- Card body END -->
                                </div>
                            </div>
                        </form>
                        <!-- Form END -->



                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection


