@extends('admin.master')
@section('title')
    @isset($item)Edit @else Add @endisset Webinar
@endsection
@section('content')
    <div class="card">
        <div class="card-header text-center">
            <h2><strong> @isset($item)Edit @else Add @endisset Webinar</strong></h2>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
        <div class="card-body card-block">
            @if(Auth::user()->role == 4)
              @php  $route = 'teacher'; @endphp
            @else
               @php $route = 'admin'; @endphp
            @endif
            <form action="@isset($item){{route($route.'.webinar.update')}}@else{{route($route.'.webinar.submit')}}@endisset" method="post">
                @csrf
                <input type="hidden" name="id" value="@isset($item){{$item->id}}@endisset">
                <input type="hidden" name="" id="topic_counter" value="1">
                <input type="hidden" name="webinar_counter" id="webinar_counter" value="1">
{{--                <input type="hidden" name="webinar_counter" id="total_webinar" value="1">--}}
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="company" class=" form-control-label">Course
                            <span class="text-danger">*</span></label>
                        <select name="course_id" id="course_id" class="form-control @error('branch_id') is-invalid @enderror" required>
                            <option value="" >Select Course</option>
                            @foreach($courses as $course)
                                <option value="{{$course->id}}" @isset($item){{$item->first()->course_id == $course->id ? 'selected': ''}}@endisset>{{$course->course_name}} ({{$course->course_code}})</option>
                            @endforeach
                        </select>
                        @error('course_id')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>

                </div>
                    <div class="row" id="webinar-1">
                        <div class="col-md-12"><p class="font-weight-bold">Webinar Information</p></div>
                        <div class="form-group col-md-8"><label for="company" class=" form-control-label">Name
                                <span class="text-danger">*</span></label>
                            <input type="text" name="title_1" id="company" value="" placeholder="Enter Title" class="form-control" maxlength="200"
                                   required>
                            @error('title')
                            <div class="invalid-feedback" role="alert">{{$message}}</div>
                            @enderror
                        </div>
                        <div class="form-group col-md-4"><label for="company" class=" form-control-label">Type
                                <span class="text-danger">*</span></label>
                            <select name="type_1" id="type_1" onchange="alterField(1)" class="form-control">
                                <option value="1" selected>Online</option>
                                <option value="2">Offline</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4"><label for="company" class=" form-control-label">Date
                                <span class="text-danger">*</span></label>
                            <input type="date" name="date_1" id="company" class="form-control"
                                   required>
                            @error('date')
                            <div class="invalid-feedback" role="alert">{{$message}}</div>
                            @enderror
                        </div>
                        <div class="form-group col-md-4"><label for="company" class=" form-control-label">Time
                                <span class="text-danger">*</span></label>
                            <input type="time" id="company" name="time_1"
                                   class="form-control" value="" required>
                            @error('time')
                            <div class="invalid-feedback" role="alert">{{$message}}</div>
                            @enderror
                        </div>
                        <div class="form-group col-md-4"><label for="company" class=" form-control-label">Price
                                <span class="text-danger">*</span></label>
                            <input type="number" id="company" placeholder="Enter Price" name="price_1"
                                   class="form-control" value="" required>
                            @error('price')
                            <div class="invalid-feedback" role="alert">{{$message}}</div>
                            @enderror
                        </div>
                        <div class="form-group col-md-12" id="linkOrAddressContainer_1">
                            <label for="company" class=" form-control-label" >Link
                                <span class="text-danger">*</span></label>
                            <div >
                                <input type="text" id="link_1"  placeholder="Enter URL" name="link_1"
                                       class="form-control" value="" >
                            </div>

                        </div>
                        <div class="form-group col-md-12"><label for="company" class=" form-control-label">Guest
                            </label>
                            <input type="text" id="company" placeholder="Enter Guests Name (Use Comma to Separate)" name="guest_1"
                                   class="form-control" value="" >
                        </div>
                        <div class="form-group col-md-12">
                            <label for="" class="form-control-label">Topics <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="text" id="topic-1" name="topic_1[]" placeholder="Enter Topic"
                                       class="form-control" value="" required>
                            </div>
                            @error('topic')
                            <div class="invalid-feedback" role="alert">{{$message}}</div>
                            @enderror
                        </div>
                        <div class="col-md-12" >
                            <div class="row" id="topic_container-1">

                            </div>
                        </div>

                        <div class="col-md-12 mb-4 d-flex justify-content-end"><a class="btn btn-primary"
                                                                             id="addTopicBtn" onclick="addTopic(1)"><i class="fa fa-plus"></i> Add Topic</a>
                        </div>

                        <div class="form-group col-md-4">
                                <label for="" class="form-control-label">Webinar Status</label>
                                <div class="form-check">
                                    <input class="form-check-input" value="1" type="radio" name="status_1" id="flexRadioDefault1" checked>
                                    <label class="form-check-label" for="flexRadioDefault1">
                                        Active
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" value="0" type="radio" name="status_1" id="flexRadioDefault2" @isset($item){{$item->notice_status_id == 0 ? 'checked':''}}@endisset>
                                    <label class="form-check-label" for="flexRadioDefault2">
                                        Inactive
                                    </label>
                                </div>
                            </div>


                    </div>
                <div id="class_container">

                </div>
                <div class="row mb-3">
                    <div class="col-md-12 d-flex justify-content-end"><a class="btn btn-primary"
                                                                       id="addWebinarBtn"><i class="fa fa-plus"></i> Add Webinar</a></div>
                </div>


                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">@isset($item)Update @else Add @endisset Webinar Information</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('script')
    <script>
        jQuery('#addWebinarBtn').click(function () {
            event.preventDefault();
            var counter = parseInt(jQuery('#webinar_counter').val());
            var topic_counter = parseInt(jQuery('#topic_counter').val());

                counter++;
                topic_counter++;
                jQuery('#webinar_counter').val(counter);
                // jQuery('#total_webinar').val(counter);
                jQuery('#topic_counter').val(counter);
                var html = `
                <div class="row" id="webinar-${counter}">
                        <div class="col-md-12"><p class="font-weight-bold">Webinar Information <span class="btn btn-danger" onclick="removeWebinar(${counter})" "><i class="fa fa-minus"></i></span></p> </div>
                        <div class="form-group col-md-8"><label for="company" class=" form-control-label">Name
                                <span class="text-danger">*</span></label>
                            <input type="text" name="title_${counter}" id="company" placeholder="Enter Title" value="" class="form-control" maxlength="200"
                                   required>

                </div>
                <div class="form-group col-md-4"><label for="company" class=" form-control-label">Type
                        <span class="text-danger">*</span></label>
                    <select name="type_${counter}" id="type_${counter}" onchange="alterField(${counter})" class="form-control">
                        <option value="1" selected>Online</option>
                        <option value="2">Offline</option>
                    </select>
                </div>
                <div class="form-group col-md-4"><label for="company" class=" form-control-label">Date
                        <span class="text-danger">*</span></label>
                    <input type="date" name="date_${counter}" id="company" class="form-control"
                           required>
                </div>
                <div class="form-group col-md-4"><label for="company" class=" form-control-label">Time
                        <span class="text-danger">*</span></label>
                    <input type="time" id="company" name="time_${counter}"
                           class="form-control" value="" required>

                </div>
                <div class="form-group col-md-4"><label for="company" class=" form-control-label">Price
                        <span class="text-danger">*</span></label>
                    <input type="number" id="company" placeholder="Enter Price" name="price_${counter}"
                           class="form-control" value="" required>

                </div>
                <div class="form-group col-md-12" id="linkOrAddressContainer_${counter}">
                    <label for="company" class=" form-control-label" >Link
                        <span class="text-danger">*</span></label>
                    <div >
                        <input type="text" id="link_${counter}"  placeholder="Enter URL" name="link_${counter}"
                               class="form-control" value="" >
                    </div>

                </div>
                <div class="form-group col-md-12"><label for="company" class=" form-control-label">Guest
                    </label>
                    <input type="text" id="company" placeholder="Enter Guests Name (Use Comma to Separate)" name="guest_${counter}"
                           class="form-control" value="" >
                </div>
                <div class="form-group col-md-12">
                    <label for="" class="form-control-label">Topics <span class="text-danger">*</span></label>
                    <div class="input-group">
                        <input type="text" id="topic-${counter}" name="topic_${counter}[]" placeholder="Enter Topic"
                               class="form-control" value="" required>
                    </div>

                </div>
                <div class="col-md-12" >
                    <div class="row" id="topic_container-${counter}">

                    </div>
                </div>

                <div class="col-md-12 mb-4 d-flex justify-content-end"><a class="btn btn-primary"
                                                                     id="addTopicBtn" onclick="addTopic(${counter})"><i class="fa fa-plus"></i> Add Topic</a>
                </div>

                <div class="form-group col-md-4">
                        <label for="" class="form-control-label">Webinar Status</label>
                        <div class="form-check">
                            <input class="form-check-input" value="1" type="radio" name="status_${counter}" id="flexRadioDefault${counter}1" checked>
                            <label class="form-check-label" for="flexRadioDefault1">
                                Active
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" value="0" type="radio" name="status_${counter}" id="flexRadioDefault${counter}2">
                                    <label class="form-check-label" for="flexRadioDefault2">
                                        Inactive
                                    </label>
                                </div>
                            </div>


                    </div>`;
                           // console.log(html);
                jQuery('#class_container').append(html);

        })
    </script>
    <script>
        function removeWebinar(count){
            var counter = parseInt(jQuery('#total_webinar').val());
            // jQuery('#total_webinar').val(counter-1);
            jQuery('#webinar-'+count).remove();
        }
    </script>
    <script>
        function addTopic(id) {
            var topic_counter = parseInt(jQuery('#topic_counter').val());
            jQuery('#topic_counter').val(topic_counter+1);
            topic_counter++;
            var html = `
            <div class="form-group col-md-12" id="topic-${topic_counter}">
                                    <div class="input-group" >
                        <input type="text"  name="topic_${id}[]" placeholder="Enter Topic"
                               class="form-control" value="" required> <a
                            class="btn btn-danger" onclick="removeTopic(${topic_counter})"><i class="fa fa-minus"></i></a>
                    </div>
                                </div>
            `
            jQuery('#topic_container-'+id).append(html);
        }
        function removeTopic(id) {
            jQuery('#topic-'+id).remove();
        }
        function alterField(id) {

            var type = jQuery('#type_'+id).val();
            console.log(type);
                if(type == 2){
                    var html = `
                        <label for="company" class=" form-control-label" >Address
                                                        <span class="text-danger">*</span></label>
                        <textarea name="address_${id}" class="form-control" rows="3" required></textarea>`
                    jQuery('#link_'+id).remove();

                }
                else{
                    html=`<label for="company" class=" form-control-label" >Link
                                <span class="text-danger">*</span></label>
                            <div >
                                <input type="text" id="link_1"  placeholder="Enter URL" name="link_1"
                                       class="form-control" value="" >
                            </div>`;
                }
            jQuery('#linkOrAddressContainer_'+id).html(html);

        }
    </script>
@endpush
