@extends('admin.master')
@section('title')
    Applicant List
@endsection
@section('content')
    @php
    $column='col-sm-2';
    @endphp
    <div class="row mt-5 ">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success">{{session('message')}}</h4>
                    <h3 class="text-center"><strong>View Applicants</strong>
{{--                        @if(Auth::user()->role == 2)--}}
                        <a href="{{route('student.add')}}" class="float-right btn btn-primary">Add Student</a>
{{--                        @endif--}}
                    </h3>

                </div>
                <div class="card-body">
                    <div class="">
                        <table id="filter_table" class="table table-striped">
                            <thead>
                                <tr>
                                <th>#</th>
                                <th>Image</th>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Email</th>
                                <th>Join Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            @php $i=1; @endphp
                            <tbody>
                                @foreach($items as $item)
                                <tr>
                                    <td>{{$i++}}</td>

                                    @if($student)
                                        <td>
                                            @if($item->student->student_image != null)
                                                <img src="{{asset($item->student_image)}}" class="rounded-circle" height="100px" width="100px" alt="">
                                            @endif
                                        </td>
                                        <td>{{$item->student_name}}</td>
                                        <td>{{$item->student->student_phone}}</td>


                                        <td></td>
                                        <td></td>
                                        <td>{{$item->student_roll}} <br><span>{{$item->student_registration}}</span></td>
                                        <td></td>
                                        <td>
                                            @if($course)
                                                {{$course->course_name}}
                                            @endif
                                        </td>
{{--                                        @if(Auth::user()->role == 1)--}}
{{--                                            <td>--}}
{{--                                                @if($branch)--}}
{{--                                                    {{$branch->branch_name}}--}}
{{--                                                @endif--}}
{{--                                            </td>--}}
{{--                                        @endif--}}
                                        <td></td>
                                        <td>{{$item->join_date}}</td>
                                    @endif
{{--                                    @if(Auth::user()->role ==2)--}}
                                        <td class="btn-group">
                                            <a href="{{route('student.edit', ['id'=>$item->id])}}" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                            <form action="{{route('student.remove')}}" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                                @csrf
                                                <input type="hidden" name="id" id="'student_id'.{{$i}}" value="{{$item->id}}">
                                                <button type="submit" class="btn btn-danger" title="Remove" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                            </form>
                                        </td>
{{--                                    @endif--}}

                                    <td class="">
{{--                                        @if(Auth::user()->role ==2 )--}}
                                            <a href="{{route('student.registration.print', ['id'=>$item->id])}}" class="btn btn-info" style="border-radius: 4px;" title="Download Registration Card"><i class="fa fa-id-card" aria-hidden="true"></i></a>
{{--                                        @endif--}}
{{--                                        @if(Auth::user()->role ==2 )--}}
                                                <a href="{{route('student.id.print', ['id'=>$item->id])}}" class="btn btn-primary me-2" style="border-radius: 4px;" title="Download ID Card"><i class="fa fa-id-badge" aria-hidden="true"></i></a>
{{--                                            @endif--}}
{{--                                        @if(Auth::user()->role ==2  && getSettings('admit_card_printing_status') == 1)--}}
                                                <a href="{{route('student.admit.print', ['id'=>$item->id])}}" class="btn btn-warning" style="border-radius: 4px;" title="Download Admit Card"><i class="fa fa-ticket" aria-hidden="true"></i></a>
{{--                                            @endif--}}
{{--                                        @if(Auth::user()->role ==1 )--}}

                                            <a href="" onclick="test({{$item->id}})" class="btn btn-success me-2" style="border-radius: 4px;" title="Download Certificate"><i class="fa fa-file"></i></a>
{{--                                        @endif--}}
                                    </td>


                                </tr>

                            @endforeach
                            </tbody>
                        </table>
                        {{$items->links('pagination::bootstrap-5')}}
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <script>
        function filter(){
            jQuery('#filterForm').submit()
        }
        function test(id){
            url = '{{route('admin.student.certificate.print',":id")}}'
            url = url.replace(':id', id);
            var test_window = window.open(url);
            test_window.onload = function() {
                // Trigger the print functionality for the new window
                test_window.print();
            }
            // Open a new window or tab with the URL of the page you want to print
        }
    </script>
@endpush
