@extends('admin.master')
@section('title')
    Edit Profile
@endsection

@section('content')
    <div class="card">
        <div class="card-header text-center">
            <h4 class="text-center text-success">{{session('message')}}</h4>
            <h2><strong> Edit Profile</strong></h2>
        </div>
        <div class="card-body card-block">
            <form action="{{route('profile.update')}}" method="post" enctype="multipart/form-data">
                @csrf
                @isset($item)
                    <input type="hidden" name="id" value="@isset($item){{$item->id}}@endisset">
                @endisset
                <div class="row mb-3">
                    <div class="col-md-8">
                        <div class="row mb-3">
                            <div class="form-group col-md-12"><label for="company" class="form-control-label">Name
                                    <span class="text-danger">*</span></label>
                                <input type="text" id="company" name="name"
                                       class="form-control @error('name') is-invalid @enderror"
                                       value="@isset($item){{$item->name}}@else{{old('name')}}@endisset" required>
                                @error('name')
                                <div class="invalid-feedback" role="alert">{{$message}}</div>
                                @enderror
                            </div>
                        </div>
                        @if(Auth::user()->role == 4)
                            <div class="row mb-3">
                                <div class="form-group col-md-12"><label for="company" class=" form-control-label">Phone Number
                                        <span class="text-danger">*</span></label>
                                    <input type="text" id="company" name="phone"
                                           class="form-control @error('phone') is-invalid @enderror"
                                           value="@isset($item){{$item->phone}}@else{{old('phone')}}@endisset" required>
                                    @error('phone')
                                    <div class="invalid-feedback" role="alert">{{$message}}</div>
                                    @enderror
                                </div>

                            </div>
                        @endif
                        <div class="row mb-3">
                            <div class="form-group col-md-12"><label for="company" class=" form-control-label">Email Address
                                <span class="text-danger">*</span></label>
                                <input type="email" id="company" name="email"
                                       class="form-control @error('email') is-invalid @enderror"
                                       value="@isset($item){{$item->email}}@else{{old('email')}}@endisset">
                                @error('email')
                                    <div class="invalid-feedback" role="alert">{{$message}}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card-header text-center">Teacher Image</div>
                        <div class="card-body">
                            @isset($item)
                                @if($item->image)
                                    <img src="{{asset($item->image)}}"alt="" height="200px" width="200px" id="img" class="mb-3 mx-4">
                                @else
                                    <img src="{{asset('admin-assets')}}/images/default.jpg"alt="" height="200px" width="200px" id="img" class="mb-3 mx-4">
                                @endif
                            @else
                                <img src="{{asset('admin-assets')}}/images/default.jpg" alt="" height="200px" width="200px" id="img" class="mb-3 mx-4">
                            @endisset
                            <input type="file" class="form-control" name="image" accept="image/*" style="padding: 3px" onchange="readURL(this)">
                        </div>
                    </div>
                </div>
                @if(Auth::user()->role == 4)
                    <div class="row mb-3">
                        <div class="form-group col-md-12"><label for="" class="form-control-label">Address</label>
                            <textarea name="address" id="" cols="30" rows="5" class="form-control" placeholder="Enter Address">@isset($item){{$item->address}}@else{{old('area')}}@endisset</textarea>
                        </div>
                    </div>
                @endif

                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">Update Profile </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.0/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
{{--<script>--}}
{{--    jQuery( document ).ready(function() {--}}
{{--        // alert('okay');--}}
{{--        jQuery('#course_id').change(function(){--}}
{{--            var course_id = jQuery(this).val();--}}
{{--            var url = '{{ route("teacher.get-batch-by-course", ":course_id") }}';--}}
{{--            url = url.replace(':course_id',course_id);--}}

{{--            if(course_id!='0'){--}}
{{--                jQuery.ajax({--}}
{{--                    url: url,--}}
{{--                    dataType: 'json',--}}
{{--                    beforeSend: function() {--}}
{{--                        //jQuery('select[name=\'division_id\']').after('<span class="wait">&nbsp;<img src="images/loading.gif" alt="" /></span>');--}}
{{--                    },--}}
{{--                    complete: function() {--}}
{{--                        jQuery('.wait').remove();--}}
{{--                    },--}}
{{--                    success: function(json) {--}}
{{--                        console.log(json);--}}
{{--                        html = '<option value="">-Select Batch-</option>';--}}
{{--                        for (i = 0; i < json.length; i++) {--}}
{{--                            html += '<option value="' + json[i]['id'] + '"';--}}
{{--                            html += '>' + json[i]['batch_name'] + '</option>';--}}
{{--                        }--}}

{{--                        jQuery('select[name=\'batch_id\']').html(html);--}}

{{--                    }--}}
{{--                });--}}
{{--            }--}}

{{--        });--}}

{{--    });--}}
{{--</script>--}}

<script>
    function readURL(input) {
        if (input.files && input.files[0]) {

            var reader = new FileReader();
            reader.onload = function (e) {
                document.querySelector("#img").setAttribute("src",e.target.result);
            };

            reader.readAsDataURL(input.files[0]);
        }
    }

    function togglePassword(){
        var pass =document.getElementById('password');
        if(pass.type == 'password'){
            pass.type = 'text';
        }
        else {
            pass.type = 'password';
        }

    }
    function toggleConfirmPassword(){
        var pass_confirm =document.getElementById('password_confirmation');
        if(pass_confirm.type == 'password'){
            pass_confirm.type = 'text';
        }
        else {
            pass_confirm.type = 'password';
        }
    }
    $( '#select-field' ).select2( {
        theme: 'bootstrap-5'
    } );
    $( '#multiple-select-field' ).select2( {
        theme: "bootstrap-5",
        width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
        placeholder: $( this ).data( 'placeholder' ),
        closeOnSelect: false,
    } )


</script>

@endpush
