@extends('admin.master')
@section('title')
    FAQ Answer
@endsection
@section('content')
    <div class="card">
        <div class="card-header text-center">
            <h2><strong> FAQ Answer </strong></h2>
        </div>
        <div class="card-body card-block">
            <form action="{{ route('admin.Q-A.update', $answer->id) }}" method="post">
                @csrf
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="question" class=" form-control-label">Qustion
                        </label>
                        <input type="text" name="question" id="question"
                            class="form-control @error('question') is-invalid @enderror" value="{{ $answer->qustion }}"
                            readonly>
                        @error('question')
                            <div class="invalid-feedback" role="alert">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <input type="hidden" name="email" value="{{ $answer->email }}">
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="question" class=" form-control-label">Answer
                        </label>
                        <textarea name="answer" id="answer" class="form-control @error('answer') is-invalid @enderror" required></textarea>
                        @error('question')
                            <div class="invalid-feedback" role="alert">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">Submit Answer</button>
                    </div>
                </div>
            </form>
        </div>

    </div>
    </div>
@endsection
@push('script')
    <script>
        jQuery(document).ready(function() {
            var counter = 0;
            if (jQuery('#faq_counter').val() != null) {
                var counter = jQuery('#faq_counter').val();
            }


            jQuery('#addFaqBtn').click(function() {

                counter++;
                var html = `<div id="query${counter}">
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="company" class=" form-control-label">Question
                        <span class="text-danger">*</span><a class="btn btn-danger" onclick="removeFaq(${counter})"><i class="fa fa-minus text-white"></i></a></label>
                        <input type="text" name="question[]" id="company" class="form-control @error('question') is-invalid @enderror"
                               value="" required>
                        @error('question')
                        <div class="invalid-feedback" role="alert">{{ $message }}</div>
                        @enderror
                    </div>

                </div>

                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="" class="form-control-label">Answer</label>
                        <textarea name="answer[]" id="" cols="30" rows="10" class="form-control"></textarea>
                    </div>
                </div>
                </div>`;

                jQuery('#faq-container').append(html);
            });
        });
    </script>
    <script>
        function removeFaq(id) {

            jQuery('#query' + id).empty();
        }
    </script>
@endpush
