@extends('admin.master')
@section('title')
    @isset($item)Edit @else Add @endisset Course
@endsection
@section('content')
    <div class="card">
        <div class="card-header text-center">
            <h2><strong> @isset($item)Edit @else Add @endisset Course Form</strong></h2>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>
    </div>
    <form action="@isset($item){{route('admin.course.update')}}@else{{route('admin.course.submit')}}@endisset" method="post" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="" value="@isset($item){{ count($videos) }}@endisset" id=video-counter>
        <input type="hidden" name="" value="@isset($item){{ count($discussions) }}@endisset" id=discussion-counter>
        <input type="hidden" name="benefit_counter" value="@isset($item){{ count($benefits) }}@endisset" id=benefit-counter>
        <input type="hidden" name="branch_counter" value="@isset($item){{ count($batches) }}@else{{0}}@endisset" id=branch_counter>
        <input type="hidden" name="id" value="@isset($item){{$item->id}}@endisset">
        <div class="card">
            <div class="card-header">Course Information</div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="company" class=" form-control-label">Course Category
                            <span class="text-danger">*</span></label>
                        <select name="category_id" class="form-control @error('category_id') is-invalid @enderror" required>
                            <option value="">Select Category</option>
                            @foreach($categories as $category)
                                <option value="{{$category->id}}" @isset($item){{$item->category_id == $category->id ? 'selected':''}}@endisset>{{$category->name}}</option>
                            @endforeach
                        </select>
                        @error('category_id')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-6"><label for="company" class=" form-control-label">Course Name
                            <span class="text-danger">*</span></label>
                        <input type="text" name="course_name" id="company" class="form-control @error('course_name') is-invalid @enderror"
                               value="@isset($item){{$item->course_name}}@else{{old('course_name')}}@endisset" required>
                        @error('course_name')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-6"><label for="company" class=" form-control-label">Course Certificate Name</label>
                        <input type="text" id="company" name="crt_course_name"
                               class="form-control" value="@isset($item){{$item->crt_course_name}}@else{{old('crt_course_name')}}@endisset">
                    </div>
                    <div class="form-group col-md-6"><label for="company" class=" form-control-label">Introductory Video
                            <span class="text-danger">*</span></label>
                        <input type="text" name="intro_video" id="company" class="form-control @error('intro_video') is-invalid @enderror"
                               value="@isset($item){{$item->intro_video}}@else{{old('intro_video')}}@endisset" required>
                        @error('intro_video')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-3">
                        <label for="company" class=" form-control-label">Total Projects <span class="text-danger">*</span></label>
                        <input type="number" name="project" id="project" class="form-control"
                               value="@isset($item){{$item->project}}@else{{old('project')}}@endisset" required>
                        @error('project')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-3"><label for="" class="form-control-label">Course Type
                            <span class="text-danger">*</span></label>
                        <select name="course_type" id="course_type" class="form-control" required>
                            <option value="" selected>Select Course Type</option>
                            <option value="online" @isset($item){{$item->course_type == 'online' ? 'selected': ''}}@endisset>Online</option>
                            <option value="offline" @isset($item){{$item->course_type == 'offline' ? 'selected': ''}}@endisset>Offline</option>
                            <option value="online and offline" @isset($item){{$item->course_type == 'online and offline' ? 'selected': ''}}@endisset>Both</option>
                        </select>
                    </div>

                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-2"><label for="company" class=" form-control-label">Course Code
                            <span class="text-danger"></span></label>
                        <input type="text" name="course_code" id="company" class="form-control @error('course_code') is-invalid @enderror"
                               value="@isset($item){{$item->course_code}}@else{{old('course_code')}}@endisset" maxlength="2" readonly>
                        @error('course_code')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="" class="form-control-label">Course Duration<span
                                class="text-danger">*</span></label>
                        <select name="course_duration" id="" class="form-control" required>
                            <option value="">Select Duration</option>
                            @for($i=1; $i<12; $i++)
                                <option value="{{$i}} {{$i == 1 ? 'Month':'Months'}}"
                                        @isset($item)
                                            @if($item->course_duration == $i.' Month' or $item->course_duration == $i.' Months') selected @endif
                                    @endisset>
                                    {{$i}} {{$i == 1 ? 'Month':'Months'}}
                                </option>
                            @endfor
                            @for($i=1; $i<5; $i++)
                                <option value="{{$i}} {{$i == 1 ? 'Year':'Years'}}"
                                        @isset($item)
                                            @if($item->course_duration == $i.' Year' or $item->course_duration == $i.' Years') selected @endif
                                    @endisset>
                                    {{$i}} {{$i == 1 ? 'Year':'Years'}}</option>
                            @endfor
                        </select>
                        @error('course_duration')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
{{--                    <div class="form-group col-md-6">--}}
{{--                        <label for="company" class=" form-control-label">Course Link</label>--}}
{{--                        <input type="text" name="course_link" id="company" class="form-control"--}}
{{--                               value="@isset($item){{$item->course_link}}@else{{old('course_link')}}@endisset">--}}
{{--                    </div>--}}
                    <div class="form-group col-md-6"><label for="" class="form-control-label">Image <span class="text-danger"></span></label>
                        <input type="file" name="image" class="form-control" id="" accept="image/*" @isset($item) @else required @endisset>
                        @isset($item)
                            <img src="{{asset($item->image)}}" height="100px" width="100px" class="mt-2" alt="">
                        @endisset
                        <div id="note-container"></div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-3"><label for="vat" class=" form-control-label">Course Fee
                            <span class="text-danger">*</span></label>
                        <input type="number" id="company" name="course_fee"
                               class="form-control @error('course_fee') is-invalid @enderror"
                               value="@isset($item){{$item->course_fee}}@else{{old('course_fee')}}@endisset" required>
                        @error('course_fee')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-3"><label for="vat" class=" form-control-label">Discount</label>
                        <input type="number" id="company" name="discount"
                               class="form-control" value="@isset($item){{$item->discount}}@else{{old('discount')}}@endisset">
                    </div>
                    <div class="form-group col-md-3"><label for="vat" class=" form-control-label">Total Lectures
                            <span class="text-danger">*</span></label>
                        <input type="number" id="company" name="total_lectures"
                               class="form-control @error('total_lectures') is-invalid @enderror"
                               value="@isset($item){{$item->total_lectures}}@else{{old('total_lectures')}}@endisset" required>
                        @error('total_lectures')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-3"><label for="vat" class=" form-control-label">Start Date
                            <span class="text-danger">*</span></label>
                        <input type="date" id="company" name="start_date"
                               class="form-control @error('start_date') is-invalid @enderror"
                               value="@isset($item){{date('Y-m-d', strtotime($item->start_date))}}@else{{old('start_date')}}@endisset" required>
                        @error('start_date')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12" ><label for="" class="form-control-label">Course Description</label>
                        <textarea name="course_description"  class="summernote">@isset($item){{$item->course_description}}@else{{old('course_description')}}@endisset</textarea>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12" ><label for="" class="form-control-label">More About This Course</label>
                        <textarea name="more_about"  class="summernote">@isset($item){{$item->more_about}}@else{{old('more_about')}}@endisset</textarea>
                    </div>
                    <div class="col-md-12 mt-2">
                        <div class="form-check">
                            <input class="form-check-input" value="1" type="checkbox" name="is_show_more" id="is_show_more" @isset($item){{$item->is_show_more == 1 ? 'checked':''}}@endisset>
                            <label class="form-check-label" for="is_show_more">
                                Show This Section In Course Details?
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">Course Outcomes</div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="" class="form-control-label">Add Learning Outcomes</label><i
                            class="fa fa-plus text-success mx-2" id="addOutcomeBtn"></i>
                        @isset($item)
                            @foreach($learning_outcomes as $outcome)
                                <div class="form-check"><input type="checkbox" class="form-check-input" name="outcomes[]" id=""
                                                               checked
                                                               value="{{$outcome->content}}">
                                    <label for="" class="form-check-label">{{$outcome->content}}</label>
                                </div>
                            @endforeach
                        @endisset
                        <div id="outcome-container"></div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="" class="form-control-label">Add Software to Learn</label><i
                            class="fa fa-plus text-success mx-2" id="addSoftwareBtn"></i>
                        @isset($item)
                            @foreach($software_learning as $outcome)
                                <div class="form-check"><input type="checkbox" class="form-check-input" name="softwareCheck[]" id=""
                                                               checked
                                                               value="{{$outcome->id}}">
                                    <label for="" class="form-check-label">{{$outcome->content}}</label>

                                </div>
                                <img src="{{ asset($outcome->image) }}" alt="" height="50px" width="50px">
                            @endforeach
                        @endisset
                        <div id="software-container"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">Branch Assignment</div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="" class="form-control-label">Assign Branch With Batch</label><i
                            class="fa fa-plus text-success mx-2" id="addBranchBtn"></i>
                        @isset($batches)
                            @foreach($batches as $batch_key=> $batch)
                                <div id="branch_element{{$batch->id}}">
                                    <input type="hidden" name="batch_ids[]" value="{{$batch->id}}">
                                    <div class="row mb-3">
                                        <div class="col-md-12 mb-4">Branch & Batch Information <i class="fa fa-minus btn btn-danger" onclick="removeExistingBranch({{$batch->id}})"></i></div>
                                        <div class="form-group col-md-4"><label for="" class="form-control-label">Branch</label><span class="text-danger">*</span>
                                            <select name="branch_id[]" class="form-control" required>
                                                <option value="">Select Branch</option>
                                                @foreach($branches as $branch)
                                                    <option value="{{$branch->id}}" {{$batch->branch_id == $branch->id ? 'selected':''}}>
                                                        {{$branch->branch_name}}</option>
                                                @endforeach
                                            </select>

                                        </div>
                                        <div class="form-group col-md-4"><label for="" class="form-control-label">Session</label><span class="text-danger">*</span>
                                            <select name="session_id[]" class="form-control">
                                                <option value="">Select Session</option>
                                                @foreach($sessions as $session)
                                                    <option value="{{$session->id}}" {{$batch->session_id == $session->id ? 'selected':''}}>
                                                        {{$session->session_name}}</option>
                                                @endforeach
                                            </select>

                                        </div>
                                        <div class="form-group col-md-4"><label for="" class="form-control-label">Teacher</label><span class="text-danger">*</span>
                                            <select name="teacher_id[]" class="form-control">
                                                <option value="">Select Teacher</option>
                                                @foreach($teachers as $teacher)
                                                    <option value="{{$teacher->id}}" {{$batch->teacher_id == $teacher->id ? 'selected':''}}
                                                    >
                                                        {{$teacher->name}}</option>
                                                @endforeach
                                            </select>

                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="form-group col-md-4">
                                            <label for="" class="form-control-label">Batch Name</label><span class="text-danger">*</span>
                                            <input type="text" name="batch_name[]" class="form-control" placeholder="Enter Batch Name"
                                                   value="{{$batch->batch_name}}">

                                        </div>
                                        <div class="form-group col-md-4">
                                            <label for="" class="form-control-label">Max No of Students</label><span class="text-danger">*</span>
                                            <input type="number" name="max_student[]" placeholder="Enter Max No of Students" class="form-control "
                                                   value="{{$batch->max_student}}">

                                        </div>
                                        <div class="form-group col-md-4">
                                            <label for="" class="form-control-label">Time</label><span class="text-danger">*</span>
                                            <input type="text" name="time[]" placeholder="Enter Batch Time (AA:AA AM - BB:BB AM) " class="form-control"
                                                   value="{{$batch->time}}">

                                        </div>
                                        <div class="from-group col-md-4">
                                            <label for="">Days</label>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="days{{$batch_key+1}}[]" value="1" id="saturday" @isset($batch){{ $batch->days != null && in_array('1', json_decode($batch->days)) ? 'checked': ''}}@else checked @endisset>
                                                <label class="form-check-label" for="saturday">
                                                    Saturday
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="days{{$batch_key+1}}[]" value="2" id="sunday" @isset($batch){{ $batch->days != null && in_array('2', json_decode($batch->days)) ? 'checked': ''}}@else checked @endisset>
                                                <label class="form-check-label" for="sunday">
                                                    Sunday
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="days{{$batch_key+1}}[]" value="3" id="monday" @isset($batch){{ $batch->days != null && in_array('3', json_decode($batch->days)) ? 'checked': ''}}@else checked @endisset>
                                                <label class="form-check-label" for="monday">
                                                    Monday
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="4" name="days{{$batch_key+1}}[]" id="tuesday" @isset($batch){{ $batch->days != null && in_array('4', json_decode($batch->days)) ? 'checked': ''}}@else checked @endisset>
                                                <label class="form-check-label" for="tuesday">
                                                    Tuesday
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="5" name="days{{$batch_key+1}}[]" id="wednesday" @isset($batch){{ $batch->days != null && in_array('5', json_decode($batch->days)) ? 'checked': ''}}@else checked @endisset>
                                                <label class="form-check-label" for="wednesday">
                                                    Wednesday
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="6" name="days{{$batch_key+1}}[]" id="thursday" @isset($batch){{ $batch->days != null && in_array('6', json_decode($batch->days)) ? 'checked': ''}}@else checked @endisset>
                                                <label class="form-check-label" for="thursday">
                                                    Thursday
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="7" name="days{{$batch_key+1}}[]" id="friday" @isset($batch){{ $batch->days != null && in_array('7', json_decode($batch->days)) ? 'checked': ''}}@else checked @endisset>
                                                <label class="form-check-label" for="friday">
                                                    Friday
                                                </label>
                                            </div>

                                        </div>
                                        <div class="form-group col-md-4"><label for=""
                                                                                class="form-control-label">Batch Type</label><select
                                                name="batch_type[]" id="" class="form-control batch_type">
                                                @if($item->course_type == 'online')
                                                    <option value="1" selected>Online</option>

                                                @elseif($item->course_type == 'offline')
                                                    <option value="2" selected>Offline</option>
                                                @else
                                                    <option value="1" {{$batch->batch_type == '1' ? 'selected':''}}>Online</option>
                                                    <option value="2" {{$batch->batch_type == '2' ? 'selected':''}}>Offline</option>
                                                @endif
                                            </select></div>

                                    </div>
                                </div>
                            @endforeach
                        @endisset
                        <div id="branch_container">

                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="card">
            <div class="card-header">Course Contents</div>
            <div class="card-body">
                <div class="row mb-3">

                    <div class="form-group col-md-12"><label for="" class="form-control-label">Notes</label>
                        <input type="file" name="note[]" class="form-control" id="" multiple>
                        @isset($item)
                            @foreach($notes as $note)
                                <div class="form-check"><input type="checkbox" class="form-check-input" name="noteCheck[]" id=""

                                                               value="{{$note->id}}" checked>
                                    <label for="" onclick="downloadFile()" class="form-check-label">{{Str::after($note->resource, 'uploads/course-files/')}}</label>
                                </div>
                            @endforeach
                        @endisset

                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="" class="form-control-label">Add Video Tutorials</label><i
                            class="fa fa-plus text-success mx-2" id="addLinkBtn"></i>
                        @isset($item)
                            @foreach($videos as $video)
                                <div class="form-group input-group" id="video{{ $video->id }}">
                                    <i class="fa fa-minus btn btn-danger mx-2" onclick="deleteVideo({{ $video->id }})"></i>
                                    <input type="text" class="form-control" class="form-check-input mx-2" name="video_title[]" value="{{$video->title}}" placeholder="Title" required>
                                    <input type="text" class="form-control" class="form-check-input" name="video[]" value="{{$video->resource}}" placeholder="Link" required>
                                </div>
                            @endforeach
                        @endisset
                        <div id="link-container"></div>
                    </div>

                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="" class="form-control-label">Add Discussion</label><i
                            class="fa fa-plus text-success mx-2" id="addDiscussionBtn"></i>
                        @isset($item)
                            @foreach($discussions as $key=>$discussion)
                                <div class="form-group" id="discussion{{ $discussion->id }}">
                                    <label for="" class="form-control-label">Discussion</label>
                                    <i class="fa fa-minus btn btn-danger mx-2" onclick="deleteDiscussion({{ $discussion->id }})"></i>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <label for="" class="form-control-label">Title</label>
                                            <input type="text" class="form-control form-check-input mx-2" name="discussion_title[]" value="{{$discussion->title}}" placeholder="Title" required>
                                        </div>
                                        <div class="col-md-12">
                                            <label for="" class="form-control-label">Content</label>
                                            <textarea class="form-control summernote" name="discussion[]" id="" cols="30" rows="10" required>{{ $discussion->resource }}</textarea>
                                        </div>
                                    </div>

                                </div>
                            @endforeach
                        @endisset
                        <div id="discussion-container"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">Course Benefits</div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-12 mb-3"><label for="" class="form-control-label">Course Benefits</label><i
                            class="fa fa-plus text-success mx-2" id="addBenefitsBtn"></i></div>
                    <div class="col-md-12" id="benefit_container">
                        @isset($benefits)
                            @foreach($benefits as $key=> $benefit)
                                <div class="row" id="benefit{{$key+1}}">
                                    <div class="col-md-12 mb-3">Enter Information <i class="fa fa-minus btn btn-danger" onclick="deleteBenefit({{$key+1}})"></i></div>
                                    <div class="col-md-6 mb-3"><label for="" class="form-control-label">Image <span class="text-danger">*</span></label><input type="file"
                                                                                                                                                               name="existing_thumbnail_{{$benefit->id}}" class="form-control" accept="image/*">
                                        <input type="hidden" name="benefits[]" value="{{$benefit->id}}">
                                        <img src="{{asset($benefit->thumbnail)}}" class="mt-2 w-25"  alt="">
                                    </div>
                                    <div class="col-md-6 mb-3"><label for="" class="form-control-label">Title <span class="text-danger">*</span></label><input type="text"
                                                                                                                                                               name="existing_benefit[]" value="{{$benefit->benefit}}" class="form-control" required>
                                    </div>
                                    <div class="col-md-12 mb-3"><label for="" class="form-control-label">Description <span class="text-danger">*</span></label><input type="text"
                                                                                                                                                                      name="existing_description[]"  value="{{$benefit->description}}"  class="form-control" required>
                                    </div>
                                </div>
                            @endforeach
                        @endisset

                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">Projects</div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-12" id="project_container">
                        @isset($projects)
                            @foreach($projects as $key=> $project)
                                <div class="row" id="project{{$key+1}}">
                                    <div class="col-md-12 mb-3">Enter Information <i class="fa fa-minus btn btn-danger" onclick="deleteProject({{$key+1}})"></i></div>
                                    <div class="col-md-6 mb-3"><label for="" class="form-control-label">Image <span class="text-danger">*</span></label><input type="file"
                                                                                                                                                               name="existing_project_thumbnail{{$project->id}}" class="form-control" accept="image/*" >
                                        <input type="hidden" name="projects[]" value="{{$project->id}}">
                                        <img src="{{asset($project->thumbnail)}}" class="mt-2 w-25"  alt="">
                                    </div>
                                    <div class="col-md-6 mb-3"><label for="" class="form-control-label">Title <span class="text-danger">*</span></label><input type="text"
                                                                                                                                                               name="existing_project_name[]" value="{{$project->name}}" maxlength="68" class="form-control" required>
                                    </div>
                                    <div class="col-md-12 mb-3"><label for="" class="form-control-label">Description <span class="text-danger">*</span></label><input type="text"
                                                                                                                                                                      name="existing_project_description[]"  value="{{$project->description}}"  class="form-control" required></div>
                                </div>
                            @endforeach
                        @endisset
                    </div>
                    <div class="col-md-12 mt-5">
                        <div class="form-check">
                            <input class="form-check-input" value="1" type="checkbox" name="is_show_project" id="is_show_project" @isset($item){{$item->is_show_project == 1 ? 'checked':''}}@endisset>
                            <label class="form-check-label" for="is_show_project">
                                Show Projects On Course Page
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">Other Information</div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-8">
                        <div class="row">

                            <div class="form-group col-md-6"><label for="" class="form-control-label">Course Medium</label>
                                <select name="course_medium_id" id="course" class="form-control">
                                    <option value="" >Select Course Medium</option>
                                    <option value="1" selected>Bangla</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="" class="form-control-label">Trending Status</label>
                                <div class="form-check">
                                    <input class="form-check-input" value="1" type="radio" name="is_trending" id="flexRadioDefault1" @isset($item){{$item->is_trending == 1 ? 'checked':''}}@endisset >
                                    <label class="form-check-label" for="flexRadioDefault1">
                                        Trending
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" value="0" type="radio" name="is_trending" id="flexRadioDefault2" checked>
                                    <label class="form-check-label" for="flexRadioDefault2">
                                        Not Trending
                                    </label>
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="" class="form-control-label">Course Status</label>
                                <div class="form-check">
                                    <input class="form-check-input" value="1" type="radio" name="course_status_id" id="flexRadioDefault3" checked>
                                    <label class="form-check-label" for="flexRadioDefault3">
                                        Active
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" value="0" type="radio" name="course_status_id" id="flexRadioDefault4" @isset($item){{$item->course_status_id == 0 ? 'checked':''}}@endisset>
                                    <label class="form-check-label" for="flexRadioDefault4">
                                        Inactive
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" value="2" type="radio" name="course_status_id" id="flexRadioDefault5" @isset($item){{$item->course_status_id == 2 ? 'checked':''}}@endisset>
                                    <label class="form-check-label" for="flexRadioDefault5">
                                        Upcoming
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-md-4">
                        <label for="" class="form-control-label">Add Prerequisite Courses</label>
                        <i class="fa fa-plus text-success mx-2" id="addSubjectBtn"></i>
                        @isset($item)
                            @foreach($modules as $module)
                                <div class="form-check"><input type="checkbox" class="form-check-input" name="modules[]" id=""
                                                               {{$module->course_id == $item->id ? 'checked':''}}
                                                               value="{{$module->module_name}}">
                                    <label for="" class="form-check-label">{{$module->module_name}}</label>
                                </div>
                            @endforeach
                        @endisset
                        <div id="subject-container" class="mt-2"></div>
                    </div>

                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">@isset($item)Update @else Add @endisset Course Information</button>
                    </div>
                </div>
            </div>
        </div>







    </form>

@endsection
@push('script')
    <script>
        jQuery(document).ready(function(){
           var counter=0;

           jQuery('#addSubjectBtn').click(function(){
               counter ++;
               // const inputField = jQuery('<input>').attr({
               //     type:'text',
               //     name: 'modules[]',
               //     class: 'form-control mb-2',
               //     placeholder: 'Enter Module Name'
               // });

               var html = `<div class="form-group input-group" id="module${counter}">
                                     <i class="fa fa-minus btn btn-danger mx-2" onclick="deleteModule(${counter})"></i> <br>
                                    <input type="text" class="form-control" class="form-control mb-2" placeholder="Enter Module Name" name= "modules[]" value="" required>
                                </div>`
               ;

               jQuery('#subject-container').append(html);
            });
        });
    </script>
    <script>
        jQuery(document).ready(function(){
           var counter=0;

           jQuery('#addOutcomeBtn').click(function(){
               counter ++;
               // const inputField = jQuery('<input>').attr({
               //     type:'text',
               //     name: 'outcomes[]',
               //     class: 'form-control mb-2',
               //     placeholder: 'Enter Course Outcome',
               //     required: true
               // });
               var html = `<div class="form-group input-group" id="outcome${counter}">
                                     <i class="fa fa-minus btn btn-danger mx-2" onclick="deleteOutcome(${counter})"></i> <br>
                                    <input type="text" class="form-control" class="form-check-input" placeholder="Enter Course Outcome" name= "outcomes[]" value="" required>
                                </div>`
               ;

               jQuery('#outcome-container').append(html);
            });
        });
    </script>
    <script>
        jQuery(document).ready(function(){
           var counter=0;

           jQuery('#addSoftwareBtn').click(function(){
               counter ++;
               var html = `<div class="form-group input-group" id="software${counter}">
                                     <i class="fa fa-minus btn btn-danger mx-2" onclick="deleteSoftware(${counter})"></i> <br>
                                    <input type="file" class="form-control" class="form-check-input" name="software_image[]" value="" accept="image/*" required>
                                    <input type="text" class="form-control" class="form-check-input" placeholder="Software Name" name="software_name[]" value="" required>
                                </div>`
               ;

               jQuery('#software-container').append(html);
            });
        });
    </script>
    <script>
        jQuery(document).ready(function(){
            var counter=0;

            jQuery('#addLinkBtn').click(function(){
                counter ++;
                // const inputField = jQuery('<input>').attr({
                //     type:'text',
                //     name: 'video[]',
                //     class: 'form-control mb-2',
                //     placeholder: 'Enter Video Link'
                // });
                var html=`
                <div class="form-group input-group" id="video${counter}">
                                    <i class="fa fa-minus btn btn-danger mx-2" onclick="deleteVideo(${counter})"></i>
                                    <input type="text" class="form-control" class="form-check-input" name="video_title[]" value="" placeholder="Video Title" required>
                                    <input type="text" class="form-control" class="form-check-input" name="video[]" placeholder="Video URL" value="" required>
                                </div>
                `;

                jQuery('#link-container').append(html);
                // jQuery('#link-container').append(inputField);
            });
        });
    </script>
    <script>
        jQuery(document).ready(function(){
            var counter=0;

            jQuery('#addDiscussionBtn').click(function(){
                counter ++;
                var html = `
                <div class="form-group" id="discussion${counter}">
                                    <label for="" class="form-control-label">Discussion</label>
                                    <i class="fa fa-minus btn btn-danger mx-2" onclick="deleteDiscussion(${counter})"></i> <br>
                                    <label for="" class="form-control-label">Title</label>
                                    <input type="text" class="form-control" class="form-check-input" name="discussion_title[]" value="" required>
                                    <label for="" class="form-control-label">Content</label>
                                    <textarea class="form-control summernote" name="discussion[]" id="" cols="30" rows="10" required></textarea>
                                </div>
                `;
                // const label = jQuery('<label>').attr({
                //     class: 'form-control-label',
                //     placeholder: 'Enter Discussion'
                // });
                // const inputField = jQuery('<textarea>').attr({
                //     name: 'discussion[]',
                //     class: 'form-control mb-2',
                //     placeholder: 'Enter Discussion'
                // });

                // jQuery('#discussion-container').append(inputField);
                jQuery('#discussion-container').append(html);

            });
        });
    </script>
    <script>
        function deleteVideo(id){

            jQuery('#video'+id).remove();
        }
        function deleteDiscussion(id){

        jQuery('#discussion'+id).remove();
        }

        function deleteSoftware(id){

            jQuery('#software'+id).remove();
        }

        function deleteOutcome(id){

            jQuery('#outcome'+id).remove();
        }
        function deleteModule(id){

            jQuery('#module'+id).remove();
        }
        function deleteBenefit(id){

            jQuery('#benefit'+id).remove();
            var counter = parseInt(jQuery('#benefit-counter').val());
            jQuery('#benefit-counter').val(counter-1);
        }
        function deleteProject(id){

            jQuery('#project'+id).remove();
            var counter = parseInt(jQuery('#project').val());
            jQuery('#project').val(counter-1);
        }
    </script>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script>
        jQuery(document).ready(function() {
            jQuery('.summernote').summernote();
      });
    </script>
    <script>
        jQuery(document).ready(function(){
            var counter=0;

            jQuery('#addBenefitsBtn').click(function(){
                var benefits = parseInt(jQuery('#benefit-counter').val());
                jQuery('#benefit-counter').val(benefits+1);
                counter ++;
                var html = `<div class="row" id="benefit${counter}">
                            <div class="col-md-12 mb-3">Enter Information <i class="fa fa-minus btn btn-danger" onclick="deleteBenefit(${counter})"></i></div>
                            <div class="col-md-6 mb-3"><label for="" class="form-control-label">Image <span class="text-danger">*</span></label><input type="file"
                                                                                                                   name="thumbnail[]" class="form-control" accept="image/*" required>
                            </div>
                            <div class="col-md-6 mb-3"><label for="" class="form-control-label">Title <span class="text-danger">*</span></label><input type="text"
                                                                                                                   name="benefit[]" class="form-control" required>
                            </div>
                            <div class="col-md-12 mb-3"><label for="" class="form-control-label">Description <span class="text-danger">*</span></label><input type="text"
                                                                                                                       name="description[]"    class="form-control" required>
                            </div>
                        </div>`
                ;

                jQuery('#benefit_container').append(html);
            });
        });
    </script>
    <script>
        jQuery(document).ready(function(){
            jQuery('#project').on('input',function () {
                var project = parseInt(jQuery('#project').val());
                if(project != '')
                {
                    jQuery('#project_container').empty();
                    for(var i=0; i<project; i++){
                        var html = `<div class="row" id="project${i}">
                            <div class="col-md-12 mb-3">Enter Information <i class="fa fa-minus btn btn-danger" onclick="deleteProject(${i})"></i></div>
                            <div class="col-md-6 mb-3"><label for="" class="form-control-label">Image <span class="text-danger">*</span></label><input type="file"
                                                                                                                   name="project_thumbnail[]" class="form-control" accept="image/*" required>
                            </div>
                            <div class="col-md-6 mb-3"><label for="" class="form-control-label">Title <span class="text-danger">*</span></label><input type="text"
                                                                                                                   name="project_name[]" maxlength="68" class="form-control" required>
                            </div>
                            <div class="col-md-12 mb-3"><label for="" class="form-control-label">Description <span class="text-danger">*</span></label><input type="text"
                                                                                                                       name="project_description[]"    class="form-control" required>
                            </div>
                        </div>`
                        ;

                        jQuery('#project_container').append(html);
                    }
                }
            })


        });
    </script>
    <script>
        jQuery('#addBranchBtn').click(function () {
            var branch_counter = parseInt(jQuery('#branch_counter').val());
            console.log(branch_counter);


            branch_counter++;
            jQuery('#branch_counter').val(branch_counter);
            var html = `
            <div id="branch_element${branch_counter}">
            <div class="row mb-3">
            <div class="col-md-12 mb-4">Branch & Batch Information <i class="fa fa-minus btn btn-danger" onclick="removeBranch(${branch_counter})"></i></div>
                                <div class="form-group col-md-4"><label for="" class="form-control-label">Branch</label><span class="text-danger">*</span>
                                    <select name="branch_id[]" class="form-control" required>
                                        <option value="">Select Branch</option>
                                        @foreach($branches as $branch)
            <option value="{{$branch->id}}">
                                                {{$branch->branch_name}}</option>
                                        @endforeach
            </select>

            </div>
            <div class="form-group col-md-4"><label for="" class="form-control-label">Session</label><span class="text-danger">*</span>
                <select name="session_id[]" class="form-control">
                                        <option value="">Select Session</option>
                                        @foreach($sessions as $session)
            <option value="{{$session->id}}">
                                                {{$session->session_name}}</option>
                                        @endforeach
            </select>

            </div>
            <div class="form-group col-md-4"><label for="" class="form-control-label">Teacher</label><span class="text-danger">*</span>
                <select name="teacher_id[]" class="form-control">
                                        <option value="">Select Teacher</option>
                                        @foreach($teachers as $teacher)
            <option value="{{$teacher->id}}"
                                            >
                                                {{$teacher->name}}</option>
                                        @endforeach
            </select>

            </div>
        </div>
        <div class="row mb-3">
            <div class="form-group col-md-4">
                <label for="" class="form-control-label">Batch Name</label><span class="text-danger">*</span>
                <input type="text" name="batch_name[]" class="form-control" placeholder="Enter Batch Name"
                                           value="">

            </div>
            <div class="form-group col-md-4">
                <label for="" class="form-control-label">Max No of Students</label><span class="text-danger">*</span>
                <input type="number" name="max_student[]" placeholder="Enter Max No of Students" class="form-control "
                                           value="">

            </div>
            <div class="form-group col-md-4">
                <label for="" class="form-control-label">Time</label><span class="text-danger">*</span>
                <input type="text" name="time[]" placeholder="Enter Batch Time (AA:AA AM - BB:BB AM) " class="form-control"
                                           value="">

            </div>


            <div class="from-group col-md-4">
                <label for="">Days</label>
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="days${branch_counter}[]" value="1" id="saturday">
                                        <label class="form-check-label" for="saturday">
                                            Saturday
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="days${branch_counter}[]" value="2" id="sunday">
                                        <label class="form-check-label" for="sunday">
                                            Sunday
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="days${branch_counter}[]" value="3" id="monday">
                                        <label class="form-check-label" for="monday">
                                            Monday
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="4" name="days${branch_counter}[]" id="tuesday" >
                                        <label class="form-check-label" for="tuesday">
                                            Tuesday
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="5" name="days${branch_counter}[]" id="wednesday">
                                        <label class="form-check-label" for="wednesday">
                                            Wednesday
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="6" name="days${branch_counter}[]" id="thursday" >
                                        <label class="form-check-label" for="thursday">
                                            Thursday
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="7" name="days${branch_counter}[]" id="friday" >
                                        <label class="form-check-label" for="friday">
                                            Friday
                                        </label>
                                    </div>

                                </div>


            `;

            html+=`<div class="form-group col-md-3"><label for="" class="form-control-label">Batch Type
                    <span class="text-danger">*</span></label>
                    <select name="batch_type[]" class="form-control batch_type" required>`;
            html+= addBatchType();
            html+= `</div>
                            </div>`;
            jQuery('#branch_container').append(html);
        })
    </script>
    <script !src="">
        function removeBranch(id) {
            if(confirm('Please Confirm Before Removing!!')){
                console.log('ok');
            }
            jQuery('#branch_element'+id).empty();
        }
        function removeExistingBranch(id) {
            if(confirm('Please Confirm Before Removing!!')){
                jQuery('#branch_element'+id).empty();
                jQuery.ajax({
                    method:'GET',
                    url:'{{route('batch.remove.existing')}}',
                    data:{
                        id:id
                    },
                    success:function (data) {
                        if(data){
                            console.log(data);
                            alert('Batch Remove Successfully!!');
                        }
                        else{
                            alert('Could not Remove Batch!!');
                        }
                    }

                })
            }

        }
    </script>
    <script>
        function addBatchType(){
            var course_type = jQuery('#course_type').val();
            var batch_html = ``
            if(course_type == 'online'){

                batch_html += `
                        <option value="1" selected>Online</option>`;

                batch_html+=`</select>
                </div>`;
            }
            else if(course_type == 'offline'){
                batch_html += `
                        <option value="2" selected>Offline</option>
                    </select>
                </div>`;
            }
            else{
                batch_html += `
                        <option value="1" >Online</option>
                        <option value="2" >Offline</option>
                    </select>
                </div>`;
            }
            return batch_html;
        }
    </script>
    <script>
        jQuery('#course_type').change(function () {
            var html = addBatchType();
            jQuery('.batch_type').html(html);
        })
    </script>

@endpush

