@extends('admin.master')
@php
    $route = Route::currentRouteName();
@endphp
@section('title')
    @if($route == 'admin.course.enrollment.list')
    Course Enrollment
    @else
    Course Enrollment Requests
    @endif
@endsection
@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success">{{session('message')}}</h4>
                            <h3 class="text-center">
                                <strong>

                                    @if($route == 'admin.course.enrollment.list')
                                        View Enrollment
                                    @else
                                        View Enrollment Requests
                                    @endif

                                </strong>
                        </h3>

                        </div>

                    </div>
                    <hr>

                    <div class="row">
                        <div class="col-md-12">
                            <form id="filterForm">
                                <div class="row">
                                    <div class="form-group col-sm-4">
                                        <label for="" class="form-control-label">Student Roll</label>
                                        <input name="student_roll" id="student_roll" placeholder="Enter Student Roll" onchange="filter()" type="text" class="form-control" value="@isset($_GET['student_roll']){{$_GET['student_roll']}}@endisset">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <label for="" class="form-control-label">Year</label>
                                        <select name="year" id="year" onchange="filter()" class="form-control">
                                            <option value="">All</option>
                                            @for($i=2018; $i<=date('Y'); $i++)
                                                <option value="{{$i}}" @isset($_GET['year']) @if($i == $_GET['year']) selected @endif @endisset>{{$i}}</option>
                                            @endfor
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label for="" class="form-control-label">Course</label>
                                        <select name="course_id" id="course_id" onchange="filter()" class="form-control">
                                            <option value="">All</option>
                                            @foreach($courses as $course)
                                                <option value="{{$course->id}}" @isset($_GET['course_id']) @if($course->id == $_GET['course_id']) selected @endif @endisset>{{$course->course_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @if($route == 'admin.course.enrollment.list')
                                        <div class="form-group col-sm-3">
                                            <label for="" class="form-control-label">Batch</label>
                                            <select name="batch_id" id="session_id" onchange="filter()" class="form-control">
                                                <option value="">All</option>
                                                @isset($batches)
                                                    @foreach($batches as $batch)
                                                        <option value="{{$batch->id}}" @isset($_GET['batch_id']) @if($batch->id == $_GET['batch_id']) selected @endif @endisset>{{$batch->batch_name}}</option>
                                                    @endforeach
                                                @endisset
                                            </select>
                                        </div>
                                    @endif

                                </div>

                            </form>
                        </div>
                    </div>

                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Student Name <br>Roll</th>
                            <th>Course Name<br><span class="second-line">Course Code</span></th>
                            <th>Branch Name<br></th>
                            <th>Batch Name</th>
                            <th>Fee<br><span class="second-line">Discount</span></th>
                            <th>Paid<br><span class="second-line">Due</span></th>
                            <th>Payment Method<br><span class="second-line">Account Number</span></th>
                            <th>Status<br><span class="second-line"></span></th>
                            <th>Action</th>
                            @if($route == 'admin.course.enrollment.list')
                            {{-- <th>Download</th> --}}
                            @endif
                        </tr>
                        @php $i=1; @endphp
                        @foreach($items as $item)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$item->student->student_name ?? ''}}<br><span>{{$item->branchStudent->student_roll ?? ''}}</span></td>
                                <td>{{$item->course->course_name ?? ''}}<br><span>{{$item->course->course_code ?? ''}}</span></td>
                                <td>{{$item->branch->branch_name ?? ''}}</td>
                                <td>{{$item->batch->batch_name ?? ''}}</td>
                                <td>{{$item->total_fee}}<br><span>{{$item->discount}}</span></td>
                                <td>{{$item->total_paid}}<br><span>{{$item->due}}</span></td>
                                <td>{{$item->payment_method}}<br><span>{{$item->payment_number}}</span></td>
                                <td class="text-center">
                                    <div class="mb-2">
                                        <span class="{{$item->status == 1 || $item->status == 3 ? 'bg-success':'bg-danger'}} p-2 text-white" style="border-radius:5px">
                                            @if($item->status == 1)
                                                Approved
                                            @elseif($item->status == 2)
                                            Rejected
                                            @elseif($item->status == 3)
                                                Completed
                                            @else
                                            Pending
                                            @endif
                                        </span>
                                    </div>
                                    </td>
                                @if($route != 'admin.course.enrollment.list')
                                    <td class="btn-group">
                                        <a  title="Approve" href="{{ route('admin.course.enrollment.edit', ['id' => $item->id]) }}" class="btn btn-primary"><i class="fa fa-check-circle"></i></a>
                                        <a  title="Reject" onclick="changeStatus(0, {{ $item->id }})" class="btn btn-danger mx-2"><i class="fa fa-trash"></i></a>
                                        <form action="{{route('admin.course.enrollment.status.change')}}" id="statusChangeForm{{ $item->id }}" method="post">
                                            @csrf
                                            <input type="hidden" name="id" value="{{$item->id}}">
                                            <input type="hidden" name="status" id="status{{ $item->id }}" value="">

                                        </form>
                                    </td>
                                @else
                                    <td class="btn-group">
                                        <form action="{{route('admin.course.enrollment.delete')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="id" value="{{$item->id}}">
                                            <button class="btn btn-danger"><i class="fa fa-trash"></i></button>
                                        </form>
                                        @if($item->status == 3)
                                            <a  onclick="test({{$item->branchStudent->id}})" class="btn btn-info mx-2"><i class="fa fa-download"></i></a>

                                        @endif

                                    </td>
                                    @if($route == 'admin.course.enrollment.list')
                                        {{-- <td>
                                            <a href="{{route('student.admit.print', ['id'=>$item->id])}}" class="btn btn-warning" style="border-radius: 4px;" title="Download Admit Card"><i class="fa fa-ticket" aria-hidden="true"></i></a>
                                            <a href="#" onclick="test({{$item->id}})" class="btn btn-success me-2" style="border-radius: 4px;" title="Download Certificate"><i class="fa fa-file"></i></a>

                                        </td> --}}
                                    @endif
                                @endif
                            </tr>
                        @endforeach
                    </table>
                    {{$items->links('pagination::bootstrap-5')}}
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
<script>
    function changeStatus(val, id){
        alert(val);
        jQuery('#status'+id).val(val);
        jQuery('#statusChangeForm'+id).submit();
    }
    function test(id){
        url = '{{route('admin.student.certificate.print',":id")}}'
        url = url.replace(':id', id);
        var test_window = window.open(url);
        test_window.onload = function() {
            // Trigger the print functionality for the new window
            test_window.print();
        }
        // Open a new window or tab with the URL of the page you want to print
    }
</script>
</script>

@endpush
