@extends('admin.master')

@section('title')
Enroll In Course
@endsection
@push('css')
    <style>
        .select2-container--default .select2-selection--single {
            height: calc(2.25rem + 2px);
            color: #495057;
        }
    </style>
@endpush
@section('content')
    <div class="card">
        <div class="card-header text-center">
            <h2><strong> @isset($item)Edit @else Enroll @endisset Course Form</strong></h2>
            <h4 class="text-danger">{{ Session('message') }}</h4>
        </div>
        <div class="card-body card-block">
            <form action="@isset($item){{ route('admin.course.enrollment.update') }}@else{{route('admin.course.enrollment.store')}}@endisset" method="post" enctype="multipart/form-data">
                @csrf
                @isset($item)
                    <input type="hidden" name="id" value="@isset($item){{$item->id}}@endisset">
                @endisset
                <div class="row mb-3">
                    <div class="form-group col-md-6">
                        <label for="" class="form-control-label">Student</label>
                        <select class="js-example-basic-single form-control @error('student_id') is-invalid @enderror" name="student_id" required>
                            <option value="">Select</option>
                            @foreach ($students as $student)
                                <option value="{{ $student->id }}"
                                    @isset($item)
                                        {{ $item->student_id == $student->id ? 'selected':''}}
                                    @endisset>
                                    {{ $student->student_name }}-{{ $student->branchStudent->student_roll ?? '' }}</option>
                            @endforeach
                          </select>
                          @error('student_id')
                            <div class="invalid-feedback" role="alert">{{ $message }}</div>
                          @enderror
                    </div>
                    <div class="form-group col-md-6">
                        <label for="" class="form-control-label">Course</label>
                        <select name="course_id" id="course_id" class="form-control @error('course_id') is-invalid @enderror" required>
                            <option value="">Select</option>
                            @foreach ($courses as $course)
                            @if($course->course_status_id == 1)
                            <option value="{{ $course->id }}"
                                @isset($item)
                                {{ $item->course_id == $course->id ? 'selected':''}}
                                @endisset
                            >{{ $course->course_name }}</option>
                            @endif
                            @endforeach
                        </select>
                        @error('course_id')
                        <div class="invalid-feedback" role="alert">{{ $message }}</div>
                      @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="" class="form-control-label">Branch</label>
                        <select name="branch_id" id="branch_id" class="form-control @error('branch_id') is-invalid @enderror" required>
                            <option value="">Select</option>
                            @isset($branches)
                                @foreach ($branches as $branch)

                                    <option value="{{ $branch->id }}"
                                    @isset($item)
                                        {{ $item->branch_id == $branch->id ? 'selected':''}}
                                        @endisset
                                    >{{ $branch->branch_name }}</option>

                                @endforeach
                            @endisset
                        </select>
                        @error('branch_id')
                        <div class="invalid-feedback" role="alert">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="" class="form-control-label">Batch</label>
                        <select name="batch" id="batch_id" class="form-control @error('batch_id') is-invalid @enderror" required>
                            <option value="">Select</option>
                            @isset($batches)
                            @foreach ($batches as $batch)
                            <option value="{{ $batch->id }}"
                                @isset($item)
                                {{ $item->batch_id == $batch->id ? 'selected':''}}
                                @endisset
                                >{{ $batch->batch_name }}</option>

                            @endforeach
                            @endisset
                        </select>
                        @error('batch_id')
                        <div class="invalid-feedback" role="alert">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="" class="form-control-label">Batch Type</label>
                        <select name="course_type" id="batch_type" class="form-control @error('batch_type') is-invalid @enderror" required>
                            <option value="">Select</option>
                            @isset($item)
                                @if($item->course->course_type == 'online')
                                    <option value="online" {{ $item->course_type == 'online' ? 'selected' : '' }}>Online</option>
                                @elseif($item->course->course_type == 'offline')
                                    <option value="offline" {{ $item->course_type == 'offline' ? 'selected' : '' }}>Offline</option>
                                @elseif($item->course->course_type == 'online and offline')
                                    <option value="online" {{ $item->course_type == 'online' ? 'selected' : '' }}>Online</option>
                                    <option value="offline" {{ $item->course_type == 'offline' ? 'selected' : '' }}>Offline</option>
                                @endif
                            @endisset
                        </select>
                        @error('batch_type')
                        <div class="invalid-feedback" role="alert">{{ $message }}</div>
                        @enderror
                    </div>


                </div>
                <div class="row mb-3">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header text-center"><h3><strong>Payment Information</strong></h3></div>
                            <div class="card-body">
                                <div class="row mb-3">
                                    <input type="hidden" name="enrolled_by" value="2">
                                    <div class="form-group col-md-4">
                                        <label for="" class="form-control-label">Course Fee</label>
                                        <input type="text" name="course_fee" id="course_fee" class="form-control" placeholder="Enter Course Fee" value="@isset($item){{$item->course_fee}}@else{{old('course_fee')}}@endisset" required>
                                        @error('course_fee')
                                            <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label for="" class="form-control-label">Discount</label>
                                        <input type="text" name="discount" id="discount" class="form-control" placeholder="Enter Discount" value="@isset($item){{$item->discount}}@else{{old('discount')}}@endisset" required>
                                        @error('discount')
                                            <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label for="" class="form-control-label">Total Fee</label>
                                        <input type="text" name="total_fee" id="total_fee" class="form-control" placeholder="Enter Total Fee" value="@isset($item){{$item->total_fee}}@else{{old('total_fee')}}@endisset" required readonly>
                                        @error('total_fee')
                                            <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label for="" class="form-control-label">Total Paid</label>
                                        <input type="text" name="total_paid" id="total_paid" class="form-control" placeholder="Enter Total Paid Amount" value="@isset($item){{$item->total_paid}}@else{{old('total_paid')}}@endisset" required>
                                        @error('total_paid')
                                            <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label for="" class="form-control-label">Total Due</label>
                                        <input type="text" name="due" id="due" class="form-control" placeholder="Enter Total Due Amount" value="@isset($item){{$item->due}}@else{{old('due')}}@endisset" required readonly>
                                        @error('due')
                                            <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label for="" class="form-control-label">Payment Method</label>
                                        <select name="payment_method" id="" class="form-control @error('payment_method') is-invalid @enderror" required>
                                            <option value="Cash" @isset($item){{ $item->payment_method == 'Cash' ? 'selected':'' }} @endisset>Cash</option>
                                            <option value="Bkash" @isset($item){{ $item->payment_method == 'Bkash' ? 'selected':'' }} @endisset>Bkash</option>
                                            <option value="Rocket" @isset($item){{ $item->payment_method == 'Rocket' ? 'selected':'' }} @endisset>Rocket</option>
                                            <option value="Nagad" @isset($item){{ $item->payment_method == 'Nagad' ? 'selected':'' }} @endisset>Nagad</option>
                                            <option value="Upay" @isset($item){{ $item->payment_method == 'Upay' ? 'selected':'' }} @endisset>Upay</option>
                                        </select>
                                        @error('payment_method')
                                            <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="" class="form-control-label">Payment Number</label>
                                        <input type="text" name="payment_number" class="form-control" placeholder="Enter Payment Number" value="@isset($item){{$item->payment_number}}@else{{old('payment_number')}}@endisset">
                                        @error('payment_number')
                                            <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="form-group col-md-3">
                        <label for="" class="form-control-label">Enrollment Status</label>
                        <div class="form-check">
                            <input class="form-check-input" value="1" type="radio" name="status" id="flexRadioDefault3" checked>
                            <label class="form-check-label" for="flexRadioDefault1">
                                Active
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" value="0" type="radio" name="status" id="flexRadioDefault4"
                            @isset($item){{$item->status != 1 ? 'checked':''}}@endisset>
                            <label class="form-check-label" for="flexRadioDefault2">
                                Inactive
                            </label>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">@isset($item)Update Enrollment @else Enroll Into Course @endisset  </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
<script>
    jQuery(document).ready(function() {
    jQuery('.js-example-basic-single').select2();
});
</script>
<script>
    jQuery('#branch_id').change(function () {
       var branch_id = jQuery('#branch_id').val();
       var course_id = jQuery('#course_id').val();
       jQuery('#batch_id').empty()
       if(branch_id != ''){
           jQuery.ajax({
               method: 'GET',
               url: '{{route('get-batch-by-branch-course')}}',
               data: {
                   branch_id: branch_id,
                   course_id: course_id,
               },
               success:function (data) {
                   console.log(data);
                   var html = `<option>Select Batch</option>`;
                   jQuery.each(data.batches, function (key, batch) {
                       html += `<option value="${batch.id}">${batch.batch_name} (${batch.time})</option>`;
                   });

                   jQuery('#batch_id').append(html);
               }
           })
       }
    });
</script>
<script>
    jQuery('#course_id').change(function () {
       var branch_id = jQuery('#branch_id').val();
       var course_id = jQuery('#course_id').val();
       jQuery('#batch_id').empty()
       jQuery('#batch_type').empty()
       if(course_id != ''){
           jQuery.ajax({
               method: 'GET',
               url: '{{route('get-batch-by-branch-course')}}',
               data: {
                   branch_id: branch_id,
                   course_id: course_id,
               },
               success:function (data) {
                   console.log(data);
                   var html = `<option>Select Batch</option>`;
                   jQuery.each(data.batches, function (key, batch) {
                       html += `<option value="${batch.id}">${batch.batch_name} (${batch.time})</option>`;
                   });
                   jQuery('#batch_id').append(html);
                   
                   var html = `<option>Select Type</option>`;
                   if(data.course){
                       if(data.course.course_type === 'online'){
                           html += `<option value="online">Online</option>`;
                       }
                       else if(data.course.course_type === 'offline'){
                           html += `<option value="offline">Offline</option>`;
                       }
                       else if(data.course.course_type === 'online and offline'){
                           html += `<option value="online">Online</option>`;
                           html += `<option value="offline">Offline</option>`;
                       }
                   }
                   jQuery('#batch_type').append(html);
               }
           })
       }
    });
</script>
<script>
    jQuery(document).ready(function() {
        function calculateFees() {
            var courseFee = parseFloat(jQuery("#course_fee").val()) || 0;
            var discount = parseFloat(jQuery("#discount").val()) || 0;
            var totalPaid = parseFloat(jQuery("#total_paid").val()) || 0;

            // Calculate Total Fee after Discount
            var totalFee = courseFee - discount;
            jQuery("#total_fee").val(totalFee.toFixed(2));

            // Calculate Due Amount
            var due = totalFee - totalPaid;
            jQuery("#due").val(due.toFixed(2));
        }

        // Trigger calculation on input and keyup events
        jQuery("#course_fee, #discount, #total_paid").on("input keyup", calculateFees);

        // Initial Calculation when page loads
        calculateFees();
        
        jQuery('#batch_type').change(function () {
            var course_id = jQuery('#course_id').val();
            var batch_type = jQuery(this).val();
            
            if(course_id != ''){
               jQuery.ajax({
                   method: 'GET',
                   url: '{{route('get-course-by-id')}}',
                   data: {
                       course_id: course_id,
                   },
                   success:function (data) {
                       if(data.course){
                           console.log(batch_type);
                           if(batch_type === 'online'){
                                var courseFee = parseFloat(data.course.course_fee) || 0;
                                var discount = parseFloat(data.course.discount) || 0;
                                
                                jQuery("#course_fee").val(courseFee);
                                jQuery("#discount").val(discount);
                                
                                calculateFees();
                           }
                           else if(batch_type === 'offline'){
                                var courseFee = parseFloat(data.course.offline_course_fee) || 0;
                                var discount = parseFloat(data.course.offline_discount) || 0;
                                
                                jQuery("#course_fee").val(courseFee);
                                jQuery("#discount").val(discount);
                                
                                calculateFees();
                           }
                       }
                   }
               })
           }
        });
    });
</script>
@endpush
