@extends('admin.master')
@section('content')
    <section class="content-main">
        <div class="row">
            {{-- <div class="col-md-10">
            <h3 class="content-title">Coupon list </h3>
            <strong style="font-weight: bold" class="text-dark"> {{ count($coupons) }} Coupons Found </strong>
        </div> --}}
            {{-- <div class="col-md-2">
            <a href="{{ route('admin.coupons.create') }}" class="btn btn-primary" title="Coupon Create"><i class="material-icons md-plus"></i></a>
        </div> --}}
            <div class="col-md-6"></div>
            <div class="col-md-6">
                <a href="{{ route('admin.coupons.create') }}" class="btn btn-info float-right">Add New</a>
            </div>
        </div>

        <div class="card mb-4 mt-3">
            @foreach (['success', 'error', 'warning', 'info'] as $msg)
                @if (session()->has($msg))
                    <div class="alert alert-{{ $msg }}">
                        {{ session()->get($msg) }}
                    </div>
                @endif
            @endforeach
            <div class="card-body">
                <div class="table-responsive">
                    <table id="example" class="table table-bordered table-striped" width="100%">
                        <thead>
                            <tr>
                                <th scope="col">Sl</th>
                                <th scope="col">Type</th>
                                <th scope="col">Coupon Code</th>
                                <th scope="col">Discount Type</th>
                                <th scope="col">Amount</th>
                                {{-- <th scope="col">User Limit</th> --}}
                                <th scope="col">Total Limit</th>
                                <th scope="col">Expired Date</th>
                                <th scope="col">Status</th>
                                <th scope="col" class="text-end">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($coupons as $key => $coupon)
                                <tr>
                                    <td> {{ $key + 1 }} </td>
                                    <td> {{ $coupon->type == 2 ? 'Offer Coupon':'Course Coupon' }} </td>
                                    <td> {{ $coupon->coupon_code ?? 'NULL' }} </td>
                                    @if ($coupon->discount_type == 1)
                                        <td> Fixed Amount </td>
                                    @else
                                        <td> Percent </td>
                                    @endif
                                    <td> {{ $coupon->discount ?? 'NULL' }} </td>
                                    {{-- <td> {{ $coupon->limit_per_user ?? 'NULL' }} </td> --}}
                                    <td> {{ $coupon->total_use_limit ?? 'NULL' }} </td>
                                    <td> {{ $coupon->expire_date ?? 'NULL' }} </td>
                                    <td>
                                        @if ($coupon->status == 1)
                                            <a href="{{ route('admin.coupon.in_active', ['id' => $coupon->id]) }}">
                                                <span class="status badge rounded-pill alert-success">Active</span>
                                            </a>
                                        @else
                                            <a href="{{ route('admin.coupon.active', ['id' => $coupon->id]) }}"> <span
                                                    class="status badge rounded-pill alert-danger">Disable</span></a>
                                        @endif
                                    </td>

                                    <td>@php $offer = \App\Models\Offer::where('coupon_id', $coupon->id)->first() @endphp
                                        @if($offer)
                                            <a href="{{ route('admin.offer.edit', $offer->id) }}" class="btn btn-info"><i
                                                    class="fa fa-edit"></i> Edit</a>
                                        @else
                                        <a href="{{ route('admin.coupons.edit', $coupon->id) }}" class="btn btn-info"><i
                                                class="fa fa-edit"></i> Edit</a>
                                        @endif
                                        <a href="{{ route('admin.coupon.delete', $coupon->id) }}" class="btn btn-danger"
                                            onclick="if(!confirm('Are You Sure?')){ return false }">
                                            <i class="fa fa-trash">
                                            </i> Delete</a>
                                    </td>

                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
                <!-- table-responsive //end -->
            </div>
            <!-- card-body end// -->
        </div>
    </section>
@endsection
