@extends('admin.master')
@section('content')
    <section class="content-main">
        <div class="row justify-content-center">
            <div class="row">
                <div class="col-md-10 mx-auto">
                    <form method="post" action="{{ route('admin.coupons.update', $coupon->id) }}"
                        enctype="multipart/form-data">
                        @csrf

                        <div class="card">
                            <div class="card-header">
                                <h3>Edit Coupon</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4 mb-4">
                                        <label for="coupon_code" class="col-form-label" style="font-weight: bold;">Course: *</label>
                                        <select name="course_id" id="" class="form-control" >
                                            <option value="0">All</option>
                                            @foreach($courses as $course)
                                                <option value="{{$course->id}}" {{ $coupon->course_id == $course->id ? 'selected':'' }}>{{$course->course_name}}</option>
                                            @endforeach

                                        </select>
                                        @error('course_id')
                                        <p class="text-danger">{{$message}}</p>
                                        @enderror
                                    </div>
                                    <div class="col-md-4 mb-4">
                                        <label for="coupon_code" class="col-form-label" style="font-weight: bold;">Coupon
                                            Code: *</label>
                                        <input class="form-control" id="coupon_code" type="text" name="coupon_code"
                                            placeholder="Write Coupon Code" required=""
                                            value="{{ $coupon->coupon_code }}">
                                        @error('coupon_code')
                                            <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="col-md-4 mb-4">
                                        <label for="discount_type" class="col-form-label"
                                            style="font-weight: bold;">Discount Type:</label>
                                        <div class="custom_select">
                                            <select class="form-control select-active w-100 form-select select-nice"
                                                name="discount_type" id="discount_type">
                                                <option value="1" @if ($coupon->discount_type == '1') selected @endif>
                                                    Fixed Amount</option>
                                                <option value="0" @if ($coupon->discount_type == '0') selected @endif>
                                                    Percent %</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <label for="discount" class="col-form-label" style="font-weight: bold;">Discount
                                            Amount/Percent: *</label>
                                        <input class="form-control" id="discount" type="number" name="discount"
                                            placeholder="Write discount amount/percent" required min="0"
                                            value="{{ $coupon->discount }}">
                                        @error('discount')
                                            <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <label for="total_use_limit" class="col-form-label" style="font-weight: bold;">Total
                                            Use Limit: *</label>
                                        <input class="form-control" id="total_use_limit" type="number"
                                            name="total_use_limit" placeholder="Enter total use limit" required
                                            min="0" value="{{ $coupon->total_use_limit }}">
                                        @error('total_use_limit')
                                            <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>
                                    <div class="col-md-6 mb-4">
                                        <label for="limit_per_user" class="col-form-label" style="font-weight: bold;">Use Limit Per User: *</label>
                                        <input class="form-control" id="limit_per_user" type="number" name="limit_per_user" placeholder="Write use limit per user" min="0" value="0">
                                        @error('limit_per_user')
                                        <p class="text-danger">{{$message}}</p>
                                        @enderror
                                    </div>

                                    <div class="col-md-12 mb-4">
                                        <label for="expire_date" class="col-form-label" style="font-weight: bold;">Expire
                                            Date:</label>
                                        <input class="form-control" id="expire_date" type="date" name="expire_date"
                                            min="0" value="{{ $coupon->expire_date }}">
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-4">
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" class="form-check-input me-2 cursor" name="status"
                                                id="status" {{ $coupon->status == 1 ? 'checked' : '' }} value="1">
                                            <label class="form-check-label cursor" for="status">Status</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-4 justify-content-sm-end">
                                    <div class="col-lg-3 col-md-4 col-sm-5 col-6 mt-4">
                                        <input type="submit" class="btn btn-primary" value="Update">
                                    </div>
                                </div>
                                <!-- Row //-->
                            </div>
                            <!-- card body .// -->
                        </div>
                        <!-- card .// -->


                    </form>
                </div>
            </div>
            <!-- .row // -->
        </div>
    </section>
@endsection
