@extends('admin.master')
@section('title')
    @isset($item)Edit @else Add @endisset Batch
@endsection
@section('content')
    <div class="card mx-3">
        <div class="card-header text-center">
            <h2><strong> @isset($item)Edit @else Add @endisset Batch Form</strong></h2>
        </div>
        <div class="card-body card-block">
            <form action="@isset($item){{route('batch.update')}}@else{{route('batch.submit')}}@endisset" method="post">
                @csrf
                <input type="hidden" name="id" value="@isset($item){{$item->id}}@endisset">
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="" class="form-control-label">Branch</label><span class="text-danger">*</span>
                        <select name="branch_id" class="form-control @error('branch_id') is-invalid @enderror" required>
                            <option value="">Select Branch</option>
                            @foreach($branches as $branch)
                                <option value="{{$branch->id}}"
                                @isset($item){{$item->branch_id == $branch->id ? 'selected': ''}}@endisset>
                                    {{$branch->branch_name}}</option>
                            @endforeach
                        </select>
                        @error('branch_id')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4"><label for="" class="form-control-label">Course</label><span class="text-danger">*</span>
                        <select name="course_id" id="course_id" class="form-control @error('course_id') is-invalid @enderror" required>
                            <option value="">Select Course</option>
                            @foreach($courses as $course)
                                <option value="{{$course->id}}"
                                @isset($item){{$item->course_id == $course->id ? 'selected': ''}}@endisset>
                                    {{$course->course_name}}</option>
                            @endforeach
                        </select>
                        @error('course_id')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4"><label for="" class="form-control-label">Session</label><span class="text-danger">*</span>
                        <select name="session_id" class="form-control @error('session_id') is-invalid @enderror">
                            <option value="">Select Session</option>
                            @foreach($sessions as $session)
                                <option value="{{$session->id}}"
                                @isset($item){{$item->session_id == $session->id ? 'selected': ''}}@endisset>
                                    {{$session->session_name}}</option>
                            @endforeach
                        </select>
                        @error('session_id')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4"><label for="" class="form-control-label">Teacher</label><span class="text-danger">*</span>
                        <select name="teacher_id" class="form-control @error('teacher_id') is-invalid @enderror">
                            <option value="">Select Teacher</option>
                            @foreach($teachers as $teacher)
                                <option value="{{$teacher->id}}"
                                @isset($item){{$item->teacher_id == $teacher->id ? 'selected': ''}}@endisset>
                                    {{$teacher->name}}</option>
                            @endforeach
                        </select>
                        @error('teacher_id')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-4">
                        <label for="" class="form-control-label">Batch Name</label><span class="text-danger">*</span>
                        <input type="text" name="batch_name" class="form-control @error('batch_name') is-invalid @enderror" placeholder="Enter Batch Name"
                               value="@isset($item){{$item->batch_name}}@else{{old('batch_name')}}@endisset">
                        @error('batch_name')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="" class="form-control-label">Max No of Students</label><span class="text-danger">*</span>
                        <input type="number" name="max_student" class="form-control @error('max_student') is-invalid @enderror"
                               value="@isset($item){{$item->max_student}}@else{{old('max_student')}}@endisset">
                        @error('max_student')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="" class="form-control-label">Time</label><span class="text-danger">*</span>
                        <input type="text" name="time" class="form-control @error('time') is-invalid @enderror"
                               value="@isset($item){{$item->time}}@else{{old('time')}}@endisset">
                        @error('time')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="from-group col-md-4">
                        <label for="">Days</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="days[]" value="1" id="saturday" @isset($item){{ $item->days != null && in_array('1', json_decode($item->days)) ? 'checked': ''}}@else checked @endisset>
                            <label class="form-check-label" for="saturday">
                                Saturday
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="days[]" value="2" id="sunday" @isset($item){{ $item->days != null && in_array('2', json_decode($item->days)) ? 'checked': ''}}@else checked @endisset>
                            <label class="form-check-label" for="sunday">
                                Sunday
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="days[]" value="3" id="monday" @isset($item){{ $item->days != null && in_array('3', json_decode($item->days)) ? 'checked': ''}}@else checked @endisset>
                            <label class="form-check-label" for="monday">
                                Monday
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="4" name="days[]" id="tuesday" @isset($item){{ $item->days != null && in_array('4', json_decode($item->days)) ? 'checked': ''}}@else checked @endisset>
                            <label class="form-check-label" for="tuesday">
                                Tuesday
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="5" name="days[]" id="wednesday" @isset($item){{ $item->days != null && in_array('5', json_decode($item->days)) ? 'checked': ''}}@else checked @endisset>
                            <label class="form-check-label" for="wednesday">
                                Wednesday
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="6" name="days[]" id="thursday" @isset($item){{ $item->days != null && in_array('6', json_decode($item->days)) ? 'checked': ''}}@else checked @endisset>
                            <label class="form-check-label" for="thursday">
                                Thursday
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="7" name="days[]" id="friday" @isset($item){{ $item->days != null && in_array('7', json_decode($item->days)) ? 'checked': ''}}@else checked @endisset>
                            <label class="form-check-label" for="friday">
                                Friday
                            </label>
                        </div>

                    </div>
                    <div class="form-group col-md-4"><label for="" class="form-control-label">Batch Type</label><span class="text-danger">*</span>
                        <select name="batch_type" id="batch_type" class="form-control @error('batch_type') is-invalid @enderror" required>
                            @isset($item)
                                @if($item->batch_type == 1)
                                    <option value="1" selected>Online</option>
                                @elseif($item->batch_type == 2)
                                    <option value="2" selected>Offline</option>
                                @else
                                    <option value="1" {{$item->batch_type == '1' ? 'selected':''}}>Online</option>
                                    <option value="2" {{$item->batch_type == '2' ? 'selected':''}}>Offline</option>
                                @endif
                            @endisset
                        </select>
                        @error('batch_type')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="" class="form-control-label">Status</label>
                        <div class="form-check">
                            <input class="form-check-input" value="1" type="radio" name="status" id="flexRadioDefault1" checked>
                            <label class="form-check-label" for="flexRadioDefault1">
                                Active
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" value="0" type="radio" name="status" id="flexRadioDefault2"
                            @isset($item){{$item->status != 1 ? 'checked':''}}@endisset>
                            <label class="form-check-label" for="flexRadioDefault2">
                                Inactive
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">@isset($item)Update @else Add @endisset Batch</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
    <script>
        jQuery('#course_id').change(function () {
            var course_id = jQuery('#course_id').val();
            jQuery.ajax({
                method:'GET',
                url: '{{route('admin.get-course-by-id')}}',
                data:{
                    course_id:course_id,
                },
                success:function (data) {
                    console.log(data);
                    var html = ``;
                    if(data != null){

                        if(data.course_type == 'online'){
                            html = `<option value="1" selected>Online</option>`
                        }
                        else if(data.course_type == 'offline'){
                            html = `<option value="2" selected>Offline</option>`
                        }
                        else{
                            html = `<option value="1" >Online</option>
                                    <option value="2" >Offline</option>`;
                        }
                    }

                    jQuery('#batch_type').html(html);
                }
            })
        })
    </script>
@endpush
