@extends('admin.master')
@section('title')
    Completion Request List
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success">{{session('message')}}</h4>
                            <h3 class="text-center"><strong>View Completion Request List</strong></h3>
                        </div>
                    </div>

                    <hr>
                    <form action="" id="filterForm">
                        <div class="row mb-3">
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Course</label>
                                <select name="course_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    @foreach($courses as $course)
                                        <option value="{{$course->id}}" @isset($_GET['course_id']){{$_GET['course_id'] == $course->id ? 'selected':''}}@endisset>{{$course->course_name}}</option>
                                    @endforeach
                                </select>

                            </div>
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Teacher</label>
                                <select name="teacher_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    @foreach($teachers as $teacher)
                                        <option value="{{$teacher->id}}"
                                        @isset($_GET['teacher_id']){{$_GET['teacher_id'] == $teacher->id ? 'selected':''}}@endisset>
                                            {{$teacher->name}}</option>
                                    @endforeach

                                </select>
                            </div>

                        </div>

                    </form>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Batch Name</th>
                            <th>Course Name<br><span class="second-line">Session Name</span></th>
                            <th>Assigned Teacher</th>
                            <th>Total Student / <br> Max Students</th>
{{--                            <th>Status</th>--}}
                            <th>Action</th>
                        </tr>
                        @php $i=1; @endphp
                        @foreach($items as $item)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$item->batch_name}}</td>
                                <td>{{$item->course->course_name ?? ''}}<br><span>{{$item->session->session_name ?? ''}}</span></td>
                                <td>{{$item->teacher->name}}</td>
                                @php $total_student = \App\Models\CourseEnrollment::where('batch_id', $item->id)->where('status', 1)->count() @endphp
                                <td>{{$total_student}}/<span>{{$item->max_student}}</span></td>

{{--                                <td class="text-center">--}}
{{--                                    <div class="mb-2">--}}
{{--                                        <span class="{{$item->status == 1 ? 'bg-success':'bg-danger'}} p-2 text-white" style="border-radius:5px">--}}
{{--                                    {{$item->status == 1 ? 'Active':'Inactive'}}</span>--}}
{{--                                    </div>--}}
{{--                                </td>--}}

                                <td class="btn-group">
                                    <a title="Approve" class="btn btn-primary" onclick="submitForm({{$item->id}}, 1)"><i class="fa fa-check"></i></a>
                                    <a title="Reject" class="btn btn-danger" style="margin-left: 5px" onclick="submitForm({{$item->id}}, 0)"><i class="fa fa-trash"></i></a>
                                </td>
                            </tr>
                        @endforeach
                        <form action="{{route('batch.completion.request.status.change')}}" id="statusChangeForm" method="post">
                            @csrf
                            <input type="hidden" name="id" id="status_id" value="">
                            <input type="hidden" name="status" id="status">
                        </form>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <script >
        function submitForm(id, value){
            jQuery('#status_id').val(id);
            jQuery('#status').val(value);
            jQuery('#statusChangeForm').submit();
        }
    </script>
@endpush
